#include "RBP2.inc"

.org _asm_exec_ram

Start:
 call _clrScrn
 call _homeup
 call _flushallmenus
 call _op1set0
 call _stoAns
 res 5,(iy+$00)
 set 4,(iy+$0c)
 xor a
 ld (logtype),a    ;used to change type of "Log" var
 ld hl,dummy_menu
 call _ASAPloadmenu
 jp _disp_menu
 
menu_circle_code:         ;loads circle editor
 bit 0,(iy+$29)
 jr nz,menu_ellipse_code  ;if selector is switched to "Ellipse",load the ellipse editor
 ld a,$0d                 ;dummy menu has a type $01 slot--MUST restore ROM page to prevent crash!
 out (5),a
 res 4,(iy+$0c)           ;unlock keyboard
 ld hl,context
 call _set_context         ;set context vectors for menus
 ld hl,calc_menu
 call _ASAPloadmenu
 call _disp_menu           ;load and display menu
 call init_circle_vars  ;initialize vars--MUST do this!
reset_circle: 
 ld hl,title1
 call _setTitle         ;set title of editor
 call clear_window      ;clear between _winTop and _winBtm
 ld hl,circle_table
loadup_table: 
 ld (_numedTbl),hl      ;load editor table
 call _adispnumvars     ;display editor
 ld a,1
 ld (_curRow),a         ;set to edit first row
 jp _aseteditcurrent    ;edit vars in editor
 
menu_ellipse_code:      ;loads ellipse editor
 ld a,$0d
 out (5),a
 res 4,(iy+$0c)
 ld hl,context
 call _set_context
 ld hl,calc_menu
 call _ASAPloadmenu
 call _disp_menu
 call init_ellipse_vars
reset_ellipse:  
 ld hl,title1
 call _setTitle
 call clear_window
 ld hl,ellipse_table
 jr loadup_table      ;load editor and display
 
clear_window:    ;loads window parameters and clears window
 ld hl,$0701
 ld (_winTop),hl
 jp _clrWindow 
 
switch_circle:      ;this code is called when selector is switched
 call _amode_exec        ;switch selector
 bit 0,(iy+$29)            ;\
 jr nz,menu_ellipse_code   ; > Find out which editor to load and load it
 jp menu_circle_code       ;/
 
menu_log_code:
 ld a,$0d
 out (5),a
 res 4,(iy+$0c)
 ld hl,context
 call _set_context
 ld hl,key_handler_log   ;sets the key handler to use this instead of previous handler
 ld (_cxMain),hl
 ld hl,calc_menu
 call _ASAPloadmenu
 call _disp_menu
reset_log:            ;same as above
 call init_log_vars 
 ld hl,title2
 call _setTitle  
 call clear_window
 ld hl,log_table
 jr loadup_table 
 
init_circle_vars:  ;this routine initializes the circle editor vars. You need a routine to
 call _op1set0     ;initialize your vars before displaying the editor.
 rst 18h           ;push OP1 to FP stack--required for _stoOther routine
 ld hl,rad-1       ;load _OP1 with first var
 rst 20h
 rst 10h           ;find var
 jr nc,skip0       ;skip it if it exists--we don't want to overwrite any previous contents
 call _stoOther
skip0:
 call _op1set0
 rst 18h 
 ld hl,area-1
 rst 20h
 rst 10h
 jr nc,skip1
 call _stoOther
skip1:
 call _op1set0
 rst 18h
 ld hl,circ-1
 rst 20h
 rst 10h
 ret nc
 jp _stoOther
 
init_ellipse_vars: ;code to initialize ellipse editor vars
 call _op1set0
 rst 18h 
 ld hl,hrad-1
 rst 20h
 rst 10h
 jr nc,skip2
 call _stoOther
skip2: 
 call _op1set0
 rst 18h 
 ld hl,vrad-1
 rst 20h
 rst 10h
 jr nc,skip3
 call _stoOther 
skip3:
 call _op1set0
 rst 18h 
 ld hl,area-1
 rst 20h
 rst 10h
 jr nc,skip4
 call _stoOther
skip4:
 call _op1set0
 rst 18h
 ld hl,perimeter-1
 rst 20h
 rst 10h
 ret nc
 jp _stoOther

circle_clear:       ;code to reset circle editor vars to zero
 call chk_mode_obj  ;if cursor is on a mode selector item, don't clear
 ret z
 call _isEditEmpty  ;if no value for var, don't clear
 ret z
 call _aclosefield  ;close editor field before clearing
 call _op1set0
 rst 18h
 ld hl,rad-1
 rst 20h
 call _stoOther
 call _op1set0
 rst 18h
 ld hl,area-1
 rst 20h
 call _stoOther
 call _op1set0
 rst 18h
 ld hl,circ-1
 rst 20h
 call _stoOther
 jp reset_circle  ;reload circle editor
 
ellipse_clear:      ;code to reset ellipse editor vars to zero
 call chk_mode_obj
 ret z
 call _isEditEmpty
 ret z
 call _aclosefield
 call _op1set0
 rst 18h
 ld hl,hrad-1
 rst 20h
 call _stoOther
 call _op1set0
 rst 18h
 ld hl,vrad-1
 rst 20h
 call _stoOther
 call _op1set0
 rst 18h
 ld hl,area-1
 rst 20h
 call _stoOther
 call _op1set0
 rst 18h
 ld hl,perimeter-1
 rst 20h
 call _stoOther
 jp reset_ellipse  ;reload ellipse editor    

circle_code:
 bit 0,(iy+$29)
 jr nz,ellipse_code  ;if mode selector is switched than call ellipse editor code
 ld a,(_curRow)      ;get row in a
 cp 2
 jp z,calc_radius    ;are we solving for radius? if so,execute its code
 cp 3
 jp z,calc_area      ;are we solving for area? if so,execute its code
 cp 4
 jp z,calc_circ      ;are we solving for circumference? if so,execute its code
 ret                 ;wait for a keypress

ellipse_code:
 ld a,(_curRow)          ;get row in a
 cp 2
 jp z,calc_horiz_radius  ;are we solving for horizontal radius? if so,execute its code
 cp 3
 jp z,calc_vert_radius   ;are we solving for vertical radius? if so,execute its code
 cp 4
 jp z,calc_area          ;are we solving for area? if so,execute its code
 cp 5
 jp z,calc_perimeter     ;are we solving for perimeter? if so,execute its code
 ret                     ;wait for a keypress

calc_radius:     ;solve for radius
 ld hl,area-1
 rst 20h
 call _rclVarSym       ;recall contents of _OP1 var to _OP1
 call _ERRD_OP1NOTPOS  ;ERROR 04 DOMAIN if value is negative
 call _ckop1fp0        ;check if area is unknown
 jr z,use_circ         ;if so, use the circumference to find the radius  
 ld a,4
 call _GETCON          ;this gets PI to _OP2
 call _FPDIV           ;_OP1/_OP2-->_OP1
 call _SQROOT          ;sqrt(_OP1)-->_OP1
rad_finish: 
 call _RecalledOp1     ;recall answer into editor
 jp calc_finish        ;finish up calculation
 
use_circ:
 call div_circ_by_2pi  ;divide circumference by 2*PI
 jr rad_finish

div_circ_by_2pi:
 ld hl,circ-1
 rst 20h
 call _rclVarSym   ;retrieve value of circumference
div_perim_by_2pi:  
 call _TIMESPT5    ;_OP1/2-->_OP1
 ld a,4 
 call _GETCON      ;this gets PI to _OP2
 jp _FPDIV         ;_OP1/_OP2-->_OP1
 
calc_area:
 bit 0,(iy+$29)
 jr nz,calc_ellipse_area  ;if selector switched solve for ellipse area
 ld hl,rad-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 call _ckop1fp0
 call z,div_circ_by_2pi
 call _FPSQUARE         ;_OP1^2-->_OP1
 ld a,4
 call _GETCON
 rst 28h               ;_FPMULT: _OP1*_OP2-->_OP1
 call _RecalledOp1
 jp calc_finish
 
calc_ellipse_area:
 ld hl,hrad-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 rst 08h
 ld hl,vrad-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 rst 28h
 ld a,4
 call _GETCON
 rst 28h
 call _RecalledOp1
 jp calc_finish
 
calc_horiz_radius:
 ld hl,area-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 call _ckop1fp0
 jr z,use_perimeter_vert  ;if area is unknown, use vertical radius to find horiz radius...
 ld hl,vrad-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
calc_other_radius: 
 ld a,4
 call _GETCON
 rst 28h
 rst 08h        ;_OP1-->_OP2
 ld hl,area-1
 rst 20h
 call _rclVarSym       ;...otherwise use the area to find horiz radius
 call _ERRD_OP1NOTPOS
 call _FPDIV
 call _RecalledOp1
 jp calc_finish
 
calc_vert_radius:
 ld hl,area-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 call _ckop1fp0
 jr z,use_perimeter_horiz  ;if area is unknown, use horiz radius to find vertical radius...
 ld hl,hrad-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 jr calc_other_radius
 
use_perimeter_horiz:
 ld hl,perimeter-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1_LE_0
 call div_perim_by_2pi
 call _FPSQUARE
 call _TIMES2      ;_OP1*2-->_OP1
 call _pushrealo1  ;push _OP1 to FP stack (save value)
 ld hl,hrad-1
use_perim_finish: 
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 call _FPSQUARE
 rst 08h
 call _poprealo1    ;pop value from FP stack into _OP1 (retrieve value)
 call _FPSUB
 call _SQROOT
 call _RecalledOp1
 jp calc_finish 
 
use_perimeter_vert:
 ld hl,perimeter-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1_LE_0
 call div_perim_by_2pi
 call _FPSQUARE
 call _TIMES2
 call _pushrealo1
 ld hl,vrad-1
 jr use_perim_finish 
 
calc_perimeter:
 ld hl,hrad-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 call _FPSQUARE
 call _op1toop6       ;_OP1-->_OP6  
 ld hl,vrad-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 call _FPSQUARE
 call _op6toop2       ;_OP6-->_OP2
 rst 30h
 call _TIMESPT5
 call _SQROOT
 call _pushrealo1
 ld a,4
 call _GETCON1
 call _TIMES2
 call _poprealo2   ;pop value on FP stack into _OP2
 rst 28h
 call _RecalledOp1
 jr calc_finish                     
 
use_area: 
 ld hl,area-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 ld a,4
 call _GETCON
 call _FPDIV
 jp _SQROOT 
 
calc_circ:
 ld hl,rad-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1NOTPOS
 call _ckop1fp0
 call z,use_area
 ld a,4
 call _GETCON
 rst 28h
 call _TIMES2
 call _RecalledOp1
calc_finish:
 set 6,(iy+$00)    ;required to clear indicators
 ld de,1
 call _clearbal_asap  ;clear indicators
 ld a,(_curRow)
 ld c,$d0
 jp _setIndicator   ;set indicator at row in (_curRow)

init_log_vars:   ;code to initialize log editor vars
 ld a,$0d
 out (5),a
 call _op1set0
 rst 18h
 ld hl,logvar1-1
 rst 20h 
 rst 10h
 jr nc,log_skip0
 call _stoOther
log_skip0: 
 call _op1set0
 rst 18h
 ld hl,logvar2-1
 rst 20h 
 rst 10h
 jr nc,log_skip1
 call _stoOther
log_skip1:
 call _op1set0      ;_OP1=FP 0
 bit 1,(iy+$29)
 call nz,init_cplx   ;if selector switched store complex (0,0) to var, otherwise store 0 to var
 rst 18h 
 ld hl,log_stoname-1
 rst 20h
 rst 10h 
 ret nc
 jp _stoOther
     
logx_clear:
 call _isEditEmpty
 ret z
 call chk_mode_obj
 ret z
 call _aclosefield 
 call _op1set0
 rst 18h
 ld hl,logvar1-1
 rst 20h
 call _stoOther
 call _op1set0
 rst 18h
 ld hl,logvar2-1
 rst 20h  
 call _stoOther
 call _op1set0
 bit 1,(iy+$29)
 call nz,init_cplx  ;if selector switched store complex (0,0) to var, otherwise store 0 to var
 rst 18h
 ld hl,log_stoname-1
 rst 20h
 call _stoOther
 jp reset_log     ;reload log editor
 
logx_code:
 call chk_mode_obj  ;don't calculate if cursor is on selector
 ret z
 ld a,(_curRow)  ;get row
 cp 2
 jr z,calc_num   ;are we solving for Number? if so, execute its code
 cp 3
 jp z,calc_base  ;are we solving for Base? if so, execute its code
 bit 1,(iy+$29)
 jp z,logx_real  ;if selector is on "Real", solve for real num
 jp logx_cplx    ;otherwise, solve for complex num
  
switch_logx:       ;called when selector is changed
 call _amode_exec  ;change selector
 jr set_log_real   ;set "Log" var to type real
switch_ret: 
 call _clrWindow   
 jp reset_log     ;reload log editor
 
set_log_real:
 bit 1,(iy+$29)
 jr nz,set_log_cplx  ;if selector is switched, set "Log" var to type cplx
 xor a
 ld (logtype),a      ;logtype = 0 (real #)
 ld hl,log_stoname-1
 rst 20h
 call _rclVarSym     ;get value of var
 call _SETOP1REAL    ;set as type real
 jr store            ;store value to var
 
set_log_cplx:
 ld a,1
 ld (logtype),a       ;logtype = 1 (complex #)
 ld hl,log_stoname-1
 rst 20h
 call _rclVarSym
 call _OP2SET0CPLX    ;set _OP1/_OP2 to complex (0,0)
store:                ;store value
 rst 18h
 ld hl,log_stoname-1
 rst 20h
 call _stoOther
 jr switch_ret      ;reload log editor
 
init_cplx:          ;initialize "Log" var to type cplx
 ld a,1
 ld (logtype),a
 jp _COP1SET0

calc_num:
 ld hl,logvar2-1
 rst 20h
 call _rclVarSym   ;get value of "Base" var to _OP1
 call _LOGX        ;_OP1=log(_OP1),-#s=error  
 rst 18h
 ld hl,log_stoname-1
 rst 20h
 call _rclVarSym
 call _POPOP3         ;_OP3=value at FP stack
 call _CKOP1CPLX      ;is _OP1 complex?
 jr nz,calc_num_real  ;if not calculate it as type real
 call _CMLTBYREAL     ;cplx # in _OP1/_OP2 * real # in _OP3
 jr num_finish
calc_num_real:
 call _op3toop2       ;_OP3-->_OP2
 rst 28h
num_finish: 
 call _TENX           ;_OP1=10^_OP1
 call _op1toop6
 ld hl,log_stoname-1
 rst 20h
 call _rclVarSym
 call _CKOP1CPLX    ;is _OP1 complex?
 call _op6toop1
 call z,_invop1s    ; if so, then _OP1=-(_OP1)
 rst 18h
 ld hl,logvar1-1
 rst 20h
 call _stoOther     ;store result to var
 call _RecalledOp1       
 jp calc_finish         
                                                         
calc_base:
 ld hl,logvar1-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1_0
 call _ckop1pos
 jr nz,base_cplx
 call _LOGX
 rst 18h
 ld hl,log_stoname-1
 rst 20h
 call _rclVarSym
 rst 08h
 call _popop1
 call _FPDIV
 jr base_finish
 
base_cplx:
 call _LOGXP        ;_OP1=log(_OP1),-#s=cplx num
 call _PUSHMCPLXO1  ;push complex # in _OP1/_OP2 to FP stack
 ld hl,log_stoname-1
 rst 20h
 call _rclVarSym
 call _CDIV         ;divide two cplx #s, first # in _OP1/_OP2 on FP stack, second # in _OP1/_OP2
base_finish:
 call _TENX
 rst 18h
 ld hl,logvar2-1
 rst 20h
 call _stoOther
 call _RecalledOp1
 jp calc_finish             
    
logx_cplx:
 ld hl,logvar1-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1_0   ;ERROR 04 DOMAIN if _OP1=0
 call _ckop1pos
 call z,_errDomain
 call _LOGXP
 call _CKOP1CPLX
 jr nz,logx_real  ;if _OP1 not cplx, then calculate as type real
 rst 18h
 ld hl,logvar2-1
 rst 20h
 call _rclVarSym
 call _ERRD_OP1_LE_0
 call _LOGX
 call _op1toop3
 call _popop1
 call _CDIVBYREAL  ;divide cplx # by a real #; _OP1/_OP2=cplx #, _OP3=real #
 rst 18h
 ld hl,log_stoname-1
 rst 20h
 call _stoOther
 call _RecalledOp1
 jp calc_finish
 
logx_real:
 ld hl,logvar1-1
 rst 20h
 call _rclVarSym
 call _LOGX 
 call _pushrealo1
 ld hl,logvar2-1
 rst 20h
 call _rclVarSym
 call _LOGX
 rst 08h
 call _poprealo1
 call _FPDIV
 call _stoAns        ;store _OP1 to 'Ans' variable
 rst 18h
 ld hl,log_stoname-1
 rst 20h
 call _stoOther
 call _RecalledOp1
 jp calc_finish 

chk_mode_obj:       ;z-flag=1 if cursor is on a selector
 ld hl,(_numedTbl)
 inc hl
 ld a,(hl)
 cp $15
 ret
 
dummy_menu:  ;start of first menu data
.db 3,5      ;type $03, 5 slots
.dw dm_slot1 ;pointer to slot 1
.dw dm_slot2 ;pointer to slot 2
.dw 0,0,0    ;other cells are blank
dm_slot1:
.db 1,0,0
 jp menu_circle_code ;jump to circle editor if pressed
.db "CIRCL",0
dm_slot2:
.db 1,0,0
 jp menu_log_code  ;jump to log editor if pressed
.db "LOG",0
calc_menu:
.db 3,5       ;type $03, 5 slots
.dw calc_slot ;pointer to slot 1
.dw clr_slot  ;pointer to slot 2
.dw 0,0,0     ;other cells are blank
calc_slot:
.db 3,$fd,1,"CALC",0
clr_slot:
.db 3,$fd,2,"CLEAR",0
context:               ;context vectors
.dw key_handler_circ
.dw _numPPutAway
.dw _anumputaway
.dw _aredispfield
.dw _NumError
.dw _anumsizewind
.db $0a
key_handler_circ:
 bit 0,(iy+$29)
 jr nz,key_handler_ellipse  ;if selector switched, use ellipse editor key handler
 cp $fd
 jp nz,_anumhandlekey
 ld a,(_keyextend)
 cp 1
 jp z,circle_code
 cp 2
 jp z,circle_clear
 jp _anumhandlekey
key_handler_ellipse:
 cp $fd
 jp nz,_anumhandlekey
 ld a,(_keyextend)
 cp 1
 jp z,ellipse_code
 cp 2
 jp z,ellipse_clear
 jp _anumhandlekey 
key_handler_log:
 cp $fd
 jp nz,_anumhandlekey
 ld a,(_keyextend)
 cp 1
 jp z,logx_code
 cp 2
 jp z,logx_clear
 jp _anumhandlekey
title1:
.db "CIRCLES AND ELLIPSES",0   ;title string for editor
var1:                         ;start of var title strings
.db "Radius",0
var2:
.db "Area",0
var3:
.db "Circumference",0
var4:
.db "Horiz Radius",0
var5:
.db "Vert Radius",0
var6:
.db "Perimeter",0
type_str:
.db "Type:"         ;title str for selector menu
circle:            ;start of selector menu strings
.db "Circle",0
ellipse:
.db "Ellipse",0
title2:
.db "LOGARITHMS",0   ;title string for editor
blink_str:          ;title str for selector menu
.db "Answer:",0 
opt1:             ;start of selector menu strings
.db "Real",0      
opt2:
.db "Complex",0
log1:           ;start of var title strings
.db "Base",0
log2:
.db "Log",0
.db $ff,$ff,$ff
circle_table:     ;circle editor table
.db 0,$15    ;position=1 (although not specified,this type counts as a var), type=$15 (mode object)
.dw circle_ellipse_selector  ;first is a selector menu
.db 0,2,0   ;position=2, type=0 (real #)
.dw var1   ;pointer to var string
rad:
.db 6,"Radius"  ;first editor variable
.db 3,0     ;position=3, type=0 (real #)
.dw var2
area:
.db 4,"Area"
.db 4,0
.dw var3
circ:
.db 4,"Circ"
.db $ff,$ff,$ff  ;end of table and start of new table
ellipse_table:
.db 0,$15
.dw circle_ellipse_selector
.db 0,2,0
.dw var4
hrad:
.db 8,"HorizRad"
.db 3,0
.dw var5
vrad:
.db 7,"VertRad"
.db 4,0
.dw var2
.db 4,"Area"
.db 5,0
.dw var6
perimeter:
.db 5,"Perim"
.db $ff,$ff,$ff
log_table:
.db 0,$15
.dw log_selector
.db 0,2,0
.dw $2646  ;ROM address of "Number" string--used to save memory.
logvar1:
.db 6,"Number"
.db 3,0
.dw log1
logvar2:
.db 4,"Base"
.db 4
logtype:
.db 0
.dw log2
log_stoname:
.db 6,"LogNum"
.db $ff,$ff,$ff
circle_ellipse_selector:
.dw type_str
.db 2
.db 1,0,$fe,0,1,6,6
.dw circle,_Flags+$29
 call switch_circle
 ret
.db 0,1
.db 1,0,$fe,0,1,$0d,7
.dw ellipse,_Flags+$29 ;(iy+$29)
 call switch_circle
 ret
.db 1,1         ;bit 0
log_selector:
.dw blink_str
.db 2
.db 1,0,$fe,0,1,8,4
.dw opt1,_Flags+$29
 call switch_logx
 ret
.db 0,2
.db 1,0,$fe,0,1,$0d,7
.dw opt2,_Flags+$29   ;(iy+$29)
 call switch_logx
 ret
.db 2,2    ;bit 1
.end