; asmOS v1.0
; by Keith Batten (kbatten@usa.net)
;
; bugs:
;  you can't run an asm program with this from a basic program,
;  you must use 'ASM('
;  sometimes it will just say done when a command is executed
;  this only happened in a previous version and i haven't got
;  it to happen with this version but it was very rare even on
;  the older version. i think i fixed it but please tell me if
;  this happens to you

;  probably more but none that i can find now
;  

#include "asm86.h"
#include "Ti86asm.inc"
#include "Ti86ops.inc"
#include "ti86abs.inc"
#include "ti86math.inc"
#include "ti86und.inc"
#include "stack.inc"
#include "ram86.inc"
#include "misc.inc"


;------BEGIN (SQRT)PARSE LOADER------

.org _asm_exec_ram

	nop
	jp	Start
	.dw	0000h
	.dw	Description
Description:
	.db	"(un)install "
Name:
	.db	"asmOS v1.0 KWB",0

Start:
	ld	hl, Name			; display the name of the program
	call	_puts
	call	_newline

	ld	hl,sqrtPARSE		; load (sqrt)parse op info into OP1
	rst	20h
	call	_FINDSYM			; is there already a (sqrt)parse?
	jr	c, Install			; no so install ours

Uninstall:					; there already was a (sqrt)parse
	call	_delvar			; so we uninstall it
	res	0,(iy+$24)			; reset the flag for (sqrt)parse
	ld	hl, uninstalled
	call	_puts				; tell the user it was uninstalled
	call	_newline
	ret					; done for now

Install:
	ld	hl, installed		; tell the user we are installing it
	call	_puts
	call	_newline

	ld	hl, sqrtPARSE		; load (sqrt)parse op info into OP1
	rst	20h
	ld	hl, code_end - code_start	; get the length of the (sqrt)key program
	call	_CREATEPROG			; create the (sqrt)key program
	ld	a, b				; convert bde to ahl
	ex	de, hl
	call	$4c3f				; add 2 to ahl to point it to program data
	call	_SET_ABS_DEST_ADDR	; set the destination to be our new (sqrt)key
	xor	a
	ld	hl,code_end - code_start	; set number of bytes to copy
	call	_SET_MM_NUM_BYTES		; as length of program
	xor	a
	ld	hl, code			; point to the beginning of the program
	call	_SET_ABS_SRC_ADDR
	call	_mm_ldir			; copy the program code
	set	0,(iy + $24)

	ret

uninstalled:
	.db	"un"
installed:
	.db	"installed",0

;------END (SQRT)PARSE LOADER------


;------BEGIN (SQRT)PARSE PROGRAM------
code:
.org _asm_exec_ram-2			; set the start of code to the proper place
						; so calls and jps can be executed properly
code_start:
	.db	$8e,$28

	nop
	jp		Parse_Start
	.dw		0000h
	.dw		Parse_Description
Parse_Description:
	.db		"asmOS v.95 KWB (DO NOT RUN!)",0
Parse_Start:
	ld	a, (_P_CURPC)		; get current position
	ld	hl, (_P_CURPC+1)		; of parsing

	call	_load_ram_ahl

	ld	de, _OP2
	ld	bc, 10
	ldir

	ld	a, (_OP2)
	sub	50				; convert the text length to ascii value length
	ld	(_OP2), a			; (ie. "5"->5

	ld	hl, _OP2-1

	rst	20h
	rst	10h
	jr	c, quit			; check if it exists
	ld	a, (hl)			; if not let the OS handle the error
	cp	$12				; make sure its a program
	jr	nz, quit			; if not let the OS handle the function
	call	_checkasm			; check if it is assembly or basic
	jr	nz, quit			; it must be basic so let the OS run it

	set	appTextSave, (iy+appflags)
	call	_clrScrn

	ld	a, $0				; set these flags so the OS will not
	ld	(_alt_ret_status), a	; try to reparse what we handled
	ld 	a, $3
	ld	(_alt_ret_jmp_page), a
	ld	hl, $5851
	ld 	(_alt_ret_jmp_addr), hl
	jp	_exec_assembly		; run the program

quit:
; set up so it will continue parsing if it doesn't runs asm program
	ld	a, $11
	ld	(_alt_ret_status), a
	ld 	a, $3
	ld	(_alt_ret_jmp_page), a
	ld	hl, $5851
	ld 	(_alt_ret_jmp_addr), hl

	ret

code_end:

.end
