#include "ti86asm.inc"
#include "ti86abs.inc"
#include "ti86math.inc"
#include "ti86und.inc"
_runIndicOn		.EQU	4AADh
_runIndicOff	.EQU	4AB1h

;Score Variables
cha			=$fa6e	;chance
yhat		=$fa6d	;yahtzee
ful			=$fa6c	;full house
sst			=$fa6b	;sm. straight
lst			=$fa6a	;lg. straight
kk3			=$fa69	;3 of a kind
kk4			=$fa68	;4 of a kind
total		=$fa66	;total
stota		=$fa65	;sub-total
one			=$fa64	;ones
two			=$fa63	;twos
thre		=$fa62	;threes
fou			=$fa61	;fours
fiv			=$fa60	;fives
six			=$fa5f	;sixes
count		=$fa52	;count true comparisons
bon			=$fa51	;bonus
score		=$fa42	;score for a caatagory
sub1		=$fa4b	;sub total bonus
;Roll Variables
di1			=$fa5e	;value die 1
di2			=$fa5d	;value die 2
di3			=$fa5c	;value die 3
di4			=$fa5b	;value die 4
di5			=$fa50	;value die 5
num			=$fa59	
di1b		=$fa58	;hold for die 1
di2b		=$fa57	;hold for die 2
di3b		=$fa56	;hold for die 3
di4b		=$fa55	;hold for die 4
di5b		=$fa54	;hold for die 5
rol			=$fa53	;number of rolls

.org _asm_exec_ram

	nop
	jp Variable_setup
	.dw 0
	.dw ShellTitle

ShellTitle:
	.db "Yahtzee v 1.0",0

Variable_setup:
	call _runIndicOff	
	ld a,0				;set-up all variables
	ld (cha),a
	ld (yhat),a
	ld (ful),a
	ld (sst),a
	ld (lst),a
	ld (kk3),a
	ld (kk4),a
	ld (stota),a
	ld (one),a
	ld (two),a
	ld (thre),a
	ld (fou),a
	ld (fiv),a
	ld (six),a
	ld (bon),a
	ld (sub1),a
	ld hl,0
	ld (total),hl

Intro:				;display the intro screen
	call _clrLCD
	ld a,3
	ld (_curRow),a
	ld a,7
	ld (_curCol),a
	ld hl,intro1
	call _puts
	call _newline
	ld a,10
	ld (_curCol),a
	ld hl,intro2
	call _puts
	call _newline
	ld a,7
	ld (_curCol),a
	ld hl,intro3
	call _puts
	call _pause
intro1:		.db "Welcome",0
intro2:		.db "to",0
intro3:		.db "Yahtzee",0

Score_up:
	
	ld a,(stota)		;check to see if you get
	cp 63				;the bonus
	call nc,Bonus		
	
	ld a,(one)			;this section checks
	ld b,a				;if all scores have been used
	ld a,(two)			;and if so ends the prog.
	add a,b
	ld b,a
	ld a,(thre)
	add a,b
	ld b,a
	ld a,(fou)
	add a,b
	ld b,a
	ld a,(fiv)
	add a,b
	ld b,a
	ld a,(six)
	add a,b
	ld b,a
	ld a,(cha)
	add a,b
	ld b,a
	ld a,(ful)
	add a,b
	ld b,a
	ld a,(sst)
	add a,b
	ld b,a
	ld a,(lst)
	add a,b
	ld b,a
	ld a,(kk3)
	add a,b
	ld b,a
	ld a,(kk4)
	add a,b
	cp 12
	jp z,check_if_done
AAA:
	call _clrLCD		;this section updates the
	ld a,0				;score info. and displays it
	ld (_curRow),a
	ld a,19
	ld (_curCol),a
	ld a,(stota)
	call _setXXop1
	call _dispOP1
	ld a,3
	ld (_curRow),a
	ld a,19
	ld (_curCol),a
	ld hl,(total)
	call _setXXXXop2
	call _op2toop1
	call _dispOP1

Disp:
	ld a,(bon)		;each section checks if something
	cp 0			;needs to be displayed
	jp z,dones		;if not it jumps to the next section
	ld a,85			;this one checks if the bonus message
	ld (_penCol),a	;should be displayed
	ld a,15	
	ld (_penRow),a
	ld hl,bonn
	call _vputs
	
dones:				;this checks the ones
	ld a,(one)
	cp 1
	jr z,dtwos
	ld a,1
	ld (_penCol),a
	ld (_penRow),a	
	ld hl,d1
	call _vputs
dtwos:				;the twos
	ld a,(two)
	cp 1
	jr z,dthrees
	ld a,1
	ld (_penCol),a
	ld a,8
	ld (_penRow),a	
	ld hl,d2
	call _vputs
dthrees:			;the threes
	ld a,(thre)
	cp 1
	jr z,dfours
	ld a,1
	ld (_penCol),a
	ld a,15
	ld (_penRow),a	
	ld hl,d3
	call _vputs
dfours:				;the fours and so on
	ld a,(fou)
	cp 1
	jr z,dfives
	ld a,1
	ld (_penCol),a
	ld a,22
	ld (_penRow),a	
	ld hl,d4
	call _vputs
dfives:
	ld a,(fiv)
	cp 1
	jr z,dsixes
	ld a,1
	ld (_penCol),a
	ld a,30
	ld (_penRow),a	
	ld hl,d5
	call _vputs
dsixes:
	ld a,(six)
	cp 1
	jr z,d3kind
	ld a,1
	ld (_penCol),a
	ld a,38
	ld (_penRow),a	
	ld hl,d6
	call _vputs
d3kind:
	ld a,(kk3)
	cp 1
	jr z,d4kind
	ld a,40
	ld (_penCol),a
	ld a,1
	ld (_penRow),a	
	ld hl,d7
	call _vputs
d4kind:
	ld a,(kk4)
	cp 1
	jr z,dfhouse
	ld a,40
	ld (_penCol),a
	ld a,8
	ld (_penRow),a	
	ld hl,d8
	call _vputs
dfhouse:
	ld a,(ful)
	cp 1
	jr z,dss
	ld a,40
	ld (_penCol),a
	ld a,15
	ld (_penRow),a	
	ld hl,d9
	call _vputs
dss:				;this is for the small straight
	ld a,(sst)
	cp 1
	jr z,dls
	ld a,40
	ld (_penCol),a
	ld a,22
	ld (_penRow),a	
	ld hl,d10
	call _vputs
dls:				;the large straight
	ld a,(lst)
	cp 1
	jr z,dchance
	ld a,40
	ld (_penCol),a
	ld a,30
	ld (_penRow),a	
	ld hl,d11
	call _vputs
dchance
	ld a,(cha)
	cp 1
	jr z,dyahtz
	ld a,40
	ld (_penCol),a
	ld a,38
	ld (_penRow),a	
	ld hl,d12
	call _vputs
dyahtz:
	ld a,(yhat)
	cp 2
	jr z,dscore
	ld a,20
	ld (_penCol),a
	ld a,44
	ld (_penRow),a	
	ld hl,d13
	call _vputs
dscore:
	ld a,90
	ld (_penCol),a
	ld a,1
	ld (_penRow),a	
	ld hl,d14			;displays Sub-Total
	call _vputs	
	ld a,100
	ld (_penCol),a
	ld a,22
	ld (_penRow),a	
	ld hl,d15			;displays Total
	call _vputs
	ld a,44
	ld (_penRow),a
	ld a,70
	ld (_penCol),a
	ld hl,d16			;displays Roll:
	call _vputs
	jp Rollgk			;goto the first getkey
d1:		.db "1:Ones",0
d2:		.db "2:Twos",0
d3:		.db "3:Threes",0
d4:		.db "4:Fours",0
d5:		.db "5:Fives",0
d6:		.db "6:Sixes",0
d7:		.db "A:3 of a kind",0
d8:		.db "B:4 of a kind",0
d9:		.db "C:Full House",0
d10:	.db "D:Sm. Straight",0
d11:	.db "E:Lg. Straight",0
d12:	.db "F:Chance",0
d13:	.db "G:Yahtzee",0
d14:	.db "Sub-Total:",0
d15:	.db "Total:",0
bonn:	.db "BONUS 35",0
d16:	.db "Roll:",0

Rollgk:
	ld a,0			;reset all roll variables
	ld (di1b),a
	ld (di2b),a
	ld (di3b),a
	ld (di4b),a
	ld (di5b),a
	ld (rol),a

	call _getkey	;wait for key press
	cp kExit		;if exit was pressed 
	jp z,Quit		;goto Quit
	cp kEnter		;if enter was presses roll the dice
	jp z,Rolls
	jp Rollgk		;if any other key was pressed
					;go back
					;this routine will only allow
					;you to roll or quit

Rolls:
	ld a,(rol)		;check if you have already
	cp 3			;rolled 3 times and if so
	jp z,getk		;goes to getk

	ld a,(rol)		;increases the number stored
	inc a			;in rol by one
	ld (rol),a

	ld hl,one1		;this routine loads the numbers
	call Put		;1 through 6 in hl to be put 
	ld hl,two2		;on the screen
	call Put
	ld hl,three		;load the three string
					;into hl
	call Put		;goto Put
	ld hl,four
	call Put
	ld hl,five
	call Put
	ld hl,six6
	call Put
	jp	P1
	
Put:
	ld (num),hl
Pu1:
	ld a,(di1b)		;check to see if this die is
	cp 1			;is being held and not rolled
	jp z,Pu2		;if it is goto the next place in this case Pu2
	ld a,4			;load the correct place on the screen
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	call _vputs		;display the string in hl
					;each part here does the same thing
					;except for a different die and location
Pu2:
	ld a,(di2b)
	cp 1
	jp z,Pu3
	ld a,34
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	ld hl,(num)
	call _vputs
Pu3:
	ld a,(di3b)
	cp 1
	jp z,Pu4
	ld a,64
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	ld hl,(num)
	call _vputs
Pu4:
	ld a,(di4b)
	cp 1
	jp z,Pu5
	ld a,94
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	ld hl,(num)
	call _vputs
Pu5:
	ld a,(di5b)
	cp 1
	jp z,Loop
	ld a,120
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	ld hl,(num)
	call _vputs
	ld b,255	;ld b with 255 for loops
Loop:			;these loops are used to slow down
				;the prog
	push bc		;save b but only register pairs can be pushed or poped
	ld b,75		;ld b with 75
looop:
	nop			;wast 4 clock cycles
	djnz looop	;decrese b and jump if not zero
	pop bc		;restore b
	djnz Loop	;decrese b and jump if not zero
	ret			;return to last call
	
P1:	ld a,(di1b)		;check if the die is held
	cp 1
	jp z,P2			;goto next part if it is
	call _random	;generate random # from 0-1 in op1
	ld a,6			
	call _setXXop2	;move the value in a to op2
	call _FPMULT	;multiply op2 and op1 product in op1
	call _INTGR		;make op1 an integer
	call _convop1	;move op1 to a
	inc a			;increase a
	ld (di1),a		;put a in the die
	ld a,4
	ld (_penCol),a
	ld a,51
	ld (_penRow),a	;correct location loaded
	ld a,(di1)		;ld a with die value
	call LD_HL		;goto LD_HL
	call _vputs		;put hl on the screen
					;again each part does the same thing
					;just for a different die and screen location

P2: ld a,(di2b)
	cp 1
	jp z,P3
	call _random
	ld a,6
	call _setXXop2
	call _FPMULT
	call _INTGR
	call _convop1
	inc a
	ld (di2),a	
	ld a,34
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	ld a,(di2)
	call LD_HL
	call _vputs

P3: ld a,(di3b)
	cp 1
	jp z,P4
	call _random
	ld a,6
	call _setXXop2
	call _FPMULT
	call _INTGR
	call _convop1
	inc a
	ld (di3),a
	ld a,64
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	ld a,(di3)
	call LD_HL
	call _vputs

P4:	ld a,(di4b)
	cp 1
	jp z,P5
	call _random
	ld a,6
	call _setXXop2
	call _FPMULT
	call _INTGR
	call _convop1
	inc a
	ld (di4),a
	ld a,94
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	ld a,(di4)
	call LD_HL
	call _vputs

P5:	ld a,(di5b)
	cp 1
	jp z,getk
	call _random
	ld a,6
	call _setXXop2
	call _FPMULT
	call _INTGR
	call _convop1
	inc a
	ld (di5),a	
	ld a,120
	ld (_penCol),a
	ld a,51
	ld (_penRow),a
	ld a,(di5)
	call LD_HL
	call _vputs
	jp getk
	
	
LD_HL:
	cp 1		;check the value of the die
	call z,DIS1	;to determine what to put on the screen
	cp 2
	call z,DIS2
	cp 3
	call z,DIS3
	cp 4
	call z,DIS4
	cp 5
	call z,DIS5
	cp 6
	call z,DIS6
	ret			;return from call
DIS1:
	ld hl,one1
	ret
one1:	.db "1",0	
DIS2:
	ld hl,two2
	ret
two2:	.db "2",0	
DIS3:
	ld hl,three
	ret
three:	.db "3",0	
DIS4:
	ld hl,four
	ret
four:	.db "4",0	
DIS5:
	ld hl,five
	ret
five:	.db "5",0	
DIS6:
	ld hl,six6
	ret
six6:	.db "6",0
	ret
getk:				;this is the main getkey loop
	ld a,44			;first put the number of rolls
	ld (_penRow),a	;on the screen
	ld a,90
	ld (_penCol),a
	ld a,(rol)
	cp 1
	call z,DIS1
	cp 2
	call z,DIS2
	cp 3
	call z,DIS3
	call _vputs
	
	call _getkey	;wait for key press
	cp kExit		;if exit is pressed
	jp z,Quit		;quit
	cp kEnter		;if enter is pressed
	jp z,Rolls		;roll
	cp kF1			;if F1 is pressed
	jp z,hld1		;goto hld1
	cp kF2			;and so on
	jp z,hld2
	cp kF3
	jp z,hld3
	cp kF4
	jp z,hld4
	cp kF5
	jp z,hld5
	cp k1
	jp z,sones
	cp k2
	jp z,stwos
	cp k3
	jp z,sthrees
	cp k4
	jp z,sfours
	cp k5
	jp z,sfives
	cp k6
	jp z,ssixes
	cp kLog
	jp z,kind3
	cp kSin
	jp z,kind4
	cp kCos
	jp z,fhouse
	cp kTan
	jp z,ss
	cp kExpon
	jp z,ls
	cp kLn
	jp z,chance
	cp kEE
	jp z,yahtz
	jp getk			;if another key was pressed go back to getk

hld1:				;these routines will put hold
	ld a,57			;on the screen and store 1 to di(x)b if the die was
	ld (_penRow),a	;not already held if it was hold
	ld a,1			;will be erased and o stored to di(x)b x being the 
	ld (_penCol),a	;number of the die
	ld a,(di1b)
	cp 0
	call z,on
	cp 1
	call z,off
	pop bc
	ld a,b
	ld (di1b),a
	jp getk
	
hld2:
	ld a,57
	ld (_penRow),a
	ld a,27
	ld (_penCol),a	;correct location loaded
	ld a,(di2b)		;put the number in (di2b) in a
	cp 0			;check if it is 0 (not held)
	call z,on		;goto on if it is
	cp 1			;check if it is 1 (held)
	call z,off		;goto off if it is
	pop bc			;restore bc
	ld a,b			
	ld (di2b),a
	jp getk			;go back to getk

hld3:
	ld a,57
	ld (_penRow),a
	ld a,57
	ld (_penCol),a
	ld a,(di3b)
	cp 0
	call z,on
	cp 1
	call z,off
	pop bc
	ld a,b
	ld (di3b),a
	jp getk

hld4:
	ld a,57
	ld (_penRow),a
	ld a,87
	ld (_penCol),a
	ld a,(di4b)
	cp 0
	call z,on
	cp 1
	call z,off
	pop bc
	ld a,b
	ld (di4b),a
	jp getk

hld5:
	ld a,57
	ld (_penRow),a
	ld a,110
	ld (_penCol),a
	ld a,(di5b)
	cp 0
	call z,on
	cp 1
	call z,off
	pop bc
	ld a,b
	ld (di5b),a
	jp getk
on:
	ld hl,held		;loads hl with hold string
	call _vputs		;put on screen
	ld d,1
	pop bc			;restore bc
	push de			;save de
	push bc			;save bc
	ret				;return from call
off:
	ld hl,nohold	;load hl with nohold string
	call _vputs		;puts on screen
	ld d,0	
	pop bc
	push de
	push bc
	ret
held:	.db "Held",0
nohold:	.db "               ",0

sones:
	ld a,(one)	;check to see if ones has been used
	cp 1		
	jp z,getk	;go back to getk if it has
	ld a,0		
	ld (count),a	;set count to 0
	ld a,(di1)	
	cp 1		;check if die 1 was 1
	call z,coun	;if it was call coun
	ld a,(di2)	;this is the same for the rest of the dice
	cp 1
	call z,coun
	ld a,(di3)
	cp 1
	call z,coun
	ld a,(di4)
	cp 1
	call z,coun
	ld a,(di5)
	cp 1
	call z,coun
	
	ld a,(count)	;load a with the value in count
	ld (score),a	;load score with count
	ld b,a			;save a in b
	ld a,(stota)	;load sub-total to a
	add a,b			;add score and sub-total store in a
	ld (stota),a	;update the sub-total
	ld de,(total)	
	ld hl,(score)
	add hl,de		;add the total and score store in hl
	ld (total),hl	;update the total
	ld a,1
	ld (one),a		;ld one with 1
	jp Score_up		;goto Score_up

stwos:
	ld a,(two)	;check if twos have been used
	cp 1
	jp z,getk	;go back to getk if it has
	ld a,0
	ld (count),a	;reset count
	
	ld a,(di1)	;check each die for a 2
	cp 2
	call z,coun
	ld a,(di2)
	cp 2
	call z,coun
	ld a,(di3)
	cp 2
	call z,coun
	ld a,(di4)
	cp 2
	call z,coun
	ld a,(di5)
	cp 2
	call z,coun
	
	ld a,(count)
	add a,a		;multiply count by 2 store in a
	ld b,a		;save a
	ld (score),a
	ld a,(stota)
	add a,b		;add sub-total and score store in a
	ld (stota),a	;update sub total
	ld de,(total)
	ld hl,(score)
	add hl,de		;add total and sub-total store in hl
	ld (total),hl	;update total
	ld a,1
	ld (two),a		;ld two with 1
	jp Score_up		;goto Score_up

;as you can see the only difference between the first two is that
;count was doubled so that you would get 2 points for each 2
;in the threes count will need to be tripled for the fours quadrupled
;and so on

sthrees:
	ld a,(thre)
	cp 1
	jp z,getk
	ld a,0
	ld (count),a
	ld a,(di1)
	cp 3
	call z,coun
	ld a,(di2)
	cp 3
	call z,coun
	ld a,(di3)
	cp 3
	call z,coun
	ld a,(di4)
	cp 3
	call z,coun
	ld a,(di5)
	cp 3
	call z,coun
	ld a,(count)
	ld b,a
	add a,a
	add a,b
	ld b,a
	ld (score),a
	ld a,(stota)
	add a,b
	ld (stota),a
	ld hl,(count)
	ld de,(total)
	ld hl,(score)
	add hl,de
	ld (total),hl
	ld a,1
	ld (thre),a
	jp Score_up

sfours:
	ld a,(fou)
	cp 1
	jp z,getk
	ld a,0
	ld (count),a
	ld a,(di1)
	cp 4
	call z,coun
	ld a,(di2)
	cp 4
	call z,coun
	ld a,(di3)
	cp 4
	call z,coun
	ld a,(di4)
	cp 4
	call z,coun
	ld a,(di5)
	cp 4
	call z,coun
	ld a,(count)
	add a,a
	add a,a
	ld b,a
	ld (score),a
	ld a,(stota)
	add a,b
	ld (stota),a
	ld de,(total)
	ld hl,(score)
	add hl,de
	ld (total),hl
	ld a,1
	ld (fou),a
	jp Score_up

sfives:
	ld a,(fiv)
	cp 1
	jp z,getk
	ld a,0
	ld (count),a
	ld a,(di1)
	cp 5
	call z,coun
	ld a,(di2)
	cp 5
	call z,coun
	ld a,(di3)
	cp 5
	call z,coun
	ld a,(di4)
	cp 5
	call z,coun
	ld a,(di5)
	cp 5
	call z,coun
	ld a,(count)
	ld b,a
	add a,a
	add a,a
	add a,b
	ld b,a
	ld (score),a
	ld a,(stota)
	add a,b
	ld (stota),a
	ld de,(total)
	ld hl,(score)
	add hl,de
	ld (total),hl
	ld a,1
	ld (fiv),a
	jp Score_up

ssixes:
	ld a,(six)
	cp 1
	jp z,getk
	ld a,0
	ld (count),a
	ld a,(di1)
	cp 6
	call z,coun
	ld a,(di2)
	cp 6
	call z,coun
	ld a,(di3)
	cp 6
	call z,coun
	ld a,(di4)
	cp 6
	call z,coun
	ld a,(di5)
	cp 6
	call z,coun
	ld a,(count)
	ld b,a
	add a,a
	add a,a
	add a,b
	add a,b
	ld b,a
	ld (score),a
	ld a,(stota)
	add a,b
	ld (stota),a
	ld de,(total)
	ld hl,(score)
	add hl,de
	ld (total),hl
	ld a,1
	ld (six),a
	jp Score_up

coun:
	ld a,(count)
	inc a
	ld (count),a	;increase count by 1
	ret				;ret from call

Bonus:
	ld a,(sub1)	;check if a bonus has already been given
	cp 1
	ret z		;ret from call if it has
	ld hl,35
	ld de,(total)
	add hl,de
	ld (total),hl
	ld a,1
	ld (bon),a	;load bon and sub1 with 1
	ld (sub1),a
	ret			;ret from call
	

kind3:
	ld a,(kk3)	;check if 3 of a kind has been used
	cp 1
	jp z,getk	;go back to getk if it has
	ld a,1
	ld (kk3),a	;load kk3 with 1
	ld a,0
	ld (count),a	;reset count
	ld a,(di1)
	ld b,a
	ld a,(di2)
	cp b				;compare die 1 w/ die 2
	call z,coun			;goto count if equal same with other comparisons
	ld a,(di3)
	cp b				;compare di1 w/ di3
	call z,coun
	ld a,(di4)
	cp b				;compare di1 w/ di4
	call z,coun
	ld a,(di5)
	cp b				;compare di1 w/ di5
	call z,coun
	ld a,(count)
	cp 2				;check if 3 are equal
	jp z,sumall			;if so goto sumall
	ld a,0
	ld (count),a
	ld a,(di2)
	ld b,a
	ld a,(di3)
	cp b				;compare di2 w/ di3
	call z,coun
	ld a,(di4)
	cp b				;compare di2 w/ di4
	call z,coun
	ld a,(di5)
	cp b				;compare di2 w/ di5
	call z,coun
	ld a,(count)
	cp 2				;check if 3 are equal
	jp z,sumall			;goto sumall if so
	ld a,0
	ld (count),a
	ld a,(di3)
	ld b,a
	ld a,(di4)
	cp b				;compare di3 w/ di4
	call z,coun
	ld a,(di5)
	cp b				;compare di3 w/ di5
	call z,coun
	ld a,(count)
	cp 2				;check if 3 are equal
	jp z,sumall			;goto sumall if so
	jp Score_up			;goto Score_up
sumall:					;add all of the dice
	ld a,(di1)
	ld b,a
	ld a,(di2)
	add a,b
	ld b,a
	ld a,(di3)	
	add a,b
	ld b,a
	ld a,(di4)
	add a,b
	ld b,a
	ld a,(di5)
	add a,b
	ld (score),a	;sum of dice stored in score
	ld de,0
	ld hl,0
	ld de,(total)
	ld hl,(score)
	add hl,de		;score added to total
	ld (total),hl	;total updated
	jp Score_up		;goto Score_up
	
kind4:
	ld a,(kk4)		;check if 4 of a kind has been used
	cp 1
	jp z,getk		;go back to getk if it has
	ld a,1
	ld (kk4),a		;store 1 in kk4
	ld a,0			;reset count
	ld (count),a
	ld a,(di1)
	ld b,a
	ld a,(di2)
	cp b				;compare di1 w/ di2
	call z,coun
	ld a,(di3)
	cp b				;compare di1 w/ di3
	call z,coun
	ld a,(di4)
	cp b				;compare di1 w/ di4
	call z,coun
	ld a,(di5)
	cp b				;compare di1 w/ di5
	call z,coun
	ld a,(count)
	cp 3				;check if 4 are equal
	jp z,sumall
	ld a,0
	ld (count),a
	ld a,(di2)
	ld b,a
	ld a,(di3)
	cp b				;compare di2 w/ di3
	call z,coun
	ld a,(di4)
	cp b				;compare di2 w/ di4
	call z,coun
	ld a,(di5)
	cp b				;compare di2 w/ di5
	call z,coun
	ld a,(count)
	cp 3				;check if 4 are equal
	jp z,sumall
	jp Score_up

ls:
	ld a,(lst)		;check if lg. straight has been used
	cp 1
	jp z,getk		;return to getk if it has
	ld a,1
	ld (lst),a		;load lst with 1
;these checks work because in order to have a large straight you must
;have a 2,3,4,5 and either a one of six.
;so if the program makes it through all the checks by finding those
;numbers we know the player has a large straight.
First1:				;check if any die is two
	ld a,2
	ld b,a
	ld a,(di1)
	cp b
	jp z,second1
	ld a,(di2)
	cp b
	jp z,second1
	ld a,(di3)
	cp b
	jp z,second1
	ld a,(di4)
	cp b
	jp z,second1
	ld a,(di5)
	cp b
	jp z,second1
	jp Score_up
second1:			;check if any die is 3
	ld a,3
	ld b,a
	ld a,(di1)
	cp b
	jp z,third1
	ld a,(di2)
	cp b
	jp z,third1
	ld a,(di3)
	cp b
	jp z,third1
	ld a,(di4)
	cp b
	jp z,third1
	ld a,(di5)
	cp b
	jp z,third1
	jp Score_up
third1:				;check if any die is 4
	ld a,4
	ld b,a
	ld a,(di1)
	cp b
	jp z,fourth1
	ld a,(di2)
	cp b
	jp z,fourth1
	ld a,(di3)
	cp b
	jp z,fourth1
	ld a,(di4)
	cp b
	jp z,fourth1
	ld a,(di5)
	cp b
	jp z,fourth1
	jp Score_up
fourth1:			;check if any die is 5
	ld a,5
	ld b,a
	ld a,(di1)
	cp b
	jp z,fifth1
	ld a,(di2)
	cp b
	jp z,fifth1
	ld a,(di3)
	cp b
	jp z,fifth1
	ld a,(di4)
	cp b
	jp z,fifth1
	ld a,(di5)
	cp b
	jp z,fifth1
	jp Score_up
fifth1:				;check if any die is 6
	ld a,6
	ld b,a
	ld a,(di1)
	cp b
	jp z,yesls
	ld a,(di2)
	cp b
	jp z,yesls
	ld a,(di3)
	cp b
	jp z,yesls
	ld a,(di4)
	cp b
	jp z,yesls
	ld a,(di5)
	cp b
	jp z,yesls
					;check if any die is 1
	ld a,1
	ld b,a
	ld a,(di1)
	cp b
	jp z,yesls
	ld a,(di2)
	cp b
	jp z,yesls
	ld a,(di3)
	cp b
	jp z,yesls
	ld a,(di4)
	cp b
	jp z,yesls
	ld a,(di5)
	cp b
	jp z,yesls
	jp Score_up
yesls:
	ld de,(total)
	ld hl,40
	add hl,de		;add 40 to the total
	ld (total),hl	;and update the total
	jp Score_up		;goto Score_up
;small straight is the same idea as the large straight if you make
;it through the checks the player must have a small straight
;because you must have a 3 and a 4 and eithe a 1 and 2, a 2 and 5, or a
; 5 and 6 in order to have a small straight.

ss:					;****NOTE: the order of the****
	ld a,(sst)		;****checks is VERY important****
	cp 1
	jp z,getk
	ld a,1
	ld (sst),a
check3:				;check for threes
	ld a,3
	ld b,a
	ld a,(di1)
	cp b
	jp z,check4
	ld a,(di2)
	cp b
	jp z,check4
	ld a,(di3)
	cp b
	jp z,check4
	ld a,(di4)
	cp b
	jp z,check4
	ld a,(di5)
	cp b
	jp z,check4
	jp Score_up
check4:				;check for fours
	ld a,4
	ld b,a
	ld a,(di1)
	cp b
	jp z,check2
	ld a,(di2)
	cp b
	jp z,check2
	ld a,(di3)
	cp b
	jp z,check2
	ld a,(di4)
	cp b
	jp z,check2
	ld a,(di5)
	cp b
	jp z,check2
	jp Score_up
check2:				;check fot twos
	ld a,2
	ld b,a
	ld a,(di1)
	cp b
	jp z,check1
	ld a,(di2)
	cp b
	jp z,check1
	ld a,(di3)
	cp b
	jp z,check1
	ld a,(di4)
	cp b
	jp z,check1
	ld a,(di5)
	cp b
	jp z,check1
	jp check6
check1:				;check for ones
	ld a,1
	ld b,a
	ld a,(di1)
	cp b
	jp z,yesss
	ld a,(di2)
	cp b
	jp z,yesss
	ld a,(di3)
	cp b
	jp z,yesss
	ld a,(di4)
	cp b
	jp z,yesss
	ld a,(di5)
	cp b
	jp z,yesss
check5:				;check for fives
	ld a,5
	ld b,a
	ld a,(di1)
	cp b
	jp z,yesss
	ld a,(di2)
	cp b
	jp z,yesss
	ld a,(di3)
	cp b
	jp z,yesss
	ld a,(di4)
	cp b
	jp z,yesss
	ld a,(di5)
	cp b
	jp z,yesss
	jp Score_up
check6:				;check for sixes
	ld a,6
	ld b,a
	ld a,(di1)
	cp b
	jp z,check5
	ld a,(di2)
	cp b
	jp z,check5
	ld a,(di3)
	cp b
	jp z,check5
	ld a,(di4)
	cp b
	jp z,check5
	ld a,(di5)
	cp b
	jp z,check5
	jp Score_up
yesss:
	ld de,(total)
	ld hl,30
	add hl,de		;add 30 to total and update
	ld (total),hl
	jp Score_up

fhouse:
	ld a,(ful)
	cp 1		;check if full house was used
	jp z,getk
	ld a,1
	ld (ful),a	;store 1 in full house
	ld a,0		;reset count
	ld (count),a

	ld a,(di1)
	ld b,a
	ld a,(di2)
	cp b				;compare di1 w/ di2
	call z,coun
	ld a,(di3)
	cp b				;compare di1 w/ di3
	call z,coun
	ld a,(di4)
	cp b				;compare di1 w/ di4
	call z,coun
	ld a,(di5)
	cp b				;compare di1 w/ di5
	call z,coun

	ld a,(di2)
	ld b,a
	ld a,(di1)
	cp b				;compare di2 w/ di1
	call z,coun
	ld a,(di3)
	cp b				;compare di2 w/ di3
	call z,coun
	ld a,(di4)
	cp b				;compare di2 w/ di4
	call z,coun
	ld a,(di5)
	cp b				;compare di2 w/ di5
	call z,coun

	ld a,(di3)
	ld b,a
	ld a,(di1)
	cp b				;compare di3 w/ di1
	call z,coun
	ld a,(di2)
	cp b				;compare di3 w/ di2
	call z,coun
	ld a,(di4)
	cp b				;compare di3 w/ di4
	call z,coun
	ld a,(di5)
	cp b				;compare di1 w/ di5
	call z,coun

	ld a,(di4)
	ld b,a
	ld a,(di1)
	cp b				;compare di4 w/ di1
	call z,coun
	ld a,(di2)
	cp b				;compare di4 w/ di2
	call z,coun
	ld a,(di3)
	cp b				;compare di4 w/ di3
	call z,coun
	ld a,(di5)
	cp b				;compare di4 w/ di5
	call z,coun

	ld a,(di5)
	ld b,a
	ld a,(di1)
	cp b				;compare di5 w/ di1
	call z,coun
	ld a,(di2)
	cp b				;compare di5 w/ di2
	call z,coun
	ld a,(di3)
	cp b				;compare di5 w/ di3
	call z,coun
	ld a,(di4)
	cp b				;compare di5 w/ di4
	call z,coun

	ld a,(count)		;check if there were 8 equalities
	cp 8				;if there were you know the player got a
	jp z,yesful			;full house
	jp Score_up
yesful:
	ld hl,25
	ld de,(total)
	add hl,de
	ld (total),hl	;add 25 to total and update
	jp Score_up

chance:
	ld a,(cha)		;check if chance was used
	cp 1
	jp z,getk
	ld a,1			
	ld (cha),a		;store 1 in cha
	jp sumall		;goto sumall

yahtz:
	ld a,(yhat)		;check if yahtzee has been used but the player
	cp 2			;did not have a yahtzee
	jp z,getk
	
	ld a,(di1)
	ld b,a
	ld a,(di2)
	cp b
	jp nz,no
	ld a,(di3)
	cp b
	jp nz,no
	ld a,(di4)
	cp b
	jp nz,no
	ld a,(di5)
	cp b
	jp nz,no		;make sure all dice are equal if not goto no
	
	ld a,(yhat)		;see if a player already had a yahtzee
	cp 1
	jp z,b100		;goto b100 if so
	ld a,1
	ld (yhat),a		;ld yhat with 1
	ld de,(total)
	ld hl,50
	add hl,de		;add 50 to total
	ld (total),hl	;and update
	jp Score_up		;goto Score_up
b100:
	ld de,(total)
	ld hl,100
	add hl,de		;add 100 to total
	ld (total),hl	;and update
	jp Score_up
no:
	ld a,(yhat)		;check if yahtzee was used
	cp 1
	jp z,getk		;goto getk if it was
	ld a,2
	ld (yhat),a		;ld yhat with 2
	jp Score_up		;goto Score_up

check_if_done:		;only get here if all other catagories have 
					;been used
	ld a,(yhat)
	cp 1
	jp z,DONE
	cp 2			;check to see if yahtzee has been used
	jp nz,AAA		;goto AAA
DONE:
	call _clrScrn	;clear the screen
	ld a,1
	ld (_curRow),a
	ld a,6
	ld (_curCol),a
	ld hl,your_score	;display Your Score
	call _puts
	ld a,3
	ld (_curRow),a
	ld a,12
	ld (_curCol),a
	ld hl,(total)
	call _setXXXXop2
	call _op2toop1
	call _dispOP1		;display the total
	ld a,55
	ld (_penRow),a	
	ld a,40
	ld (_penCol),a
	ld hl,cb
	call _vputs			;dislpay Created By: ME
	call _pause
	jp Quit
your_score:	.db "Your Score",0
cb:	.db "Created By:  ME",0

Quit:
	call _runIndicOn
	call _clrScrn
	call _homeup
	call _clrLCD
	ret				;exit prog


		


.end
