; Jupiter Universe - External levels for Phoenix 1.00 - data file
; This software is in the public domain.  There is no warranty.
; Last updated February 17, 2000.
; Programmed by Patrick Davidson (pad@calc.org)

;------- Identification

        .db     "Jupiter!"

;------- Table of levels

level_table:
        .dw     lev1
        .dw     lev2
        .dw     lev3
        .dw     _shop
        .dw     lev4
        .dw     lev5
        .dw     lev6
        .dw     _shop
        .dw     lev8
        .dw     lev9
        .dw     _game_finished

;------- Level descriptions

lev8:   .db     12
        .db     10,12,30
        .db     0

lev9:   .db     3
        .db     4
        .dw     boss3a_data
        .db     4
        .dw     boss3b_data
        .db     4
        .dw     boss3c_data
        .db     22
        .dw     boss1l,is_boss2l
        .db     22
        .dw     boss1r,is_boss2r
        .db     0

lev6:   .db     18
        .db     13,10            
        .dw     spacing
        .db     1,9,3,18,18
        .dw     img_enemy_2
        .db     10,9,9
        .db     22
        .dw     zigzag_pattern,pattern
        .db     22
        .dw     img_bomber,is_enemy3
        .db     0

lev5:   .db     18
        .db     13,10
        .dw     spacing
        .db     1,3,21,26,2
        .dw     img_enemy_3s
        .db     1,3,21,26,22
        .dw     img_enemy_3s
        .db     1,3,21,66,2
        .dw     img_enemy_3s
        .db     1,3,21,66,22
        .dw     img_enemy_3s
        .db     13,40
        .dw     spacing
        .db     1,3,21,16,7
        .dw     img_enemy_3s
        .db     1,3,21,16,17
        .dw     img_enemy_3s
        .db     0

lev4:   .db     18
        .db     13,10
        .dw     spacing
        .db     1,3,3,26,2
        .dw     img_enemy_3
        .db     1,3,3,26,22
        .dw     img_enemy_3
        .db     1,3,3,66,2
        .dw     img_enemy_3
        .db     1,3,3,66,22
        .dw     img_enemy_3
        .db     13,40
        .dw     spacing
        .db     1,3,3,16,7
        .dw     img_enemy_3
        .db     1,3,3,16,17
        .dw     img_enemy_3

        .db     0

lev3:   .db     9
        .db     13,10               ; t
        .dw     spacing
        .db     1,8,3,21,16
        .dw     img_enemy_2
        .db     4
        .dw     boss_data
        .db     22
        .dw     boss1l,is_boss1l
        .db     22
        .dw     boss1r,is_boss1r
        .db     0

lev2:   .db     14
        .db     13,10               ; t
        .dw     spacing
        .db     1,9,3,18,19
        .dw     img_enemy_1
        .db     10,5,9
        .db     22
        .dw     zigzag_pattern,pattern
        .db     22
        .dw     img_bomber,is_enemy3
        .db     0
        

lev1:   .db     17
        .db     13,0
        .dw     which_shot
        .db     13,10
        .dw     spacing
        .db     1,8,3,21,2
        .dw     img_enemy_2
        .db     1,9,3,18,19
        .dw     img_enemy_1

        .db     0

_shop:  .db     0,19


_game_finished:
        .db     0,16

;------- Boss descriptions

boss_data:
        .db     12                      ; e_type
        .db     0                       ; e_phase
        .db     32                      ; e_timer
        .db     90                      ; e_x
        .db     16                      ; e_w
        .db     1                       ; e_y
        .db     11                      ; e_h
        .db     76                      ; e_pwr

boss3a_data:
        .db     18                      ; e_type
        .db     0                       ; e_phase
        .db     32                      ; e_timer
        .db     90                      ; e_x
        .db     16                      ; e_w
        .db     13                      ; e_y
        .db     10                      ; e_h
        .db     120                     ; e_pwr
boss3b_data:
        .db     18                      ; e_type
        .db     0                       ; e_phase
        .db     32                      ; e_timer
        .db     90                      ; e_x
        .db     16                      ; e_w
        .db     1                       ; e_y
        .db     10                      ; e_h
        .db     120                     ; e_pwr
boss3c_data:
        .db     18                      ; e_type
        .db     0                       ; e_phase
        .db     32                      ; e_timer
        .db     90                      ; e_x
        .db     16                      ; e_w
        .db     25                      ; e_y
        .db     10                      ; e_h
        .db     120                     ; e_pwr

;------- Enemy movement patterns

zigzag_pattern:
        .db     0,4
        .db     16,12,12
        .db     16,12,-12
        .db     16,12,12
        .db     16,12,-12
        .db     16,12,12
        .db     16,12,-12
        .db     16,0,-16
        .db     16,-72,0
        .db     16,0,16
        .db     0

;------- Images

img_bomber:
        .db     7,7
        .db     %01111100
        .db     %11111110
        .db     %11101110
        .db     %11000110
        .db     %11101110
        .db     %11111110
        .db     %01111100

        .db     2
img_enemy_1:
        .db     7,11
        .db     %10101010
        .db     %11010110
        .db     %10010010
        .db     %10010010
        .db     %10111010
        .db     %11111110
        .db     %00101000
        .db     %00101000
        .db     %01111100
        .db     %00111000
        .db     %00010000

        .db     4
img_enemy_2:
        .db     8,16
        .db     %10000001
        .db     %11000011
        .db     %11100111
        .db     %11111111
        .db     %11000011
        .db     %11000011
        .db     %11000011
        .db     %11000011
        .db     %11000011
        .db     %11111111
        .db     %11111111
        .db     %11111111
        .db     %11000011
        .db     %01100110
        .db     %00111100
        .db     %00011000

        .db     6
img_enemy_3:
        .db     8,8
        .db     %00111100
        .db     %01000010
        .db     %10011001
        .db     %10111101
        .db     %10111101
        .db     %10011001
        .db     %01000010
        .db     %00111100

        .db     20
img_enemy_3s:
        .db     8,8
        .db     %00011100
        .db     %00000010
        .db     %00011001
        .db     %10111101
        .db     %10111101
        .db     %10011001
        .db     %01000010
        .db     %00111100
        .db     8,8
        .db     %00111000
        .db     %01000000
        .db     %10011000
        .db     %10111101
        .db     %10111101
        .db     %10011001
        .db     %01000010
        .db     %00111100
        .db     8,8
        .db     %00111100
        .db     %01000010
        .db     %10011001
        .db     %10111101
        .db     %10111101
        .db     %10011000
        .db     %01000000
        .db     %00111000
        .db     8,8
        .db     %00111100
        .db     %01000010
        .db     %10011001
        .db     %10111101
        .db     %10111101
        .db     %00011001
        .db     %00000010
        .db     %00011100
        .db     -1

boss1l: .db     8,10
        .db     %00000001
        .db     %00000010
        .db     %00000010
        .db     %00011111
        .db     %00111111
        .db     %01111111
        .db     %10010010
        .db     %01111111
        .db     %00111111
        .db     %00011111

boss1r: .db     8,10
        .db     %10000000
        .db     %01000000
        .db     %01000000
        .db     %11111000
        .db     %11111100
        .db     %11111110
        .db     %01001001
        .db     %11111110
        .db     %11111100
        .db     %11111000
