; jump by scabby

#include ti.inc

#ifdef ION

screenwidth = 12
xoffs       = (-16)
SinCosTable = (saferam1+255)&~255
WorkArea    = saferam2

#else

screenwidth = 16
xoffs       = 0
SinCosTable = 9000h
WorkArea    = 9100h

#endif

ProgName:
  .db "Jump!",0
  .db "Score: 000",0
  .db "Best: ",0

Start:
  BCALL _runindicoff
  BCALL _clrLCD
  
  ; print text
  ld hl,0
  ld (_penCol),hl
  ld hl,ProgName
  BCALL _vputs
  ld a,xoffs + 40
  ld (_penCol),a
  BCALL _vputs
  ld a,xoffs*2 + 96
  ld (_penCol),a
  BCALL _vputs
  ld hl,(HiScore)
  call PutNum

  call BuildTrigTables
 
  ; set up player
  ld ix,Player1
  ld c,0 ; Y coordinate offset
  call InitPlayer
  ;ld ix,Player2
  ;ld c,-24
  ;call InitPlayer
  
GameLoop: 
#ifdef ION
  call ionFastCopy
#endif
  halt
  halt  
  
  BCALL _getky
  cp $36  
  call UpdatePlayer
  jr nc,GameLoop

Dead:
  ; save hiscore
  ld e,(ix+Score)
  ld d,(ix+Score+1)  
  dec de
  ld hl,(HiScore)
  or a
  sbc hl,de
  jr nc,NotNewHigh
  ld (HiScore),de
#ifdef TI86
  push de
  ld hl,_asapvar
  rst 20h
  rst 10h
  call 460Bh ; get address of program to AHL
  ld de,HiScore-_asm_exec_ram+2
  add hl,de
  adc a,0
  pop bc
  call _writeb_inc_ahl
  ld c,b
  call _writeb_inc_ahl
#endif
NotNewHigh:

  BCALL _clrScrn
  BCALL _homeup  
  ret

; player variable offsets
ManY = 0
Velocity = 2
Gravity = 4
RopePos = 5
RopeSpeed = 7
Score = 9
ScreenY = 11
PlayerSize = 12

InitPlayer:
  ld (ix+ScreenY),c
  xor a
  ld (ix+ManY),a
  ld (ix+ManY+1),0EFh
  ld (ix+Velocity),a
  ld (ix+Velocity+1),1
  ld (ix+Gravity),10h
  ld (ix+RopePos),a
  ld (ix+RopePos+1),40h
  ld (ix+RopeSpeed),a
  ld (ix+RopeSpeed+1),3
  ld (ix+Score),a
  ld (ix+Score+1),a

  ; draw men at sides
  ld a,47
  add a,c
  ld c,a 
  ld b,xoffs+24
  call FindPixel
  ld de,ManL
  push bc
  call DrawSprite
  pop bc
  ld b,xoffs+96
  call FindPixel
  ld de,ManR
  call DrawSprite

DrawPlayer:
  ; FindPixel
  ld a,(ix+ManY+1)
  push af
  add a,(ix+ScreenY)
  sub 0C0h
  ld c,a
  ld b,xoffs+56
  call FindPixel
  ; choose the sprite
  ld de,Man
  pop af
  cp 0F0h
  jr nc,ManOnGround
  ld de,ManJumping
ManOnGround:
  call DrawMan

DrawRope:
  ld a,(ix+RopePos+1)
  add a,48
  srl a
  ld l,a
  ld h,SinCosTable/256
  ld e,(hl)
  ld a,e
  rla
  sbc a,a
  ld d,a
  sra e
  sra e
  sra e
  ld l,0  
DrawRopeLoop:
  push hl
  push de
  ld a,l
  add a,xoffs+32 
  ld h,(hl) 
  ld l,0  
  ld b,8
MultLoop:
  add hl,hl
  jr nc,MultNc
  add hl,de
MultNc:
  djnz MultLoop
  ld b,a  
  ld a,h
  add a,50
  cp 55
  jr c,NotFloor
  ld a,55
NotFloor:
  add a,(ix+ScreenY)
  ld c,a  
  call DrawPixel
  pop de
  pop hl  
  inc l
  bit 6,l
  jr z,DrawRopeLoop
  ret  
   
UpdatePlayer:
  push af
  call DrawPlayer
  
  ld l,(ix+ManY)
  ld h,(ix+ManY+1)
  ld e,(ix+Velocity)
  ld d,(ix+Velocity+1)

  ; check if jump pressed
  pop af
  jr nz,NoJump
  ; are we on the floor?
  ld a,h
  cp 0F0h
  jr c,NoJump
  ; ok, jump (make velocity = 0ff00h)
  dec d
NoJump:

  ; add velocity
  add hl,de
  ex de,hl 
  ; add gravity onto velocity
  ld c,(ix+Gravity)
  ld b,0  
  add hl,bc
  ; has man landed?
  ld a,d
  cp 0F0h
  jr c,ManInAir
  ; yep, reset position to on floor
  ld de,0F000h
  ; and reset velocity to 0
  ld h,e
  ld l,e
ManInAir:
  ld (ix+ManY),e
  ld (ix+ManY+1),d
  ld (ix+Velocity),l
  ld (ix+Velocity+1),h
  
  ; update rope position
  ld l,(ix+RopePos)
  ld h,(ix+RopePos+1)
  ld e,(ix+RopeSpeed)
  ld d,(ix+RopeSpeed+1)
  add hl,de
  ex de,hl
  ld (ix+RopePos),e
  ld (ix+RopePos+1),d
  jr nc,NoScore
  ; rope has done full revolution 
  ; increment game speed
  ld de,8
  add hl,de
  ld (ix+RopeSpeed),l
  ld (ix+RopeSpeed+1),h
  ; increment score
  inc (ix+Score)
  jr nz,NoScoreWrap
  inc (ix+Score+1)
NoScoreWrap:
  ld l,(ix+Score)
  ld h,(ix+Score+1)
  ld a,xoffs + 62
  ld (_penCol),a
  push ix
  call PutNum  
  pop ix
NoScore:

  call DrawPlayer
 
  ; is rope on floor?
  ld a,(ix+RopePos+1)
  cp 32
  ret nc
  ; is man on floor?
  ld a,0EEh
  cp (ix+ManY+1)
  ret


DrawMan:
  push hl
  call DrawSprite
  pop hl
  inc l
DrawSprite:
  ld b,8
DrawManLoop:
  ld a,(de)
  inc de
  xor (hl)
  ld (hl),a
  ld a,l
  add a,screenwidth
  ld l,a
  jr nc,DrawNc
  inc h
DrawNc:
  djnz DrawManLoop
  ret
  
DrawPixel:
  call FindPixel
  xor (hl)
  ld (hl),a
  ret  

#ifdef ION
FindPixel:
  push bc
  ld a,b
  ld e,c
  call ionGetPixel
  pop bc
  ret
#else
FindPixel:
  push bc
  ld a,b
  and 7
  add a,offsets_table & 255
  ld e,a
  ld d,offsets_table/256
  ld h,0
  ld a,c
  add a,a
  add a,a
  rl h
  add a,a
  rl h
  add a,a
  rl h
  srl b
  srl b
  srl b
  or b
  ld l,a
  ld a,(de)
  dec h
  dec h
  dec h
  dec h
  pop bc
  ret
offsets_table:
  .db 128,64,32,16,8,4,2,1
#endif
  
PutNum:
  BCALL _divhlby10
  push af
  BCALL _divhlby10
  push af
  ld a,l
  call PutDigit
  pop af
  call PutDigit
  pop af
PutDigit:
  add a,'0'
  BCALL _vputmap
  ret

#include trigtab.asm
  
HiScore .dw 0

Man  .db 00000011b 
	 .db 00000100b 
	 .db 00000100b 
	 .db 00000011b 
	 .db 00000111b 
	 .db 00001011b 
	 .db 00000010b 
	 .db 00000010b
	 .db 11000000b
	 .db 00100000b
	 .db 00100000b
	 .db 11000000b
	 .db 11100000b
	 .db 11010000b
	 .db 01000000b
	 .db 01000000b  

ManJumping
	 .db 00000011b 
	 .db 00000100b 
	 .db 00000100b 
	 .db 00001011b 
	 .db 00000111b 
	 .db 00000011b 
	 .db 00000010b 
	 .db 00000010b
	 .db 11000000b
	 .db 00100000b
	 .db 00100000b
	 .db 11010000b
	 .db 11100000b
	 .db 11000000b
	 .db 01000000b
	 .db 01000000b  

ManL .db 00111100b
	 .db 01000010b
	 .db 01000010b
	 .db 00111101b
	 .db 00111110b
	 .db 00111100b
	 .db 00100100b
	 .db 00100100b

ManR .db 00111100b
	 .db 01000010b
	 .db 01000010b
	 .db 10111100b
	 .db 01111100b
	 .db 00111100b
	 .db 00100100b
	 .db 00100100b
	 
Player1 = WorkArea
Player2 = WorkArea + PlayerSize

.end
