#include "ti86asm.inc"

.org _asm_exec_ram

GameStart:
	call ProgStart
	call highscoreroutine
	ld hl, (score)
	ld de, $0600
	call drawnumber
	ld hl, (hiscore)
	ld de, $0701
	call drawnumber
	ld hl, scoretxt+1
	ld de, 0
	call drawstring
	ld hl, scoretxt
	ld de, $0001
	call drawstring
	jp _pause

scoretxt:
	.db "HScore:", 0
hiscore:
	.dw 0

drawnumber:
	xor a
	ld (_CurRow), de
	jp _dispAHL
drawstring:
	ld (_CurRow), de
	jp _puts

highscoreroutine:
	ld hl, (score)
	ld de, (hiscore)
	ld a, d
	cp h
	jr c, highscoreset
	jr z, checksame
	ret 
checksame:
	ld a, e
	cp l
	ret nc
highscoreset
	ld (hiscore), hl
	push hl
	ld hl, name-1					
	rst 20h
	rst 10h
	ld a,b
	ex de,hl
	call _load_ram_ahl
	ld de,hiscore-$d744		;-$d744 = -$d748 (program counter) + 4 (header thingy)
	add hl,de
	pop de
	ld (hl), e
	inc hl
	ld (hl), d
	ret

ProgStart:
	call _clrLCD
	call _runindicoff
	ld hl, frequency
	ld a, 64
	ld (hl), a
	inc hl
	ld (hl), a
	ld a, 32
	inc hl
	ld (hl), a
	ld hl, 0
	ld (score), hl
gameloop:
	ld hl, (score)
	inc hl
	ld (score), hl
	ld a, (y)
	ld de, $fbe0
	call getypos
	ld de, $0010
	ld (hl), d
	add hl,de
	ld a, %11110000
	ld (hl), a
	add hl, de
	ld a, %11111110
	ld (hl), a
	push hl
	add hl, de
	ld a, %11110000
	ld (hl), a
	add hl, de
	ld (hl), d
	call _getky
	pop hl
	cp K_EXIT
	ret z
	push hl
	ld a, (score)
	and 1
	or a
	jr z, nogoup
	ld a, r
	and %00111110
	xor %00111100
	inc a
	ld de, $fc0f
	call getypos
	ld a, %00000011
	or (hl)
	ld (hl), a
	ld hl, y
	ld a, %01111110
	out (1), a
	in a, (1)
	bit 3, a
	jr nz, nogodown
	ld a, (hl)
	cp 4
	jr z, nogodown
	dec (hl)
	dec (hl)
nogodown:
	in a, (1)
	rra
	jr c, nogoup
	ld a, (hl)
	cp 60
	jr z, nogoup
	inc (hl)
	inc (hl)
nogoup:
	or a
	ld hl, $ffff
	ld b, 64
ngulp:
	push bc
	ld b, 4
ngulp2:
	rl (hl)
	dec hl
	rl (hl)
	dec hl
	rl (hl)
	dec hl
	rl (hl)
	dec hl
	djnz ngulp2
	pop bc
	or a
	djnz ngulp
	pop hl
	ld a, 1
	and (hl)
	ret nz							;check for collision
	ld hl, next
	dec (hl)
	ld a, (hl)
	jp nz, gameloop
	ld hl, frequency
	dec (hl)
	ld a, (hl)
	cp 10
	jr nz, skipass
	inc a
	ld (hl), a
skipass:
	ld (next), a
	ld a, r
	and %00011100
	rra
	rra
	ld l, a
	ld h, b
	ld de, sprites
	add hl, de
	ld a, r
	and %00000111
	ld d, a
    push hl    		            ; push hl to stack...                
    pop ix          		        ; ...and pop it into ix
    srl d              		    ; de = (128 * y) + x
    rra      		            ; carry flag -&lg; msb of a
    and $80     		    	    ; a is either $00 or $80   
    or 15         		        ; add x offset (remember x <= 15)
    ld e,a               	    ; de = (128 * y) + (x * 8)
    ld hl,$fc00        		    ; hl-> video memory
    add hl,de           		    ; hl-> video memory + offset
    ld b,8     		            ; initialize loop counter
    ld de,16        		        ; screen is 16 bytes wide
GPS_Loop
    ld a,(ix + 0)	            ; get byte from sprite
    ld (hl),a	                ; put byte on screen
    inc ix 		                ; move to next byte in sprite
    add hl,de		            ; move to next line on screen
    djnz GPS_Loop		        ; loop until sprite is drawn
	jp gameloop

getypos:
	add a, a
	add a, a
	ld l, a
	ld h, 0
	add hl, hl
	add hl, hl
	add hl, de
	ret

frequency:
	.db 0
next:
	.db 0
y:
	.db 0
score:
	.dw 0

sprites:
	.db %01111001
	.db %11111100
	.db %11110011
	.db %11000110
	.db %01011111
	.db %00011100
	.db %01100000
	.db %11110110
	.db %01111000
	.db %11111000
	.db %01111111
	.db %01111110
	.db %11111110
	.db %11111111
	.db %11111111
	.db %01111000

name:
	.db 3, "Fly"


.end
