
;---------------------------------------------;
;      Fast Game Start   by   Jason Bow       ;
;                                             ;
;            (jasonbow1@yahoo.com)            ;          
;---------------------------------------------;
;This is the start of a Phoenix-type game.    ;
;It will change sprites whenever you change   ;
;directions and it will shoot with the 2nd key;
;This routine is coded more for speed so it   ;
;might work well with a scrolling background. ;
;The FastSprite routine will not save the     ;
;background it simply XORs the sprite onto the; 
;screen so that the first time you call the   ;
;routine it will draw the sprite and the next ;
;time it will erase it.                       ;
;---------------------------------------------;
;---------------------------------------------;
;FastSprite was written by Tim Farrell        ;
;I like it because it quickly XORs the sprite ;
;---------------------------------------------;


#include "ti86asm.inc"
.org _asm_exec_ram
;-------------------------------;
;        USER VARIABLES         ;
;-------------------------------; user variables textShadow is empty space for storage [x] x=bytes
fireX        = _textShadow      ; [1]  bullet X coordinates
fireY        = _textShadow + 1  ; [1]  bullet Y coordinates
fire         = _textShadow + 2  ; [1]  tells if there is a shot
shipX        = _textShadow + 3  ; [1]  ship X coordinates
shipY        = _textShadow + 4  ; [1]  ship Y coordinates
facedir      = _textShadow + 5  ; [1]  direction facing for bullet
constantdir  = _textShadow + 6  ; [1]  direction to continue shot going
shipdirspr   = _textShadow + 7  ; [1]  ship direction sprite ship left or right sprite 
;-------------------------------; 
;        INITIALIZATION         ;               
;-------------------------------; initialize the screen
 call _flushallmenus            ; exit menus
 res indicRun,(iy+indicflags)   ; no run indicator
 call _clrScrn                  ; clear the screen
;-------------------------------; we don't want to waste time with interrupts or the down-left bug 
 di                             ; disable interrupts making it faster because no wasted time
;-------------------------------; initialize start-up 
 xor a                          ;
 ld (fire),a                    ; 0 = no fire
                                ;
 ld bc,$5756                    ; setup starting coordinates
 ld a,b                         ; b=X coordinate
 ld (shipX),a                   ; save for drawing
 ld a,c                         ; c is the Y coordinate
 ld (shipY),a                   ; again save for drawing
                                ; 
 ld hl,rightship                ; the first time the right sprite is drawn
 ld (shipdirspr),hl             ; set starting sprite
                                ; 
 call FastSprite                ; put it on the screen
;-------------------------------; 
;             KEYS              ;
;-------------------------------;
loop:               ;
 ld a,%01111110     ; row for the arrow keys (on port listings table)
 out (1),a          ; port 1 is the keypad;(loading the row(a) for the arrow keys will check them)
 in a,(1)           ; see if arrows were pressed
 rra                ; use the carry flags for time and space bit 0 (down) is moved to carry flags
 jr nc,down         ; if no carry (down was pressed) go down
 rra                ; check bit 1 (left) by moving to carry flags
 jr nc,left         ; if no carry then go left
 rra                ; see if bit 2 (right) carries
 jr nc,right        ; if not go right
 rra                ; rotate a again for bit 3 (up)
 jr nc,up           ; if pressed then go up
                    ;
 ld a,%00111111     ; row for 2nd and exit 
 out (1),a          ; check port 1 for keypresses
 in a,(1)           ; see if anything was pressed
 bit 5,a            ; bit 5 is for the 2nd key
 jp z,shoot         ; if pressed then shoot
 bit 6,a            ; bit 6 is for exit key
 jr nz,main         ; if not pressed go to main loop
                    ; otherwise exit program
 ei                 ; enable interrupts before exiting
 call _clrScrn      ; clear the screen
 ret                ; exit
;-------------------; 
;     MAIN LOOP     ;
;-------------------;
main                ; main check loop that everything goes through
 call fireshot      ;
 jr loop            ;
;-------------------; 
;   SHIP MOVEMENT   ;
;-------------------;
up:                 ;
 ld a,(shipY)       ; check to see if we're at the top
 or a               ; if Y=0
 jr z,main          ; then we don't move
 call drawship      ; erase ship 
                    ; (called drawship because ship is XORed to the screen- first ON next OFF)
 ld a,(shipY)       ; decrease Y 
 dec a              ; top left is (0,0) so up=lower number
 ld (shipY),a       ; put in new Y       
 call drawship      ; XOR (draw) ship 
 jp main            ; back to main loop
                    ;
down:               ; 
 ld a,(shipY)       ; check to see if we're at the bottom
 cp 56              ; bottom of screen is 56
 jr z,main          ; then we don't move if it is 56
 call drawship      ; erase ship by drawing it again
 ld a,(shipY)       ; move ship
 inc a              ; go away from top left (0,0)
 ld (shipY),a       ; increase Y 
 call drawship      ; draw
 jp main            ; back to main loop
                    ;
left:               ;
 ld a,(shipX)       ; check to see if we're at the left
 or a               ; 0 is left of screen
 jr z,main          ; if 0 then we don't move
 call drawship      ; erase the ship by XORing it again turning it off
 ld a,(shipX)       ; move left
 dec a              ; go toward origin (0,0) or left
 ld (shipX),a       ; decrease X 
 ld hl,leftship     ; since we're going left we want the left ship sprite
 ld (shipdirspr),hl ; put into the ship direction sprite
 xor a              ; for bullet direction 
 ld (facedir),a     ; 0=left so we shoot left
 call drawship      ; draw left ship sprite
 jp main            ; main loop
                    ;
right:              ;
 ld a,(shipX)       ; check if we're at the right edge of the screen
 cp 120             ; compare to 120
 jr z,main          ; our screen is only 120 pixels wide
 call drawship      ; erase ship by drawing again turning off same pixels we drew on
 ld a,(shipX)       ; ship X coordinate is for moving to the right
 inc a              ; away from (0,0) top left
 ld (shipX),a       ; save ship X coordinate
 ld hl,rightship    ; we need the right ship if we're moving right
 ld (shipdirspr),hl ; save it in the ship direction
 ld a,1             ; 1=right so we shoot right
 ld (facedir),a     ; bullet direction is to the right
 call drawship      ; draw one column to the right with our new coordinates and sprite
 jp main            ; back to main
;-------------------;
;      FIRING       ;
;-------------------;                                 
shoot               ; 2nd key
 ld a,(fire)        ; see if we have a shot on the screen yet
 or a               ; 0=no 1=yes
 jr z,newfire       ; if no shot then we make one
 jp nz,main         ; if we have a shot we go to main where it will be incremented
newfire             ; 
 ld a,1             ; start off by showing we have a shot out
 ld (fire),a        ; 1 means shot on the screen
 ld a,(facedir)     ; check to see which direction we're facing
 or a               ; 0 = left 
 jr z,startshotleft ; if 0 we will shoot left
;jr nz,startshotleft; example of optimization
;-------------------;
;startshotright     ; don't need this label because it goes through
 ld a,1             ; 1 = right
 ld (constantdir),a ; direction that bullet will keep going
 ld a,(shipX)       ; get our ship coordinates and put them to the bullet coordinates
 ADD a,8            ; we want to start 8 in front of us so it doesn't disturb our ship sprite
 ld (fireX),a       ; adding 8 will go to the right (the direction we are shooting)
 ld a,(shipY)       ; save our coordinates in the bullet coordinates
 ld (fireY),a       ; ship X to fire X   ship Y to fire Y
 call drawshot      ; draw the shot for the first time
 jp main            ; go to the main loop
startshotleft       ;
 xor a              ; 0 = left
 ld (constantdir),a ; we want the bullet to constantly go left
 ld a,(shipX)       ; get the ship X coordinates
 SUB 8              ; subtract 8 so it won't mess up the ship (8 by 8 sprite) 
 ld (fireX),a       ; and will be 8 closer to the left side which is 0 
 ld a,(shipY)       ; can't do    ld (fireY),(shipY)   because of syntax
 ld (fireY),a       ; so we go through a to save our coordinates
 call drawshot      ; draw our shot
 jp main            ; go to the main loop
;-------------------; 
;    FIRING LOOP    ;
;-------------------;                    
fireshot            ; called each loop
 ld a,(fire)        ; check if we have a shot on the screen
 or a               ; if 0 then no shot
 ret z              ; if no shot ret to the main loop (from where it was called)
                    ; if not 0 then we have a shot to move
 ld a,(constantdir) ; see which way to fire constantly (the direction we were facing when we shot)
 or a               ; 0=left
 jr z,fireshotleft  ; if 0 then we move the shot left
;jr nz,fireshotright; we don't need to put this because we go through
;-------------------;
;fireshotright      ; space saver, and we don't need the label
 ld a,(fireX)       ; check our bullet coordinates
 cp 120             ; if at right (120 is the right of the screen)
 jp z,resetshot     ; then reset our shot
                    ; if not at right then we have space to shoot right
 call drawshot      ; erase the shot (redraw the shot in the same place) it will be XORed off
 ld a,(fireX)       ; right is on the X-axis
 inc a              ; increase moving away from top left (0,0)
 ld (fireX),a       ; put it back in the fire X coordinates for later
 call drawshot      ; draw that shot
 ret                ; back to main loop
fireshotleft        ;
 ld a,(fireX)       ; check the bullet coordinates
 or a               ; 0 is at the far left
 jp z,resetshot     ; reset the shot
                    ; now we can move that bullet
 call drawshot      ; erase the shot because XORing will first turn it ON then the next time OFF
 ld a,(fireX)       ; change our X coordinate of the bullet
 dec a              ; closer to the top left (0,0) so left
 ld (fireX),a       ; back into the fire X coordinate
 call drawshot      ; now draw the shot onto the screen
 ret                ; main loop which called us
;-------------------;
resetshot           ; must be out of shooting space
 xor a              ; 0 means no shot on screen
 ld (fire),a        ; save it
 call drawshot      ; erase the shot
                    ; if we didn't reset the shot it would loop all around the calc world over and over
 ret                ; back to the main loop
;-------------------;
;     DRAWING       ;
;-------------------;
drawship:           ; put the ship coordinates into bc which is what our drawing routine needs         
 ld bc,(shipY)      ; it will simply put the Y into c saving one step by going through a
 ld a,(shipX)       ; put our X into b
 ld b,a             ; 
 ld hl,(shipdirspr) ;   ; sprite into hl
 call FastSprite    ; call our sprite routine
 ret                ;
                    ; 
                    ;
drawshot            ; bullet coordinates just like the ship coordinates            
 ld bc,(fireY)      ; shot Y into c   for now 0 in b
 ld a,(fireX)       ; now put our shot X into b
 ld b,a             ; so our shot (X,Y) is (b,c)
 ld hl,bullet       ; our sprite into hl
 call FastSprite    ; XOR the sprite either ON or OFF the screen
 ret                ;
;-------------------;
;      SPRITES      ;these are all of our sprites that will be drawn onto the screen
;-------------------;     
leftship            ;
    .db %00000000   ;        
    .db %00000001   ;          /|
    .db %00010011   ;    /|  ///|
    .db %00110111   ;   //|_////|
    .db %01111111   ;  <<<|_____|
    .db %00110111   ;   \\| \\\\|
    .db %00010011   ;    \|  \\\|
    .db %00000001   ;          \|
                    ;
rightship           ;
    .db %00000000   ;
    .db %10000000   ;  |\        
    .db %11001000   ;  |\\\  |\  
    .db %11101100   ;  |\\\\_|\\ 
    .db %11111110   ;  |_____|>>>
    .db %11101100   ;  |//// |// 
    .db %11001000   ;  |///  |/ 
    .db %10000000   ;  |/        
                    ;
bullet              ;
    .db %00000000   ;
    .db %00000000   ;
    .db %00000000   ;     ____
    .db %00111100   ;    |____|
    .db %00111100   ;    
    .db %00000000   ;
    .db %00000000   ;
    .db %00000000   ;
;-------------------;
;      ROUTINE      ; 
;------------------------------------;
;our putsprite routine               ;
;it will XOR the sprite to the screen;
;the first time it is called it will ;
;draw the sprite onto the screen     ;
;the second time it is called it     ;
;will erase the sprite               ;
;-------------------------------------
;    
;            
;FastSprite____________________________
;by Tim Farrell                       |
;Input: Sprite in (HL), (b,c)         |
;Output: Sprite xor'ed onto the screen|
;Destroyed: none                      |
;--------------------------------------
FastSprite:
    push af
    push bc
    push de
    push ix
    push hl
    push hl                 ;\
    pop ix                  ; > hl -> ix
    ld hl, FSByte           ;> point to Tempbyte
    ld (hl), c              ;> put c into Byte for later use
    ld a, b
    rrca                    ;\
    rrca                    ; > divide x by 8 in accumulator
    rrca                    ;/                      
    rld                     ;> Rotate left 4 bytes  
    or $FC                  ;> add a and $FC
    ld l, (hl)              ;\
    ld h, a                 ; > buncha loading going on
    ld a, b                 ;/
    and 7                   ;> mask out the shift number
    ld d, a                 ;> save the shift number
    ld e, 8
FSLoop:                         
    ld a, (ix)              ;> get sprite data
    ld b, a
    inc ix                  ;> point to new sprite data byte
    ld c, 0                 ;> clear c for shift use
    ld a, d                 ;> restore shift # for use
    cp 0
    jp z, NoShift
    ld a, b
    ld b, d
FSShift:
    srl a                   ;\
    rr c                    ; \
    dec b                   ;  > shift until b < 0
    jp z, Shiftend          ; /
    jp FSShift              ;/
NoShift:
    ld a, b
Shiftend:
    xor (hl)                ;> mix the shifted sprite w/screen
    ld (hl), a              ;> and draw it to the screen
    inc hl                  ;> hl points to next screen byte
    ld a, c                 ;> accumulate the remaining shifted data
    xor (hl)                ;> mix 'em
    ld (hl), a              ;> draw it
    ld a, 15                ;\
    add a, l                ; \
    ld l, a                 ;  > Inc the <HL> 1 y value.
    jp nc, FSNoinc          ; /
    inc h                   ;/
FSNoinc:
    dec e                   ; >check if loop is finished
    jp nz, FSLoop           ;/
    pop hl                  ;\
    pop ix                  ; \
    pop de                  ;  > mmmpop boop be doop mmmpop
    pop bc                  ; /  
    pop af                  ;/
    ret
FSByte: .db $00    

.end
