;MISh add-on file for the shell
;June 29, 1998

;Graph Screen Macros (Shouldn't affect ASM at all)
#DEFINE GUSE_GRAPH		res 0,(IY+$03)
#DEFINE GREDRAW_GRAPH		set 0,(IY+$03)
#DEFINE GLABELS_ON		set 6,(IY+$04)
#DEFINE GLABELS_OFF		res 6,(IY+$04)
#DEFINE GAXES_OFF		set 5,(IY+$04)
#DEFINE GAXES_ON		res 5,(IY+$04)
#DEFINE GCURSOR_OFF		set 4,(IY+$04)
#DEFINE GCURSOR_ON		res 4,(IY+$04)
#DEFINE GPOLAR_GC		set 3,(IY+$04)
#DEFINE GRECT_GC		res 3,(IY+$04)
#DEFINE GGRID_ON		set 2,(IY+$04)
#DEFINE GGRID_OFF		res 2,(IY+$04)
#DEFINE GSIMUL_G		set 1,(IY+$04)
#DEFINE GSEQ_G			res 1,(IY+$04)
#DEFINE GDRAW_DOT		set 0,(IY+$04)
#DEFINE GDRAW_LINE		res 0,(IY+$04)

;Printing option macros
#DEFINE	PB_ON_W			res 3,(IY+$05)
#DEFINE PW_ON_B			set 3,(IY+$05)
#DEFINE PM7_ROWS		set 1,(IY+$05)
#DEFINE PM6_ROWS		res 1,(IY+$05)
#DEFINE PSCROLL			set 2,(IY+$0D)
#DEFINE PNO_SCROLL		res 2,(IY+$0D)
#DEFINE PAFFECT_TEXT		set 1,(IY+$0D)
#DEFINE PNO_AFFECT_TEXT		res 1,(IY+$0D)

;Useful Misc. Command Macros:
#DEFINE APD_ON			set 3,(iy+8) ; Turns APD on!  Wow!
#DEFINE APD_OFF			res 3,(iy+8) ; Turns APD off!  Wow!

;rst commands
#DEFINE SEARCH_VAT		rst 10H	; Searches VAT for Variable (rst)
#DEFINE LD_OP1_HL		rst 20H	; OP1=(HL) (rst)

;Straight ROM Calls:
D_COLON		=$0094	; displays a : at normal text cursor
ETR_CHARPUT	=$0096	; same as ROM_CALL(TR_CHARPUT), but faster, and in
			; the same place in ALL ROM versions
UPDATE_BUSY	=$00AC	; update busy counter & redraw bitmap
READ_KEYPAD	=$01A2	; read key directly from port
APD_RESET       =$0115  ; resets $8009 to $A1

;Straight ROM Jumps
HOME_SCREEN	=$0462	; jump to home screen, and display contents of
			; TEXT_MEM as ascii equivalents

;Data Areas
APD_COUNTER	=$8008	; 2 byte counter used for APD
BLINK_COUNTER	=$800A	; 2 byte counter used for blinking cursors
DELCHAR_LEN	=$800F	; length of DELCHAR buffer (max 100)
DELCHAR_BUF	=$8010	; 100 byte buffer for copy/paste in program editor
OP1		=$8082	; OP1 register for variable manipulation (11 bytes)
OP2		=$808D	; OP2 register for variable manipulation (11 bytes)
OP3		=$8098	; OP3 register for variable manipulation (11 bytes)
OP4		=$80A3	; OP4 register for variable manipulation (11 bytes)
OP5		=$80AE	; OP5 register for variable manipulation (11 bytes)
OP6		=$80B9	; OP6 register for variable manipulation (11 bytes)
TEMP_STORAGE	=$827C	; 128 bytes
SCROLL_START	=$8B2F	; first row of scrolling for SCROLL_UP
SCROLL_END	=$8B30	; last row of scrolling for SCROLL_UP
ROM_TAB		=$FA70	; 30 byte ROM table for ZShell 4.0 compatiblity
HIGH_STACK	=$FA8E	; top of stack, a useable data area, but be careful

;Internal MISh routines (Straight Call Functions):
EXE		=$8C41	; input: (OP1)=Variable data, Output: Run the program
			; after checking header (ZS only)
SET_DEF		=$8C44	; set defaults for program execution
EXE_HL		=$8C47	; execute program, using HL to make (PROGRAM_ADDR)
			;	THIS DOES ZERO ERROR CHECKING!!!!!!
F_B_BYTES	=$8C4A	; fill B bytes with A at (HL)
RELOCATE	=$8C4D	; move a variable on to the end of the shell string

