#include "ti-85.h"
#include "mish14.h"

ROM_TABLE	=$FA70

.org $8BF9			;8BF9, duh! (If you don't know why, you need
				;to learn a little more about TASM)  This
				;must be patched in at 8BF9, or it won't work
				;the simplest way is just to store this in to
				;the current shell on the home screen
.db	$00,$FE,$01,$41,$00,$07
.db	$C3			;jump command

Point2Start:			;8C00 (address in mem)
.dw	Start
.db     "MISh",0,0,0

ZShell40:			;8C09 needed for ZShell 4.0 compatibility
	jp ROM_CALLER		;ROM_CALL(index)
	jp NZ,Return		;CALL_Z(addr)
	jp CALLER		;CALL_(addr)
	jp Z,Return		;CALL_NZ(addr)
	jp CALLER
	jp NC,Return		;CALL_C(addr)
	jp CALLER
	jp C,Return		;CALL_NC(addr)
	jp CALLER
	jp NZ,Return		;JUMP_Z(addr)
	jp JUMPER		;JUMP_(addr)
	jp Z,Return		;JUMP_NZ(addr)
	jp JUMPER
	jp NC,Return		;JUMP_C(addr)
	jp JUMPER
	jp C,Return		;JUMP_NC(addr)
	jp JUMPER

Program_Address:	;8C3C
.dw     $0000		;PROGRAM_ADDR

RomVersionByte:		;8C3E
.db     $00		;ROM_VERS

ZShellVersion:		;8C3F
.db     $40		;$40 for ZShell 4.0 compatibility (ZSHELL_VER)

ZShellBits:		;8C40	(ZS_BITS)
.db     $00		;warpout (for menus), and checksum recalc capability

Routines:
	jp Execute	;8C41	(EXE)
	jp SetDefaults	;8C44	(SET_DEF)
	jp ExeAtHL	;8C47	(EXE_HL)
	jp F_B_Bytes	;8C4A	(F_B_BYTES)

ROM30A:
.dw     $3FEE   ;TX_CHARPUT
.dw     $3B9E   ;D_LT_STR
.dw     $3BDA   ;M_CHARPUT
.dw     $3BE0   ;D_ZM_STR
.dw     $3C22   ;D_LM_STR
.dw     $3CA0   ;GET_T_CUR
.dw     $3D90   ;SCROLL_UP
.dw     $3DF6   ;TR_CHARPUT
.dw     $3DFC   ;CLEARLCD
.dw     $3E02   ;D_HL_DECI
.dw     $3E5C   ;CLEARTEXT
.dw     $3E68   ;D_ZT_STR
.dw     $3EA4   ;BUSY_OFF
.dw     $3EBC   ;BUSY_ON
.dw     $6C9A   ;FIND_PIXEL

ROM90:
.dw     $3FC5   ;TX_CHARPUT
.dw     $3B5D   ;D_LT_STR
.dw     $3B99   ;M_CHARPUT
.dw     $3B9F   ;D_ZM_STR
.dw     $3BE1   ;D_LM_STR
.dw     $3C77   ;GET_T_CUR
.dw     $3D67   ;SCROLL_UP
.dw     $3DCD   ;TR_CHARPUT
.dw     $3DD3   ;CLEARLCD
.dw     $3DD9   ;D_HL_DECI
.dw     $3E39   ;CLEARTEXT
.dw     $3E45   ;D_ZT_STR
.dw     $3E7B   ;BUSY_OFF
.dw     $3E93   ;BUSY_ON
.dw     $6B6D   ;FIND_PIXEL

F_B_Bytes:			;(F_B_BYTES) fill B bytes at HL with A
	ld (HL),A
	inc HL
	djnz F_B_Bytes
	ret

Execute:			;ZShell files only right now
	SEARCH_VAT
	ret C

	inc DE			;point it at the ZShell header, so we can
	inc DE			;check it
	ex DE,HL		;exchange, so we can use (HL)

	xor A			;A=0
	cp (HL)			;header part 1
	ret NZ			;kick out if not a ZShell 4.0 file
	inc HL
	ld A,$FD
	cp (HL)			;header part 2
	ret NZ			;kick out if not a ZShell 4.0 file
	inc HL			;point past header to checksum?
	ret NZ

	inc HL			;HL -> description data of file

ExeAtHL:
	ld DE,(PROGRAM_ADDR)	;can be run recursively (A program runs
	push DE			;another program)

	ld (PROGRAM_ADDR),HL	;set PROGRAM_ADDR, so programs will work

Execution:
	xor A			;looking for the zero at end of description
	ld BC,90		;90 bytes is longer than any description I've
	cpir			;ever seen
	ld (CallMan+1),HL	;execute from the byte after description

	ld HL,TEXT_MEM		;zero the text memory, like in ZShell
	ld B,168		;length of the text mem

	call F_B_Bytes
	call SetDefaults

	ROM_CALL(BUSY_OFF)	;turn off busy indicator

CallMan:
	call $FFFF		;will return to caller after program runs
	pop HL
	ld (PROGRAM_ADDR),HL
	ret

SetDefaults:			;sets all the defaults
	xor A			;A=0
	ld ($834B),A		;set printing parameters
	ld ($8353),A

	ld HL,$0000		;set printing parameters
	ld ($800C),HL		;Cursor position
	ld ($8334),HL		;Menu cursor position

	APD_OFF			;turn off APD
	ret

ROM_CALLER:			;194/192 clock cycles, without hldata
	ld (HLDATA+1),HL	;save for later, without a push

	pop HL			;get pointer for ret
	inc HL			;point it past the data byte of ROM_CALL()
	push HL			;put it back
	dec HL

	push AF			;save flags for later
	push DE
	ld E,(HL)		;get ROM_CALL number in E
	bit 7,E			;test if its FIND_PIXEL
	jr Z,NotFP		;if not, jr to NotFP
	ld E,$0E		;if so, make it $0E (FIND_PIXEL's actual
				;offset in memory)

NotFP:
	ld HL,ROM_TABLE		;HL -> current ROM table

NotFP2:
	sla E			;E*2
	ld D,0
	add HL,DE		;HL -> address word for ROM call in table

	ld E,(HL)
	inc HL
	ld D,(HL)		;ld DE,(HL)
	ld (CHANGER_JUMP+1),DE	;fix jp at end of routine

FixUp:
	pop DE
	pop AF			;it is here, instead of before, to ensure
				;that the flags are the same as before

HLDATA:				;20 clock cycles including changer jump
	ld HL,$FFFF		;the FF's will be overwritten EVERY time

CHANGER_JUMP:
	jp $FFFF		;the FF's will be overwritten EVERY time
 
CALLER:
	ld (HLDATA+1),HL	;save for later
	pop HL			;get pointer for ret
	inc HL			;point it past the data word of call
	inc HL
	push HL			;put it back
	dec HL
	dec HL

Common2Jump:
	push AF
	push DE
	
	ld E,(HL)		;get offset of call
	inc HL
	ld D,(HL)

	ld HL,(PROGRAM_ADDR)
	add HL,DE		;get actual address of subroutine

	ld (CHANGER_JUMP+1),HL	;change the jump pointer
	jr FixUp

JUMPER:
	ld (HLDATA+1),HL	;save for later
	pop HL			;get pointer for ret

	jr Common2Jump

Return:				
	ex (SP),HL
	inc HL
	inc HL
	ex (SP),HL
	ret

Start:
	ld HL,($800C)		;normal cursor position
	push HL
	
	call SetDefaults
	ld D,A

ROM_Fix:
	ld A,7
	out (5),A		;ROM page 7 to check ROM version
	ld A,($7FFF)

	ld HL,Common2ROMers
	push HL

	ld HL,ROM30A		;set source for copy

	ld E,$0			;ROM 3.0A+0=3.0A
	cp $57
	ret Z

	ld E,$3			;ROM 4.0/6.0 offset
	cp $8E
	ret Z

	cp $3D
	ret Z

	ld E,$7			;ROM 8.0 offset
	cp $97
	ret Z

	ld HL,ROM90		;set source for copy

	ld E,$0			;ROM 9.0+0=9.0
	cp $91
	ret Z

	ld E,$1B		;ROM 10.0 offset
	cp $35
	ret Z

KickOut:
	pop HL
	jr ExitBreak

Common2ROMers:
	push DE
	ld (ROM_VERS),A
	ld DE,ROM_TABLE		;set destination
	ld BC,15*2		;set # of pointers to copy
	ldir			;copy table
	pop DE

FixROM:
	ld B,14			;set # of pointers to fix
	ld HL,ROM_TABLE

ROM_Loop:
	push DE
	push HL
	call LD_HL_MHL
	add HL,DE
	ex DE,HL
	pop HL
	ld (HL),E
	inc HL
	ld (HL),D
	inc HL

	pop DE

	djnz ROM_Loop

CopyName:
	ld HL,LastEntry
	LD_OP1_HL
	SEARCH_VAT		;not checking if found, becase it MUST be
				;there, or your calc will crash itself
	ex DE,HL

	LD_OP1_HL

	ld HL,OP1
	ld A,(HL)		;get length byte of data in OP1

	or A			;zero length?
	jr Z,RunMenu		;run menu if so

	inc HL
	ld (HL),A		;put length in right place
	
	ld A,12
	dec HL
	ld (HL),A		;load string type in to OP1

	call Execute

ExitFromShell:
	set 1,(IY+13)
	ROM_CALL(CLEARTEXT)	;fill TEXT_MEM with spaces so we don't fill
				;the screen with garbage on exit

ExitBreak:
	call SetDefaults	;return with correct printing parameters

	pop HL
	ld ($800C),HL		;restore cursor

	jp HOME_SCREEN		;jump to home screen (displays contents of
				;text memory as ascii)

LastEntry:
.db	18,1,"!"		;program, name length of 1, Last Entry Prog.

MenuName:
.db	12,5,"AUTOR"		;String, Name Length of 5, MISh Auto Run str.

RunMenu:
	ld HL,MenuName
	LD_OP1_HL
	call Execute
	jr ExitFromShell

CopyIn:

.end

