 #include usgard.h

#DEFINE UsgStart $8BF9

UsgLength = $8BF7
noStr	  = $80DF
curVAT	  = $80E0
firstpg   = $80E2
curStr	  = $80E3
proglist  = $8100

 .org 0
 .db "Usgard Simple Shell v1.0",0

 ld hl,&ShellName
 ld de,USGSHELL
 ld bc,9
 ldir		       ; Set this shell as the standard shell
Restart:
 call CLEARLCD	       ; DE gets cleared by this call
 inc e
 ld ($8333),de
 ld hl,(PROGRAM_ADDR)
 call D_ZM_STR
 ld hl,$FC00
 ld b,112
RepFill:
 ld a,(hl)
 cpl
 ld (hl),a
 inc hl
 djnz RepFill
RestartVAT:
 ld hl,VAT_START-10    ; Skip the first entry, the Usgard string itself
 ld (curVAT),hl
 xor a
 ld (firstpg),a
ScanStrings:
 xor a
 ld (noStr),a
 ld hl,$0801
 ld ($8333),hl
 ld hl,$FC80
 ld bc,911
 call OTH_CLEAR
 ld hl,(curVAT)
 ld ix,proglist
Search:
 ld a,$0C
 call SEARCH_VAT
 jr c,EndOfVAT
 push hl
 ld a,(de)
 or a
 jr nz,NoAsmProg
 inc de
 ld a,(de)
 cp PROG_HEADER
 jr c,NoAsmProg
 inc de
 inc de
 ld hl,(PROGRAM_ADDR)
 call CP_HL_DE	       ; Check if the program found it the shell
 jr z,NoAsmProg
 push de
 ld hl,noStr
 inc (hl)
 ld hl,VATName
 push hl
 push ix
 pop de
 ld bc,9
 ldir
 push de
 pop ix
 pop hl
 call D_ZM_STR
 ld a,$24
 ld ($8333),a
 pop hl
 call D_ZM_STR
 ld hl,$8333
 ld (hl),1
 inc hl
 ld a,(hl)
 add a,7
 ld (hl),a
NoAsmProg:
 pop hl
 ld a,(noStr)
 cp 8
 jr nz,Search
EndOfVAT:
 ld (curVAT),hl
 ld hl,firstpg
 ld b,(hl)
 inc (hl)
 ld a,(noStr)
 or a
 jr nz,SelectProgram
 or b
 jp nz,&RestartVAT
 ld hl,&NoProgsTxt
 call D_ZM_STR
 call OTH_PAUSE
 ret
SelectProgram:
 xor a
Update:
 ld (curStr),a
Update2:
 call &InvertCurrent
 ld a,(noStr)
 ld c,a
WaitKey:
 ld (iy+8),$8C
 call GET_KEY
 or a
 jr z,WaitKey
 call UPDATE_APD
 ld (iy+8),$84
 cp K_ALPHA
 call z,&ShutDown
 cp K_MORE
 jp z,&ScanStrings
 cp K_EXIT
 ret z
 cp K_ENTER
 jr z,ExecuteProgram
 ld hl,curStr
 dec a
 jr z,CursorDown
 cp 3
 jr nz,WaitKey
 call &InvertCurrent
 ld a,(hl)
 dec (hl)
 or a
 jr nz,Update2
 ld a,c
 dec a
 jr Update
CursorDown:
 call &InvertCurrent
 ld a,(hl)
 inc a
 cp c
 jr nz,Update
 jr SelectProgram
ExecuteProgram:
 ld a,(curStr)
 ld h,9
 ld l,a
 call MUL_HL
 ld de,proglist
 add hl,de
 call VAR_EXEC
 ld hl,USG_BITS
 bit 1,(hl)
 ret nz
 jp &Restart

InvertCurrent:
 push hl
 ld a,(curStr)
 ld h,112
 ld l,a
 call MUL_HL
 ld de,$FC80
 add hl,de
 ld b,112
Invert:
 ld a,(hl)
 cpl
 ld (hl),a
 inc hl
 djnz Invert
 pop hl
 ret

ShutDown:
 call OTH_SHUTDOWN
 xor a
 ret

ShellName:
 .db "usgdsimp",0

NoProgsTxt:
 .db "No programs",0

.end
