 #include usgard.h

.org 0
.db "TSR Contrast changer",0

 call CLEARLCD
 ld ($8333),de
 ld hl,(PROGRAM_ADDR)
 push hl
 call CHECK_APPEND
 pop de
 jr z,InstallTSR
 jr c,RemoveTSR
 ld hl,&RemoveErrorTxt
ShowMessage:
 call D_ZM_STR
 call OTH_PAUSE
 ret

InstallTSR:
 ld hl,&TSR_Handler
 ld bc,TSR_End-TSR_Handler
 call APPEND
 jr c,InstallError
 push hl
 ld d,h
 ld e,l
 inc hl
 ld (hl),e
 inc hl
 ld (hl),d
 pop hl
 call INT_INSTALL
 jr nc,InstallOK
 call UNAPPEND
InstallError:
 ld hl,&InstallErrorTxt
 jr ShowMessage
InstallOK:
 ld hl,&InstallOKTxt
 jr ShowMessage

RemoveTSR:
 call INT_REMOVE
 call UNAPPEND
 ld hl,&RemoveOKTxt
 jr ShowMessage

TSR_Handler:
 ld de,0
 ld hl,Timer-TSR_Handler
 add hl,de
 ld a,(hl)
 or a
 jr z,CheckKeys
 dec (hl)
 ret
CheckKeys:
 ex de,hl
 ld hl,CONTRAST
 ld a,$FD
 out (1),a
 in a,(1)
 bit 1,a
 jr z,IncreaseContrast
 bit 2,a
 ret nz
 ld a,(hl)
 or a
 ret z
 dec a
 ld (hl),a
 out (2),a
UpdateTimer:
 ex de,hl
 ld (hl),25
 ret
IncreaseContrast:
 ld a,(hl)
 cp 31
 ret z
 inc a
 ld (hl),a
 out (2),a
 jr UpdateTimer
Timer:
 .db 0
TSR_End:

InstallOKTxt:
 .db "TSR installed successfully",0

InstallErrorTxt:
 .db "TSR couldn",39,"t be installed",0

RemoveOKTxt:
 .db "TSR removed successfully",0

RemoveErrorTxt:
 .db "TSR couldn",39,"t be removed",0

.end
