#include "ti-85.h"		;from ZShell
#include "summit.h"		;v1.0 please
XX      =TEXT_MEM2
#include "vrom.h"

WhichJump       =$FA70
Who             =$FA71

.org GRAPH_MEM

Jumps:
        jp ReloShell

CurrentShell:
.db     12,6,"ZShell",0,0,0

ExtraShell:
.db     12,6,"ZShell",0,0,0

FixDelo:
        ld HL,CurrentShell
        LD_OP1_HL
        SEARCH_VAT

        call Relocate

        ld A,(Who)
        cp 'R'
        jp Z,$8BFC

        jp $8BFF

ReloShell:
        call Delocate

        ld HL,ExtraShell
        LD_OP1_HL
        LD_OP2_OP1
        SEARCH_VAT
        jr C,FixDelo

        call Relocate

        ld HL,CurrentShell
        LD_OP1_HL

        ld HL,OP2
        ld DE,CurrentShell
        ld BC,10
        ldir

        ld HL,OP1
        ld DE,ExtraShell
        ld BC,10
        ldir

        ld HL,UpShell
        LD_OP1_HL
        SEARCH_VAT

        inc DE
        inc DE
        ex DE,HL
        ld DE,3
        add HL,DE
        ex DE,HL
        ld HL,CurrentShell
        ld BC,11
        ldir

        ld A,(WhichJump)
        cp 'R'
        jp Z,$8BFC

        jp $8BFF

UpShell:
.db     12,7,"UpShell"

Greater:
        ld BC,168

        sbc HL,BC               ;new length = old - 168

	pop DE			;DE points to length word of variable to move

	ex DE,HL
	ld (HL),E
	inc HL
	ld (HL),D
	dec HL
	ex DE,HL

	call MoveData

	ld DE,(TEXT_MEM)
        ld HL,168
	add HL,DE

	ex DE,HL		;DE -> new location of variable

Relocate:
ReloLoop:
	ld (TEXT_MEM),DE

	push DE
	pop HL			;ld HL,DE

	push DE
	call LD_HL_MHL

        ld DE,168              ;is length greater than 168?

	push HL
	sbc HL,DE
	pop HL

	jr Z,LessOrEqual
	jp P,Greater

LessOrEqual:
	push HL
	pop BC			;ld BC,HL   BC holds length to move

	pop DE			;DE points to length word of variable to move

	ex DE,HL
	ld (HL),0
	inc HL
	ld (HL),0
	dec HL
	ex DE,HL

MoveData:
	ld HL,$8BF7		;HL points to length word of shell

	push DE
	push HL

	call LD_HL_MHL

	push HL
	pop DE			;ld DE,HL
	ld (TEXT_MEM+5),DE

	add HL,BC		;make shell BC bytes bigger
	ex DE,HL
	pop HL

	push HL
	push DE
	ld HL,$8BF9
	ld DE,(TEXT_MEM+5)

	add HL,DE
	ld (TEXT_MEM+5),HL

	pop DE
	pop HL

	ld (HL),E
	inc HL
	ld (HL),D		;save new length info

	inc HL			;HL points to 1st byte of shell

	add HL,DE		;HL now points to 1st byte after shell
	ld (TEXT_MEM+7),HL

	ld HL,(TEXT_MEM+5)	;HL -> 1st overlap byte

	pop DE			;DE points to length word of variable to move



Fix:
	inc DE
	inc DE			;DE points to 1st byte of variable to move

	push BC
	push DE

	ex DE,HL
	sbc HL,DE
	ex DE,HL

	push DE
	pop BC

	ld (TEXT_MEM+2),BC	;store lddr's BC value
	pop DE
	pop BC

	ex DE,HL
	push DE
	push BC
        ld DE,TEXT_MEM2
	ldir
	pop BC
	pop DE
	ex DE,HL		;move data to video RAM, and add BC to DE

	push BC

	ld BC,(TEXT_MEM+2)
	
	add HL,BC		;HL -> MSB of length data for moving var
	dec DE			;Error Correction: off by one
	dec HL			;Error Correction: off by one
	lddr			;shift data up BC bytes

	pop BC

	push BC
        ld HL,TEXT_MEM2
	ld DE,(TEXT_MEM+5)
	ldir			;move data to shell
	pop BC

        jp AVATFix


Delocate:
        ld HL,PromName
        LD_OP1_HL
        SEARCH_VAT
        ret C

        inc DE
        inc DE

        ex DE,HL

        push HL
        call LD_HL_MHL
        ld DE,$00FE
        call CP_HL_DE
        pop HL                  ;compare header

        ret NZ

        inc HL
        inc HL

        ld BC,ReturnTo
        push BC

        ld BC,VROMName
        ld DE,XX

        jp (HL)

PromName:
.db     12,4,"PROM"

VROMName:
.db     12,4,"VROM"

ReturnTo:
        ld HL,($8BF7)
        ld (TEXT_MEM+2),HL

        ld HL,CurrentShell
        LD_OP1_HL
        SEARCH_VAT
        DELETE_VAR

        ld BC,2
        push BC
        ALLOCATE
        pop DE

        ld HL,(VAT_END)
        ld DE,$8BF7
        sbc HL,DE

        ld HL,(VAT_END)
        push HL
        pop DE
        dec HL
        dec HL

        push HL
        push DE
        ld DE,$8BF7
        sbc HL,DE
        push HL
        pop BC
        pop DE
        pop HL

        lddr

        ld HL,$FFFF
        ld (TEXT_MEM),HL
        ld BC,2
        call AVATFix

        ld HL,CurrentShell
        LD_OP1_HL
        SEARCH_VAT

        dec HL
        ld (HL),$F9
        dec HL
        ld (HL),$8B


        ld HL,(TEXT_MEM+2)
        ld ($8BF9),HL

        ld HL,0
        ld ($8BF7),HL
        ret

AVATFix:			;input: BC = amount to add to all affected
				;       VAT Entrys
	ld HL,$FA6C

FixVATLoop:
	ld E,(HL)		;name size byte
	dec HL

	ld D,0

	sbc HL,DE		;HL points to type byte for next var

	ld DE,(VAT_END)
	call CP_HL_DE
        ret Z                   ;exit when VAT is fixed

	dec HL
	ld E,(HL)
	dec HL
	ld D,(HL)		;DE holds address of var
	push HL
	ld HL,(TEXT_MEM)	;compare to original address of shrunk var

	ex DE,HL

	push HL
	sbc HL,DE
	pop HL

	ex DE,HL
	pop HL

	jr Z,False
	jp P,True

False:
	ex DE,HL
	add HL,BC
	ex DE,HL		;add DE,BC

True:
	ld (HL),D
	inc HL
	ld (HL),E		;put it back
	dec HL
	dec HL

	jr FixVATLoop
.end


