;MISh add-on file for the shell
;February 20, 1998

;Graph Screen Macros (Shouldn't affect ASM at all)
#DEFINE GUSE_GRAPH		res 0,(IY+$03)
#DEFINE GREDRAW_GRAPH		set 0,(IY+$03)
#DEFINE GLABELS_ON		set 6,(IY+$04)
#DEFINE GLABELS_OFF		res 6,(IY+$04)
#DEFINE GAXES_OFF		set 5,(IY+$04)
#DEFINE GAXES_ON		res 5,(IY+$04)
#DEFINE GCURSOR_OFF		set 4,(IY+$04)
#DEFINE GCURSOR_ON		res 4,(IY+$04)
#DEFINE GPOLAR_GC		set 3,(IY+$04)
#DEFINE GRECT_GC		res 3,(IY+$04)
#DEFINE GGRID_ON		set 2,(IY+$04)
#DEFINE GGRID_OFF		res 2,(IY+$04)
#DEFINE GSIMUL_G		set 1,(IY+$04)
#DEFINE GSEQ_G			res 1,(IY+$04)
#DEFINE GDRAW_DOT		set 0,(IY+$04)
#DEFINE GDRAW_LINE		res 0,(IY+$04)

;Cursor Macros
#DEFINE CURSOR_ON		set 2,(IY+$0C)
#DEFINE CURSOR_OFF		res 2,(IY+$0C)
#DEFINE ALPHA_ON		set 4,(IY+$12)
#DEFINE ALPHA_OFF		res 4,(IY+$12)
#DEFINE USE_ALPHA		res 5,(IY+$12)
#DEFINE USE_alpha		set 5,(IY+$12)
#DEFINE LOCK_ALPHA		set 6,(IY+$12)
#DEFINE ULOCK_ALPHA		res 6,(IY+$12)
#DEFINE INSERT_ON		set 6,(IY+$05)
#DEFINE INSERT_OFF		set 6,(IY+$05)

;Printing option macros
#DEFINE	PB_ON_W			res 3,(IY+$05)
#DEFINE PW_ON_B			set 3,(IY+$05)
#DEFINE PM7_ROWS		set 1,(IY+$05)
#DEFINE PM6_ROWS		res 1,(IY+$05)
#DEFINE PSCROLL			set 2,(IY+$0D)
#DEFINE PNO_SCROLL		res 2,(IY+$0D)
#DEFINE PAFFECT_TEXT		set 1,(IY+$0D)
#DEFINE PNO_AFFECT_TEXT		res 1,(IY+$0D)

;Useful Misc. Command Macros:
#DEFINE APD_ON                  set 3,(IY+8) ; Turns APD on!  Wow!
#DEFINE APD_OFF                 res 3,(IY+8) ; Turns APD off!  Wow!
#DEFINE BBUSY_ON                set 0,(IY+$12)  ;turns busy indicator on
#DEFINE BBUSY_OFF               res 0,(IY+$12)  ;turns busy indicator off

;rst commands
#DEFINE LD_OP2_OP1              rst 08H  ; 11 bytes copied from OP1 to OP2
#DEFINE SEARCH_VAT              rst 10H ; Searches VAT for Variable
#DEFINE LD_OP1_HL               rst 20H ; OP1=(HL)
#DEFINE MUL_OP1_OP2             rst 28H ; OP1=OP1*OP2 (FP)
#DEFINE ADD_OP1_OP2             rst 30H ; OP1=OP1+OP2 (FP)

;Straight ROM Calls:
D_COLON		=$0094	; displays a ":" at normal text cursor
ETR_CHARPUT     =$0096  ; same as TR_CHARPUT ROM_CALL, but faster and in the
			; same place in ALL ROM versions
UPDATE_BUSY	=$00AC	; update busy counter & redraw bitmap
READ_KEYPAD	=$01A2	; read key directly from port
ALPHA1          =$01CB  ; call ALPHA3 if alpha mode locked
ALPHA2          =$01D6
ALPHA3          =$01DA
APD_RESET       =$0115  ; resets $8009 to $A1
READ_KEY        =$0168  ; get keystroke into %A, use ports directly
ERR_WRITE	=$03D9	; write A% in to Error Buffer

;Straight ROM Jumps
HOME_SCREEN	=$0462	; jump to home screen, and display contents of
			; TEXT_MEM as ascii equivalents
D_ERROR         =$0A87  ; display Error number A%

;Data Areas
APD_COUNTER	=$8008	; 2 byte counter used for APD
BLINK_COUNTER	=$800A	; 2 byte counter used for blinking cursors
DELCHAR_LEN	=$800F	; length of DELCHAR buffer (max 100)
DELCHAR_BUF	=$8010	; 100 byte buffer for copy/paste in program editor
TOPR_BITMAP     =$8078  ; bitmap of top right corner of display (8 bytes)
OP1		=$8082	; OP1 register for variable manipulation (11 bytes)
OP2		=$808D	; OP2 register for variable manipulation (11 bytes)
OP3		=$8098	; OP3 register for variable manipulation (11 bytes)
OP4		=$80A3	; OP4 register for variable manipulation (11 bytes)
OP5		=$80AE	; OP5 register for variable manipulation (11 bytes)
OP6		=$80B9	; OP6 register for variable manipulation (11 bytes)
ANS_POINT       =$80D0  ; pointer to Ans
FINAL_VAT       =$80D6  ; pointer to last VAT entry
ERR_BUFFER      =$81AC  ; circular buffer used by error handler
C_FULL_SCR_VAR	=$81D0	; last var pointed at from full screen menu in format
			; of OP1
CURRENT_MENU	=$820E	; current menu pointers (10 bytes)
RAISED_MENU	=$8218	; current raised up menu (10 bytes)
LST_VAR_MENU	=$8222	; last variable menu shown
USER_MENU	=$8254	; string area used for TI-BASIC menus (40 bytes)
TEMP_STORAGE    =$827C  ; 128 bytes
SCROLL_START	=$8B2F	; first row of scrolling for SCROLL_UP
SCROLL_END      =$8B30  ; last row of scrolling for SCROLL_UP
CUSTOM_MENU     =$8BB1  ; custom menu data
HIGH_STACK      =$FA70  ; 30 byte ROM table for ZShell 4.0 compatiblity


;Internal MISh routines (Straight Call Functions):
EXE		=$8C41	; input: (OP1)=Variable data, Output: Run the program
			; after checking header (ZS only)
SET_DEF		=$8C44	; set defaults for program execution
EXE_HL		=$8C47	; execute program, using HL to make (PROGRAM_ADDR)
			;	THIS DOES ZERO ERROR CHECKING!!!!!!
F_B_BYTES	=$8C4A	; fill B bytes with A at (HL)

