#include "ti-85.h"
#include "summit.h"

ReloShell       =GRAPH_MEM
ExtraShell      =GRAPH_MEM+14

WhichJump       =$FA70
Who             =$FA71

.org 0
.db     "Summit BETA",0

        ROM_CALL(CLEARLCD)
        ld HL,0
        ld (CURSOR_ROW),HL

	ld HL,Name
	ld DE,(PROGRAM_ADDR)
	add HL,DE
	LD_OP1_HL
	SEARCH_VAT
	ret C

        ex DE,HL

        ld C,(HL)
        inc HL
        ld B,(HL)
        inc HL

        ld DE,GRAPH_MEM

	ldir

        ld HL,MenuString
        ld DE,(PROGRAM_ADDR)
        add HL,DE

        ROM_CALL(D_ZT_STR)

Keys:
        xor A
        ld (WhichJump),A

        call GET_KEY

;        cp $37                  ;exit
;        ret Z

        cp $22                  ;1
        jr Z,N1

        cp $1A                  ;2
        jr Z,N2

        cp $12                  ;3
        jr Z,N3

        cp $23                  ;4
        jr Z,N4

        jr Keys

N1:
        ld HL,ZShell
        jr Common

N2:
        ld HL,Usgard
        jr Common

N4:
        CALL_(SubChar)
        ld A,'R'
        ld (WhichJump),A
        ld HL,Rigel

        ld DE,$8BF9
        jr RigelIn

N3:
        ld HL,PhatOS

Common:
        ld DE,$8BFC

RigelIn:
        ld ($8BB3),DE

        ld DE,(PROGRAM_ADDR)
        add HL,DE
        push HL
        LD_OP1_HL
        SEARCH_VAT
        pop HL
        jr C,Keys

        push HL
        push AF
        im 1

        ld A,(ZSHELL_VER)
        cp $25
        CALL_Z(UsOut)

        ld A,($8BF9)
        cp 'A'
        CALL_Z(RigOut)

        pop AF
        pop HL


        ld DE,ExtraShell
        ld BC,10
        ldir                            ;set Switch to shell

        jp ReloShell

Name:
.db     12,7,"UpShell"

MenuString:
.db     "1-ZShell             "
.db     "2-Usgard             "
.db     "3-PhatOS             "
.db     "4-Rigel              ",0

ZShell:
.db     12,6,"ZShell",0,0,0

Usgard:
.db     12,6,"Usgard",0,0,0

PhatOS:
.db     12,6,"PhatOS",0,0,0

Rigel:
.db     12,5,"Rigel",0,0,0,0

UsOut:
        ld A,-1
        ld HL,$8CDB
        ld (HL),A
        inc HL
        ld BC,35

        jp $8CBF

RigOut:
        ld A,'R'
        ld (Who),A
        CALL_(AddChar)
        ret

AddChar:
        ld HL,$FA6F

        dec HL
        dec HL
        dec HL

        ld E,(HL)
        ld D,0

        inc (HL)

        inc HL

        sbc HL,DE

        ld DE,(VAT_END)

        sbc HL,DE
        push HL
        pop BC

        ld HL,(VAT_END)
        ld DE,(VAT_END)
        inc HL
        ldir

        ld HL,(VAT_END)
        dec HL
        ld (VAT_END),HL
        ld ($8BE5),HL
        ld ($8BE3),HL

        ret

SubChar:
        ld HL,$FA6F

        dec HL
        dec HL
        dec HL

        ld E,(HL)
        ld D,0

        dec (HL)

        sbc HL,DE

        ld DE,(VAT_END)

        push HL
        sbc HL,DE
        push HL
        pop BC
        pop HL

        push HL
        pop DE
        dec HL
        lddr

        ld HL,(VAT_END)
        inc HL
        ld (VAT_END),HL
        ld ($8BE5),HL
        ld ($8BE3),HL

        ret


SwShell:

.end


