#include "ti-85.h"
#include "summit.h"

.org 0
Header:
.dw     $00FE

Start:
        push DE

        push BC
        pop HL

        LD_OP1_HL
	SEARCH_VAT
	jr C,Error1		;error if not found

	ex DE,HL
	inc HL
	inc HL
	ld DE,$00FF
	push HL
	call LD_HL_MHL
	call CP_HL_DE
	pop HL
	jr NZ,Error2		;error if file corrupt

	inc HL			;HL -> # Patches
	inc HL

        ld A,7
        out (5),A
        ld A,($7FFF)
	ld C,A

	ld E,0

CheckROM:
	cp $35
	jr Z,Found

	inc E
	cp $91
	jr Z,Found

	inc E
	cp $97
	jr Z,Found

	inc E
	cp $3D
	jr Z,Found

	inc E
	cp $8E
	jr Z,Found

	inc E
	cp $57
	jr Z,Found

Error3:			;error if no correct ROM version
        ld A,'I'
        ret

Error2:                 ;error if corrupt ROM patch
        ld A,'C'
        ret

Error1:                 ;error if patch file not found
        ld A,'N'
        ret

Found:
	ld B,(HL)
	inc HL

	push BC

        xor A

        sla E

MulEB:
	add A,E
	djnz MulEB

Silly:
	ld C,A

	ld B,0

	add HL,BC

	pop BC

        pop DE

LoadPatches:
	ld A,$C3
	ld (DE),A
	inc DE			;load jump byte

	ld A,(HL)
	ld (DE),A
	inc HL
	inc DE			;low byte

	ld A,(HL)
	ld (DE),A
	inc HL
	inc DE			;high byte

	djnz LoadPatches

        ld A,'P'
	ret

.end


