#include "sptinmis.h"

.org $8BFF			;8BFF, duh! (If you don't know why, you need
				;to learn a little more about TASM)  This
				;must be patched in at 8BFF, or it won't work

.db	$C3			;jump command

Point2Start:			;8C00 (address in mem)
.dw	Start
.db     "TMISh",0,0

ZShell40:			;8C09 needed for ZShell 4.0 compatibility
	jp ROM_CALLER		;ROM_CALL(index)
	jp NZ,Return		;CALL_Z(addr)
	jp CALLER		;CALL_(addr)
	jp Z,Return		;CALL_NZ(addr)
	jp CALLER
	jp NC,Return		;CALL_C(addr)
	jp CALLER
	jp C,Return		;CALL_NC(addr)
	jp CALLER
	jp NZ,Return		;JUMP_Z(addr)
	jp JUMPER		;JUMP_(addr)
	jp Z,Return		;JUMP_NZ(addr)
	jp JUMPER
	jp NC,Return		;JUMP_C(addr)
	jp JUMPER
	jp C,Return		;JUMP_NC(addr)
	jp JUMPER

Program_Address:	;8C3C
.dw     $0000		;PROGRAM_ADDR

RomVersionByte:		;8C3E
.db     $35		;ROM_VERS (v10.0 is the default)

ZShellVersion:		;8C3F
.db     $40		;$40 for ZShell 4.0 compatibility (ZSHELL_VER)

ZShellBits:		;8C40	(ZS_BITS)
.db     $00		;warpout (for menus), and checksum recalc capability

ROM_TABLE:		;8C41	(ROM_TAB) change these to make another ROM
			;version work, or use a ROM patcher
			;calling these directly takes 27 clock cycles.
			;the old ZShell method takes 223.  Do you see a
	jp $3FE0	;TX_CHARPUT	;difference?  I do.
	jp $3B78	;D_LT_STR	;Direct calling also takes 1 less
	jp $3BB4	;M_CHARPUT	;byte.
	jp $3BBA	;D_ZM_STR
	jp $3BFC	;D_LM_STR
	jp $3C92	;GET_T_CUR
	jp $3D82	;SCROLL_UP
	jp $3DE8	;TR_CHARPUT
	jp $3DEE	;CLEARLCD
	jp $3DF4	;D_HL_DECI
	jp $3E54	;CLEARTEXT
	jp $3E60	;D_ZT_STR
	jp $3E96	;BUSY_OFF
	jp $3EAE	;BUSY_ON
	jp $6B6D	;FIND_PIXEL

ROM_CALLER:			;196/191 clock cycles, without hldata
	ld (HLDATA+1),HL	;save for later

	pop HL			;get pointer for ret
	inc HL			;point it past the data byte of ROM_CALL()
	push HL			;put it back
	dec HL

	push AF			;save flags for later
	push DE
	ld E,(HL)		;get ROM_CALL number in E
	bit 7,E			;test if its FIND_PIXEL
	jr Z,NotFP		;if not, jr to NotFP
	ld E,$0E		;if so, make it $0E (FIND_PIXEL's actual
				;offset in memory)

NotFP:
	ld HL,ROM_TABLE		;HL -> ROM table
	ld A,E
	add A,A
	add A,E			;A=E*3
	ld E,A			;DE=offset of ROM call
	ld D,0
	add HL,DE		;HL -> address word for ROM call in table

	ld (CHANGER_JUMP+1),HL	;fix jp at end of routine to point to ROM
				;jump table

FixUp:
	pop DE
	pop AF			;it is here, instead of before, to ensure
				;that the flags are the same as before

HLDATA:				;20 clock cycles including changer jump
	ld HL,$FFFF		;the FF's will be overwritten EVERY time

CHANGER_JUMP:
	jp $FFFF		;the FF's will be overwritten EVERY time
 
CALLER:				;
	ld (HLDATA+1),HL	;save for later
	pop HL			;get pointer for ret
	inc HL			;point it past the data word of call
	inc HL
	push HL			;put it back
	dec HL
	dec HL

Common2Jump:
	push AF
	push DE
	
	ld E,(HL)		;get offset of call
	inc HL
	ld D,(HL)

	ld HL,(PROGRAM_ADDR)
	add HL,DE		;get actual address of subroutine

	ld (CHANGER_JUMP+1),HL	;change the jump pointer
	jr FixUp

JUMPER:				;
	ld (HLDATA+1),HL	;save for later
	pop HL			;get pointer for ret

	jr Common2Jump

Return:				
	ex (SP),HL
	inc HL
	inc HL
	ex (SP),HL
	ret

Start:
SaveSettings:
	ld HL,($800C)		;normal cursor position
	push HL

SetDefaults:			;sets all the defaults
	xor A			;A=0
	ld ($834B),A		;set printing parameters
	ld ($8353),A

	ld HL,$0000		;set printing parameters
	ld ($800C),HL
	ld ($8334),HL

	ld (IY+8),$84		;turn off APD

CopyName:
	ld HL,TEXT_MEM-1
	LD_OP1_HL
	ld A,(OP1+1)		;get ascii length in A

	sbc A,$30		;ascii length-$30 to get actual length
	jr Z,ExitFromShell	;if it is equal to zero, exit (it can crash
				;the vat searcher if it is 0; I found out by
				;crashing my calc in school, with my homework
				;in the organiser.  Needless to say, that was
				;not fun.)
	ld (OP1+1),A		;put it in OP1 for variable search

	ld A,12
	ld (OP1),A		;load string type in to OP1

	SEARCH_VAT

	inc DE			;point it at the ZShell header, so we can
	inc DE			;check it
	ex DE,HL		;exchange, so we can use (HL)

	xor A			;A=0
	cp (HL)			;header part 1
	jr NZ,ExitFromShell	;exit if not a ZShell 4.0 file
	inc HL
	ld A,$FD
	cp (HL)			;header part 2
	jr NZ,ExitFromShell	;exit if not a ZShell 4.0 file

	inc HL
	inc HL			;HL -> description data of file

	ld (PROGRAM_ADDR),HL	;set PROGRAM_ADDR, so programs will work

Execute:
	xor A			;looking for the zero at end of description
	ld BC,30		;30 bytes is longer than any description I've
	cpir			;ever seen
	ld (CallMan+1),HL	;execute from the byte after description

	ld HL,TEXT_MEM		;zero the text memory, like in ZShell
	ld B,168		;length of the text mem

Z_B_BYTES:			;zero B bytes at HL
	ld (HL),A		;in this case, A is already 0 (saved a byte)
	inc HL
	djnz Z_B_BYTES

	ROM_CALL(BUSY_OFF)	;turn off busy indicator

CallMan:
	call $FFFF

ExitFromShell:
;	set 1,(IY+13)		;affect text memory
;	ROM_CALL(CLEARTEXT)	;pretty display at end
				;optional: 9 bytes

ExitBreak:
	pop HL
	ld ($800C),HL

	xor A
	ld ($834B),A

	jp HOME_SCREEN		;jump to home screen (displays contents of
				;text memory as ascii)

.end
