; super Tiny Menu Independant SHell v0.82 (MISh) with straight call ROM
; functions
; Saturday, November 22, 1997

;rst commands
#DEFINE LD_OP2_OP1		rst 08H	; OP2=OP1 (rst)
#DEFINE SEARCH_VAT		rst 10H	; Searches VAT for Variable (rst)
#DEFINE LD_OP1_HL		rst 20H	; OP1=(HL) (rst)

;ZShell Compatibility (JUMPs and CALLs)
#DEFINE CALL_Z(addr)            call $8C0C \ .dw addr
#DEFINE CALL_(addr)             call $8C0F \ .dw addr
#DEFINE CALL_NZ(addr)           call $8C12 \ .dw addr
#DEFINE CALL_C(addr)            call $8C18 \ .dw addr
#DEFINE CALL_NC(addr)           call $8C1E \ .dw addr
#DEFINE JUMP_Z(addr)            call $8C24 \ .dw addr
#DEFINE JUMP_(addr)             call $8C27 \ .dw addr
#DEFINE JUMP_NZ(addr)           call $8C2A \ .dw addr
#DEFINE JUMP_C(addr)            call $8C30 \ .dw addr
#DEFINE JUMP_NC(addr)           call $8C36 \ .dw addr

;ROM_CALL's
#DEFINE ROM_CALL(addr)          .db $CD \ .dw addr
#DEFINE ROM_CALL_C(addr)        .db $DC \ .dw addr
#DEFINE ROM_CALL_M(addr)        .db $FC \ .dw addr
#DEFINE ROM_CALL_NC(addr)       .db $D4 \ .dw addr
#DEFINE ROM_CALL_NZ(addr)       .db $C4 \ .dw addr
#DEFINE ROM_CALL_P(addr)        .db $F4 \ .dw addr
#DEFINE ROM_CALL_PE(addr)       .db $EC \ .dw addr
#DEFINE ROM_CALL_PO(addr)       .db $E4 \ .dw addr
#DEFINE ROM_CALL_Z(addr)        .db $CC \ .dw addr

;ZShell Data Areas:
PROGRAM_ADDR	=$8C3C	; current program address
ROM_VERS	=$8C3E	; current ROM version
ZSHELL_VER	=$8C3F	; ZShell version number $40 for ZShell 4.0
ZS_BITS		=$8C40	; completely non-functional

;Straight Calls:
LD_HL_MHL       =$0033  ; HL=(HL), A=L
INT_HANDLER     =$0038  ; normal interrupt handler for TI-85 (rst)
CP_HL_DE        =$008E  ; CP HL,DE (modifies flags only)
UNPACK_HL       =$009A  ; unpacks one digit of HL into %A
UPDATE_BUSY     =$00AC  ; updates busy counter, and redraws busy bitmap
UPDATE_APD      =$0115  ; updates counter for APD, giving 3 1/2 minute count
READ_KEY	=$01A2	; read key directly from keypad port
STORE_KEY       =$01B1  ; store immediate keystroke from %A
GET_KEY         =$01BE  ; get immediate keystroke into %A

;Straight Jumps
HOME_SCREEN	=$0462	; jump to home screen, and display contents of
			; TEXT_MEM as ascii equivalents

;ZShell 4.0 ROM call addresses	(fast MISh calls)
TX_CHARPUT	=$8C41	; xlated display of %A on screen, normal text style
D_LT_STR	=$8C44	; display length-byte normal text string
M_CHARPUT	=$8C47	; display %A on screen, menu style
D_ZM_STR	=$8C4A	; display zero-terminated string,  menu style
D_LM_STR	=$8C4D	; display length-byte string, menu style
GET_T_CUR	=$8C50	; HL = absolute address of text cursor
SCROLL_UP	=$8C53	; scroll text screen up
TR_CHARPUT	=$8C56	; raw display of %A on screen, normal text style
CLEARLCD	=$8C59	; clear LCD, but not text or graphics memory
D_HL_DECI	=$8C5C	; disp. HL as 5-byte, right just., blank-pad. decimal
CLEARTEXT	=$8C5F	; clear LCD and text memory (affected by 1,(IY+13))
D_ZT_STR	=$8C62	; display zero-terminated normal text string
BUSY_OFF	=$8C65	; turn off "busy" indicataor
BUSY_ON		=$8C68	; turn on "busy" indicator
FIND_PIXEL	=$8C6B	; Find location in RAM for a pixel on the GFX screen
			; WARNING! Page must be set to 4 before this function
			; is called! Do "ld a,4" and "out (5),a" to do that.
GRAPH2LCD	=$8C6E	; loads LCD with graph memory

;Data Locations
KEY_0		=$8000	; translated scancode of last key, but 0 if gotten
KEY_1		=$8001	; translated scancode of key down now
KEY_2		=$8002	; same as 8001, but $FF if more than one key is down
REPEAT_KET	=$8003	; countdown to key repeat
KEY_STAT	=$8004	; bit 2 set = key down now
LAST_KEY	=$8006	; last key presse
CONTRAST	=$8007	; contrast
COUNTER1	=$8008	; cursor blink/APD counter #1
COUNTER2	=$800A	; cursor blink/APD counter #2
CURSOR_ROW	=$800C	; text cursor row
CURSOR_COL	=$800D	; text cursor column

CURSOR_LET	=$800E	; letter under text cursor
DEL_CHAR_LEN	=$800F	; delchar buffer length
DEL_CHAR	=$8010	; delchar buffer start (length 100 bytes)
BUSY_COUNTER	=$8080	; counter for busy indicator
BUSY_BITMAP	=$8081	; bitmap for busy indicator
OP1		=$8082	; OP1 register for variable manipulators
OP2		=$808D	; OP2 register for variable manipulators
OP3		=$8098	; OP3 register for variable manipulators
OP4		=$80A3	; OP4 register for variable manipulators
OP5		=$80AE	; OP5 register for variable manipulators
OP6		=$80B9	; OP6 register for variable manipulators
CURR_INPUT	=$80C6	; -> current home-screen input
BYTES_USED	=$80CC	; # of used user memory (Add to 80C8 to find first
 			; byte of free memory)
ANS_POINT	=$80D0	; pointer to Ans
LAST_VAR	=$80D2	; pointer to last variable accessed
FINAL_VAT	=$80D6	; pointer to final VAT entry
TEXT_MEM	=$80DF	; text memory
CURSOR_ROW2	=$8187	; secondary text cursor row
CURSOR_COL2	=$8188	; secondary text cursor column
CHECKSUM	=$81BE	; memory checksum from 8BF7 to FA6F
CURSOR_X	=$8333	; x value of cursor
CURSOR_Y	=$8334	; y value of cursor
_IY_TABLE	=$8346	; where IY usually points
GRAPH_MEM	=$8641	; graphics memory
TEXT_MEM2	=$8A6B	; secondary text memory
USER_MEM	=$8B1B	; -> start of user memory
SCROLL_TOP	=$8B2F	; top row of scrolling window (0-7)
SCROLL_BOT	=$8B30	; bottem row of scrolling window (1-8)
FIXED_POINT	=$8B3A	; fixed-point decimal place (FFh for floating point)
VAT_END		=$8BEB	; -> one byte before end of VAT (backwards)
VAT_START	=$FA6F	; start of VAT
VIDEO_MEM	=$FC00	; video memory


; Key Scancode definitions
;                     Function                Character
K_NOKEY       =$00    ;No key
K_DOWN        =$01    ;Down
K_LEFT        =$02    ;Left
K_RIGHT       =$03    ;Right
K_UP          =$04    ;Up
K_ENTER       =$09    ;Enter
K_PLUS        =$0A    ;+                      X
K_MINUS       =$0B    ;-                      T
K_STAR        =$0C    ;*                      O
K_SLASH       =$0D    ;/                      J
K_RAISE       =$0E    ;^                      E
K_CLEAR       =$0F    ;Clear
K_SIGN        =$11    ;(-)                    Space
K_3           =$12    ;3                      W
K_6           =$13    ;6                      S
K_9           =$14    ;9                      N
K_RIGHTPAR    =$15    ;)                      I
K_TAN         =$16    ;Tan                    D
K_CUSTOM      =$17    ;Custom
K_DOT         =$19    ;.                      Z
K_2           =$1A    ;2                      V
K_5           =$1B    ;5                      R
K_8           =$1C    ;8                      M
K_LEFTPAR     =$1D    ;(                      H
K_COS         =$1E    ;Cos                    C
K_PRGM        =$1F    ;Prgm
K_DEL         =$20    ;Del
K_0           =$21    ;0                      Y
K_1           =$22    ;1                      U
K_4           =$23    ;4                      Q
K_7           =$24    ;7                      L
K_EE          =$25    ;EE                     G
K_SIN         =$26    ;Sin                    B
K_STAT        =$27    ;Stat
K_XVAR        =$28    ;x-Var                  x
K_ON          =$29    ;On
K_STO         =$2A    ;Sto                    =
K_COMMA       =$2B    ;,                      P
K_SQUARE      =$2C    ;x^2                    K
K_LN          =$2D    ;Ln                     F
K_LOG         =$2E    ;Log                    A
K_GRAPH       =$2F    ;Graph
K_ALPHA       =$30    ;Alpha
K_F5          =$31    ;F5
K_F4          =$32    ;F4
K_F3          =$33    ;F3
K_F2          =$34    ;F2
K_F1          =$35    ;F1
K_SECOND      =$36    ;2nd
K_EXIT        =$37    ;EXIT
K_MORE        =$38    ;MORE
