#include "ti-85.h"

.org 0
.db	$FE				;the header has to be $00,FE, or it
					;will not work!
	ld A,7
	out (5),A

	ld A,($7FFF)
	ld B,A
	ld A,(ROM_VERS)
	cp B
	ret Z

	ld A,$57			;ROM v3.0A
	cp B
	jr Z,ROM3

	ld A,$8E			;ROM v4.0
	cp B
	jr Z,ROM4

	ld A,$3D			;ROM v6.0
	cp B
	jr Z,ROM4

	ld A,$97			;ROM v8.0
	cp B
	jr Z,ROM8

	ld A,$91			;ROM v9.0
	cp B
	jr Z,ROM9

	ld A,$35			;ROM v10.0
	cp B
	jr Z,ROM10

	scf
	ret				;return with carry set

ROM3:
	ld (ROM_VERS),A
	ld DE,ROM3DATA
	jr Common

ROM4:
	ld (ROM_VERS),A
	ld DE,ROM3DATA
	CALL_(Common)
	ld L,$3
	jr FixAddresses

ROM8:
	ld (ROM_VERS),A
	ld DE,ROM3DATA
	CALL_(Common)
	ld L,$7
	jr FixAddresses

ROM9:
	ld (ROM_VERS),A
	ld DE,ROM9DATA
	jr Common

ROM10:
	ld (ROM_VERS),A
	ld DE,ROM9DATA
	CALL_(Common)
	ld L,$1B

FixAddresses:
	ld B,14
	ld H,0
	ld DE,$8C41

Repeater:
	push HL
	push BC

	push DE

	ex DE,HL
	ld C,(HL)
	inc HL
	ld B,(HL)
	inc HL
	ex DE,HL

	pop DE

	add HL,BC

	ex DE,HL
	ld (HL),E
	inc HL
	ld (HL),D
	inc HL
	ex DE,HL

	pop BC
	pop HL

	djnz Repeater
	ret

Common:
	ld HL,(PROGRAM_ADDR)
	add HL,DE
	ld DE,$8C41
	ld BC,30
	ldir

CReturn:
	ret NC
	ccf
	ret

ROM9DATA:				;ROM v10.0 = v9.0 +$1B
.dw     $3FC5   ;TX_CHARPUT
.dw     $3B5D   ;D_LT_STR
.dw     $3B99   ;M_CHARPUT
.dw     $3B9F   ;D_ZM_STR
.dw     $3BE1   ;D_LM_STR
.dw     $3C77   ;GET_T_CUR
.dw     $3D67   ;SCROLL_UP
.dw     $3DCD   ;TR_CHARPUT
.dw     $3DD3   ;CLEARLCD
.dw     $3DD9   ;D_HL_DECI
.dw     $3E39   ;CLEARTEXT
.dw     $3E45   ;D_ZT_STR
.dw     $3E7B   ;BUSY_OFF
.dw     $3E93   ;BUSY_ON
.dw     $6B6D   ;FIND_PIXEL

ROM3DATA:				;ROM v4.0/v6.0 = v3.0a +$3
.dw     $3FEE   ; TX_CHARPUT		;ROM v8.0 = v3.0a +$7
.dw     $3B9E   ; D_LT_STR
.dw     $3BDA   ; M_CHARPUT
.dw     $3BE0   ; D_ZM_STR
.dw     $3C22   ; D_LM_STR
.dw     $3CA0   ; GET_T_CUR
.dw     $3D90   ; SCROLL_UP
.dw     $3DF6   ; TR_CHARPUT
.dw     $3DFC   ; CLEARLCD
.dw     $3E02   ; D_HL_DECI
.dw     $3E5C   ; CLEARTEXT
.dw     $3E68   ; D_ZT_STR
.dw     $3EA4   ; BUSY_OFF
.dw     $3EBC   ; BUSY_ON
.dw     $6C9A   ; FIND_PIXEL

.end


