;Periodic85+
;by JL
;<jayell64@aol.com>
;http://members.aol.com/jayell64/home.htm
;Hopefully this is a well-commented source and will help those who need it!
;If you need some other help with asm, feel free to email me!

#include "usgard.h"	;file full of aliases used throughout this code
;(well, like D_ZT_STR and TEXT_MEM, among a bunch of others)

.org 0	;gotta make the calc think that the program starts at zero
.db "Periodic85+ v3.3 by JL",0	;title of program, zero terminated

;Variables:
CurEl   =       TEXT_MEM	;where the element number is stored (1)
CurPage	=	TEXT_MEM+1	;page flag (1)
CurEnt	=	TEXT_MEM+2	;entering flag (1)
AtPos	=	TEXT_MEM+3	;where to place atomic number (2)
TPos	=	TEXT_MEM+5	;position in table (1)

CurNum  =       TEXT_MEM+6	;variable used for a number of things (1)
CurChar =       TEXT_MEM+7	;keeps chars entered (6)
NameNum	=	TEXT_MEM+13	;# of matches found in symbol/name searching (1)
NameEl	=	TEXT_MEM+14	;# of last found element (1)
NumberString =	TEXT_MEM+27	;where to store temporary string (12 or *13*)


 call CLEARLCD	;clear the VIDEO_MEM (and bc and de)

 ld hl,CurEnt
 ld (hl),c	;entering byte=0 (atomic number entering)
 inc c	;a=1
 dec hl
 ld (hl),c	;default page
 dec hl
 ld (hl),c	;default element

 ld hl,&DB_ORXOR	;point hl to byte in routine
 ld (hl),$B6	;and make sure that instruction says 'or (hl)' and not
 push hl		;'xor (hl)'	;save that pointer
 ld c,20	;define (x,y) of table (b already equals 0)
 ld hl,&TableData	;point hl to table of elements ld c,20	;define beginning (x,y) coordinates (b's already 0)
 ld d,10	;10 rows down
PutTable:
 push bc	;save coordinates
 ld e,18	;18 columns across
PT_NewCol:
 push de	;save counters
 push hl	;save pointer to table
 ld a,(hl)	;get byte in table
 or a	;check if 0
 jr z,PT_NextBox	;if no element, don't display a box for it!
 push bc	;save coordinates
 call &DrawBox	;draw box at (b,c) ('or' it with video mem)
 pop bc	;restore
PT_NextBox:
 dec c	;one pixel down
 inc b	;one pixel across;now (b,c) points to middle of newly drawn box
 call FIND_PIXEL	;do a much-used ROM call
 ld de,VIDEO_MEM	;define offset
 add hl,de	;and add offset
 cpl	;xor 255
 and (hl)	;reset bit
 ld (hl),a	;and load into video mem
 inc c	;get c back to what it was
 inc b	;but point b to next box over
 pop hl	;restore pointer to table
 inc hl	;next byte
 pop de	;restore counters
 dec e	;decrease number of columns
 jr nz,PT_NewCol	;repeat
 pop bc	;restore coordinates to point to beginning of row
 dec c	;next row
 dec c
 dec d	;one less row
 jr nz,PutTable	;and repeat

 pop hl	;restore pointer to byte in routine
 ld (hl),$AE	;and make that instruction 'xor (hl)' that rest of the way
 ld hl,$3426	;x,y coordinates
 ld ($8333),hl	;into mem
 ld hl,(PROGRAM_ADDR)	;location of string (title)
 call D_ZM_STR	;and display
 jr SetupPage

ChangeScreen:	;changes screen from regular<->electron configuration
 ld bc,43*$10-1	;# of bytes to clear
 ld hl,GRAPH_MEM	;where to clear
 call OTH_CLEAR	;Guess what?  (Clear it!)
 call &CopyGMToVM	;copy Graph memory to the Video memory
SetupPage:
 ld hl,CurPage
 ld a,(hl)	;a holds 1 or 0
 or a	;if a isn't 1...
 jr nz,DispRegPage	;change page to regular page
 inc a		;if a is 0, change to 1
 ld (hl),a	;and load into memory
 ld hl,$1E00	;where to display the atomic number
 jr LoadATPos
DispRegPage:	;display regular information page
 xor a	;a=0
 ld (hl),a	;the current page is page 0 (default page)
 ld de,&ConsTextPos
 ld hl,&MPText
 ld a,6
 call &DispText
 ld hl,$0000	;coordinates to display atomic number on page 0
LoadATPos:
 ld (AtPos),hl	;and into mem
 call &CopyVMToGM


BigLoop:
 call &CopyGMToVM	;copies the GRAPH_MEM to the VIDEO_MEM
 call &BlinkCursor	;blinks cursor on table
 ld hl,CurNum	;point hl to where to clear
 ld bc,NumberString-CurNum	;bytes to clear
 call OTH_CLEAR	;clear the inputs and temp string


;next part just diplays the atomic number of the current element
 ld a,(CurEl)	;load a with the current element
 push af	;save a
 ld hl,(AtPos)	;hl=coordinates to place atomic number
 ld ($8333),hl	;and store in memory

 ld de,NumberString
 ld l,a
 ld h,0
DispHLLoop:
 call UNPACK_HL
 dec de
 add a,'0'
 ld (de),a
 ld a,l
 or h
 jr nz,DispHLLoop
 ex de,hl
 call D_ZM_STR

;this was the old way to display the atomic number :)
; ld l,a		;l=a
; ld h,100	;h=100
; call MUL_HL	;hl=100*a
; call DM_HL_DECI;display hl
; ld a,12	;where to begin erasing
; ld ($8333),a	;store in coordinate
; ld b,7	;7 spaces to erase
;ClearHL:
; ld a,32	;a=ascii char for space
; call M_CHARPUT	;put char
; djnz ClearHL	;put 7 pixel width spaces to erase last two 0's

 pop af	;restore a
 dec a		;a=a-1
 add a,a	;a=2*a
 ld hl,&ElTable	;point hl with address of the element table
 ld e,a		;next 2 lines store a into de, the eventual offset
 ld d,0
 add hl,de	;add offset so hl points to the address of the element info
 call LD_HL_MHL	;load hl with that address (only relative, though)
 ld de,(PROGRAM_ADDR)	;load de with address of program
 add hl,de	;add to hl to get absolute address of where element info is


 ld a,(CurPage)
 or a
 push af
 ld de,&TextPos
 jr z,DispInfoText
 ld de,&TextPos2
DispInfoText:
 ld a,2	;two strings to display
 call &DispText	;and display the strings at coor pointed to by de
 pop af
 jr nz,DispElecPageInfo


;**Here's a good description of what Convert2String does.**
;**This is different (and easier) than that of v3.2!**
;Feel free to use it in your own math/science programs that depend on
;	meerly displaying decimal constants and not actually computing with
;	them.  Of course, this is only space-saving if you have a lot (100
;	or so?) of numbers.  Don't forget to give me credit!
;*Form*
;All of the "compressed" numbers are in the following form:
;The first byte is a signal byte that tells the following:
;	First four bits give the number of decimal places in the string.
;	Next bit tells if the first datum is a byte (1) or a word (0)
;	Bit after is a trash bit that I'm thinking of using later...
;	Last two bits tell how many bytes/words are to be converted to a
;		string.
;If bits 3 is 0, then a word comes next, else it's a byte.  Only
;	the first spot can have a byte.
;None or more words come next, depending on bits 1 and 0 (they tell how
;	many words/bytes there are).
;*Examples*
;Here's some examples to illustrate the effectiveness of this "compression".
;--->	.db %01011010 \ .db 94\.dw 1007	<---
;This will be converted to "1.00794"
;%0101
;The first four bits indicate the number of decimal places.  Unlike the
;	routine in v3.2, this is actually the number of decimal places!
;%1
;The next bit indicates whether the first datum is a byte or a word.  0
;	means the first datum is a word; 1 is a byte.
;%0
;The next bit is a trash bit (for now).
;%10
;The last two bits are the number of data that are to be converted.  Since
;	there's a byte and a word, this value is %10=2.
;The data is stored kind of backwards, because of the nature of UNPACK_HL.
;	When typing the data, it's best to start from the front of the
;	string you want to display and work right, and store the values you
;	get from right to left.  Here, I started with 1007 and then 94.
;	Since 94<255, it's able to be stored in a byte.  I also could've
;	done '... .db 4\ .dw 10079', and it doesn't make a difference.  Make
;	sure that all words are less than 65535!
;
;--->	.db %01100010\ .dw 602\ .dw 4002	<---
;This will be converted to "4.002602".
;Number of decimal places=6
;First datum is a word because bits 3 and 2=%00
;Number of data=2 (two words to convert)
;You may think I could've done '... .db 02\ .dw 40026', but my routine will
;	ignore the 0 in the 02, so the string would end up being "4.00262"
;	(after changing the number of decimal places to 9)
;
;--->	.db %00110001\ .dw 6941	<---
;This is easy.  It converts to "6.941".
;
;--->	.db %01101010\ .db 182\ .dw 9012	<---
;Basically same format as first example.  "9.012182"
;
;**Rule of Thumb:  Make the data fit the routine...don't make the routine
;	fit the data!!!***
;**If you just happen to want to use this routine but can't understand it,
;	please email me!!**


DispRegInfo:
 ld b,4	;4 number info things to convert into strings
Convert2String:
 push bc	;save counter
 ld a,(hl)	;load first info byte into a
; bit 5,a	;check if string
; jr z,C2S_DispNorm	;if not string, jump
; and %00001111
; ld b,a
; inc hl
; jp D_LM_STR
;C2S_DispNorm:
 and %11000000	;first two bits hold number of bytes/words used
 jr z,NothingToConvert
 push de
 rlca	;-> else, last 2 bits =  first 2 bits
 rlca	;/
 ld b,a	;and save into counter
 ld de,NumberString	;point to end of string that'll hold number
 ld a,(hl)	;get the byte back
 and %00001111	;lower nibble holds number of decimal places
 ld c,a	;and save into c
 ld a,(hl)	;get that byte a third time
 inc hl	;hl points to first word/byte to convert
 bit 4,a	;check if first datum's a byte or word
 jr z,ConvertHL	;if it's a word, continue normally
 ld a,(hl)	;else, load that byte into a
 push hl	;and save hl
 ld l,a	;load byte into hl
 ld h,0
 jr UnPackHLCounter	;convert byte

ConvertHL:
 push hl	;save pointer to words
 call LD_HL_MHL	;load hl with word pointed to by hl
 xor a	;a is 0 (flag for below...)
UnPackHLCounter:
 push af	;save flag
UnPackHL:
 call UNPACK_HL	;if hl=12345, then aft hl=1234 and a=5
 dec de		;ready for char
 add a,'0'	;add to 0 char for display
 ld (de),a	;load into string
 dec c	;subtract one decimal place
 jr nz,NoPutDecimal	;if not at decimal place yet, don't put decimal
 dec de		;ready for decimal
 ld a,'.'	;load decimal char into a
 ld (de),a	;and put into string
NoPutDecimal:
 ld a,l		;-> checks if hl is 0
 or h		;/
 jr nz,UnPackHL	;if not, more chars to unpack
 pop af		;restore flag (NZ=converted byte, ZF=converted word)
 pop hl		;restore pointer to info on element
 inc hl		;point to next byte/word
 jr nz,SkipWordJump	;if just converted a byte, don't inc hl twice
 inc hl	;inc twice
SkipWordJump:
 djnz ConvertHL	;decrease number of words/bytes and repeat
 ld a,1	;a=1 (for &DispText;number of strings to display)
 pop bc	;restore pointer to coordinates into bc (formerly de)
 push hl	;save pointer to info
 ex de,hl	;hl now points to beginning of zero-terminated temp string
 ld d,b	;de's now a pointer to coordinates
 ld e,c
 call &DispText	;and display string at hl
 pop hl	;restore pointer to element info
ContinueConvert:
 pop bc	;restore counter
 djnz Convert2String	;4 convertings
 jr DoneConvert	;jump to label
NothingToConvert:	;if there's nothing to convert, go here
 inc de	;point to next coordinates
 inc de
 inc hl	;point to next byte
 jr ContinueConvert	;and continue


DoneConvert:	;now to display oxidation states;for info, go to elem_p.h
 call &LoadCoor	;loads coordinates pointed to by de into mem
 ld a,(hl)	;load first byte into a
 and %00001111	;lower nibble holds number of ox states
 jr z,DispEntering	;if no ox states, display entering text
 ld b,a		;load into counter
DispOxStates:
 ld a,(hl)	;load byte into a
 inc hl		;ready for next byte
 and %11110000	;upper nibble of a becomes a
 rrca
 rrca
 rrca
 rrca
 call &DispOxInfo	;display info in nibble
 jr z,DispEntering	;if zero flag set, we're done
 ld a,(hl)	;load byte into a
 and %00001111	;get lower nibble
 call &DispOxInfo	;and display that info, too
 jr z,DispEntering	;again, if 0 flag set, we're done
 jr DispOxStates	;repeat


DispElecPageInfo:	;display electron configuration
; ld a,(CurEl)	;a holds the current element number
; cp 107		;if a>106...
; jr nc,DispEntering	;display entering string;don't display elec config

 ld a,(CurEl)	;a holds element number
 ld hl,&ElecTable	;table w/max number of electrons in each shell
 ld b,0		;start at level 0
DispLevels:
 cp (hl)	;is a smaller than element in table at hl?
 jr c,DoneLevel	;if so,finished displaying full levels
 sub (hl)	;subtract that level
 push af	;save a
 ld c,(hl)	;load c with number of electrons in current level
 call &DispElecLevel	;display that level
 pop af		;restore a
 jr z,DispEntering	;if a=0, then levels came out even, so done
 inc hl		;next number in table
 inc b		;next level
 jr DispLevels	;repeat until gotten to last level
DoneLevel:
 ld c,a		;load c with number to display at level b
 call &DispElecLevel	;and display level
 ld e,b		;save b into e
 ld hl,&ElecExcept+18	;point hl to end of table with "exception elements"
 ld a,(CurEl)	;element to look for
 ld bc,19	;number of bytes to check for
 cpdr		;and check the whole table
 jr nz,DispEntering	;if no match, skip next part
 ld d,a		;save a into d
 ld hl,&ElecExceptTable	;point hl at 2nd table
 sla c		;c=c*2
 add hl,bc	;add offset
 ld b,e		;restore b from e
 ld a,d		;restore a from d
 cp 57		;compare a to element 57
 jr c,NoIncB	;if a<57,don't point b to next level
 cp 78
 jr c,IncB	;if a>56 and a<78, point b to next level
 cp 89
 jr c,NoIncB	;if a>77 and a<89, don't point b to next level
IncB:
 inc b	;point b to next level
NoIncB:
 ld c,(hl)	;load c with electron number to change at level b
 inc hl		;ready for next time
 call &DispElecLevel	;display level
 ld a,(CurEl)
 and %11111110	;mask off last bit (doesn't change evens, odds subtract 1)
 cp 78		;if a=78 (%01001110) OR if a=79 (%01001111)...
 jr nz,NoDecBTwice	;if a is not element 78 or 79, don't dec b twice
 dec b		;decrease level...
NoDecBTwice:
 dec b		;decrease level (twice, maybe)
 ld c,(hl)	;electron number to display
 call &DispElecLevel	;display c at level b


DispEntering:	;outputs entering string (what you're entering)
 ld a,(CurEnt)	;a holds byte that tells which entering to display
 ld hl,$2B38	;where to display string
 ld ($8333),hl	;store in mem
 add a,a	;next three lines: a=a*6 (quick, 4-byte way to do it)
 ld c,a
 add a,a
 add a,c
 ld e,a	;de=a
 ld d,0
 ld hl,&ANText	;first string...
 add hl,de	;and add offset to get right string
 call D_ZM_STR	;display string


KeyLoop:	;check some key presses
 ld b,100	;check through that many times
KeyLoop2:
 call GET_KEY	;get scancode of last key pressed into a
 cp K_EXIT	;EXIT pressed?
 jr z,ClearGraph	;if so, return to Usgard (but first clear graph)
 cp K_LEFT
 jr z,GoLeft
 cp K_RIGHT
 jr z,GoRight
 cp K_DOWN
 jr z,GoDown
 cp K_UP
 jr z,GoUp
 cp K_SECOND
 jr z,ChangeEnt	;changes what you want to enter
 cp K_ENTER
 jr z,CheckEnter	;check where to go if enter pressed
 cp K_CLEAR
 jr z,ArrowBLJump	;clears current inputs
 cp K_MORE
 jp z,&ChangeScreen	;electron config page <-> regular info page
 cp K_F5
 call z,OTH_SHUTDOWN	;shutdown calc
 or a		;was a key even pressed?
 jr nz,CheckKey	;if so, check if it's a letter/number key
 halt ;wait for an interrupt (about 1/200th of a second);saves battery power
 djnz KeyLoop2	;repeat
ArrowFCJump:
 call &BlinkCursor	;flash cursor
 jr KeyLoop	;check for more key presses


ClearGraph:
 call CLEARLCD
 jp &CopyVMToGM


GoLeft:		;moves cursor left (really: element#=element#-1)
 ld a,(CurEl)	;load a with the current element number
 dec a		;a=a-1
 jr z,ArrowFCJump	;if a is 0, can't go left
 ld (CurEl),a	;load new element number back into mem
ArrowBLJump:
 jp &BigLoop	;jump back to start


GoRight:	;move cursor right (or add 1 to element#)
 ld a,(CurEl)	;again, load the element number into a
 inc a		;a=a+1
 cp 113		;check if a is past element 112, the last element
 jr nc,ArrowFCJump	;if so, can't go right
 ld (CurEl),a	;load new element number back into mem
 jr ArrowBLJump	;back (eventually) to BigLoop

GoDown:		;moves cursor down (for reals!)
 ld a,(TPos)	;load the table position of the current element into a
GoDown2:	;a is somewhere between 0 and 178 (I think)
 add a,18	;move a down one row (each row in TableData has 18 bytes)
 cp 180		;check if at end
 jr nc,ArrowFCJump	;if so, can't go down
 call &CheckPos	;check if there's an element at a's position
 jr nz,ArrowBLJump
 jr GoDown2	;continue checking

GoUp:	;moves cursor down;the whole thing's about the same as GoDown
 ld a,(TPos)	;load a with the table position
GoUp2:
 sub 18		;a=a-18
 jr c,ArrowFCJump	;if a<0, can't go up
 call &CheckPos	;check a's position
 jr nz,ArrowBLJump
 jr GoUp2	;repeat


ChangeEnt:	;changes entering from atomic #->symbol->name->atomic #
 ld a,(CurEnt)	;a is 0, 1, or 2
 inc a	;next entering
ChangeEntLoad:
 ld (CurEnt),a	;load into memory
 cp 3		;is a too big?
 jr c,ArrowBLJump	;if not, display element info
 xor a		;a changes from 3 to 0
 jr ChangeEntLoad	;and load into mem


CheckEnter:	;if enter's pressed, finds where to go
 ld a,(CurNum)	;load number of chars entered so far into a
 ld c,a		;save a into c (in case of atomic number entering)
 or a		;check if you've entered any chars
 jr z,ArrowFCJump	;if not, enter won't do anything
 ld a,(CurEnt)	;a is entering number
 or a		;is a=0 (atomic number entering)?
 ld a,c		;restore a
 jp z,&ANDone	;if so, check if done (a holds number entered so far)
 ld c,0		;else, put a 0 into the next char slot...
 jr CharLoad	;and jump


CheckKey:	;checks letter presses (and numbers)
 ld c,a		;save a into c
 ld a,(CurEnt)	;load a with current entering
 or a		;is a=0 (atomic number entering)
 ld a,c		;restore a from c
 jp z,&CheckKeyNumber	;if so, scan number table instead of letter table
 ld hl,&CharTable+25	;point hl to end of character table
 ld bc,26	;26 bytes to check
 cpdr		;and check
 jp nz,&KeyLoop	;if no matches, jump back
 ld a,(CurNum)	;load number of letters entered so far into a
 or a	;is a = to 0?
 ld a,'A'
 jr z,PutLet	;if so, first letter, so display that letter
 ld a,'a'	;else, display a little letter
PutLet:
 add a,c ;add offset (c=letter number;ex: A/a=1, B/b=2, etc.) from cpdr
 ld c,a	;save a into c (M_CHARPUT destroys it)
 call M_CHARPUT	;put char
CharLoad:	;if enter's pushed in symbol or name entering, start here
 ld hl,CurNum	;hl points to # of chars entered
 ld e,(hl)	;load that into de
 ld d,0
 inc (hl)	;one more char entered
 ld hl,CurChar	;address of where entered chars are
 add hl,de	;add offset
 ld (hl),c	;and load in char
NameEnter:
 xor a	;a=0
 ld (NameNum),a	;default # of names found=0
 ld hl,&ElTableEnd-2	;end of element table
 ld b,112	;112 elements to check
NameFindName:
 push hl	;save hl
 call LD_HL_MHL	;load hl with relative address of element
 ld de,(PROGRAM_ADDR)	;ld de with the program's address
 add hl,de	;and add offset

 ld a,(CurEnt)	;load current entering byte into a
 dec a	;is a=1? (meaning symbol entering)
 jr z,NoSkipSym	;if so, don't skip first string, since it is the symbol
 ld c,255	;define counter (any big number'll do...)
 xor a	;a=0
 cpir	;finds first non-zero byte after first zero (so hl points to name)

NoSkipSym:
 ld de,CurChar	;address of entered chars
 ld a,(CurNum)	;number of chars entered so far
 ld c,b	;save b into c
 ld b,a	;load number of chars entered into counter
NameFindName2:
 ld a,(de)	;load entered char into a
 cp (hl)	;compare to corresponding char in name/sym of element
 jr nz,NameNextName	;if not matching, try next element
 inc hl	;next char in element's name
 inc de	;next entered char
 djnz NameFindName2	;continue through number of entered chars

;found a match!
 ld hl,NameNum	;address of # of matches
 inc (hl)	;found one more
 inc hl	;next byte over holds last element number found
 ld (hl),c	;and save

NameNextName:	;if didn't match, start from here
 ld b,c	;restore counter
 pop hl	;pop back pointer to element table
 dec hl	;next address
 dec hl
 djnz NameFindName	;and check this next element

 ld a,(NameNum)	;else, load number of matches found into a
 or a	;is a=0?
 jr z,NameBLJump	;if no matches, clear entry
 dec a	;else, did we find only one match?
 jp nz,&KeyLoop	;if not, get another key
 ld a,(NameEl)	;else, load that element found into a
 ld (CurEl),a	;and save into memory
NameBLJump:
 jp &BigLoop	;then display the info


CheckKeyNumber:	;atomic number entering routine
 ld hl,&NumberTable+9	;hl points to end of number table
 ld bc,10	;10 bytes to check
 cpdr	;c now holds number pressed, if any
 jr nz,ANFCJump	;if zero flag isn't set, no match found;get new key
 ld hl,CurNum	;point hl to number entered so far
 ld a,(hl)	;next set of add's multiply the currently entered number by
 add a,a	;10	;a=a*2
 ld b,a		;b=a*2
 add a,a	;a=a*4
 add a,a	;a=a*8
 add a,b	;a=a*8+a*2=a*10
 add a,c	;add to number pressed from above;sets zf if 0
 jr z,ANFCJump	;jump out if total=0
 ld (hl),a	;load that number into mem;doesn't affect flags
 cp 12		;compare to 12...
 jr nc,ANCheckA	;and if a>11, done (since there aren't any 120s elements)
 ld a,c		;load the number pressed (again, from above) into a
 add a,'0'	;add with 0 character to get number to display
 call M_CHARPUT	;display number;cursor updated for next display
ANFCJump:
 jp &KeyLoop	;wait for another key
ANDone:
ANCheckA:
 cp 113		;check if too big
 jr nc,ANBLJump	;if so, go back to start
 ld (CurEl),a	;load a into mem
ANBLJump:
 jp &BigLoop


CopyGMToVM:
 ld hl,GRAPH_MEM	;source
 ld de,VIDEO_MEM	;destination
Copy:
 ld bc,1024	;bytes
 ldir	;copy
 ret
CopyVMToGM:
 ld de,GRAPH_MEM	;destination
 ld hl,VIDEO_MEM	;source
 jr Copy	;and copy


CheckPos:
 ld e,a		;these 2 lines load a into de\e
 ld d,0
 ld hl,&TableData	;point hl at the table
 add hl,de	;add to offset...
 ld a,(hl)	;load the element number (if any) hl points to in a
 or a		;check if 0 (meaning no element)
 ld a,e		;restore a (doesn't affect flags)
 ret z		;return if no element
 ld a,(hl)	;load element's number back into a
 ld (CurEl),a	;load a into mem
 ret	;return with zero flag not set


DispOxInfo:
 ld c,a	;save a into c
 and %00000111	;mask off bits to get ox number
 jr nz,DispOxNumber	;if not zero,then not 8
 ld a,8	;if a=0, then ox number should be 8
DispOxNumber:
 add a,'0'	;add for display
 call M_CHARPUT	;and display ox number
 ld a,c		;retrieve original nibble from c
 bit 3,a	;check bit
 ld a,210	;ascii char 210=negative sign
 jr z,DispSign	;if bit 3=0, display a negative sign
 ld a,'+'	;else, display a positive sign
DispSign:
 call M_CHARPUT	;and display char
 dec b	;decrease counter
 ret z	;and return with zero flag set if that's the last ox state
 ld a,','	;else, display a comma
 call M_CHARPUT
 inc a	;reset zero flag
 ret	;and return


DispText:;display text pointed to by hl at coordinates pointed to by de
 call &LoadCoor
 call D_ZM_STR	;display (next) string
 dec a	;display 'a' strings
 jr nz,DispText	;continue through 'a' times
 ret	;return
LoadCoor:	;load coordinates pointed to by de into mem
 ex de,hl	;de <-> hl
 ld c,(hl)	;load in msb
 inc hl	;next byte
 ld b,(hl)	;load in lsb
 inc hl	;and next byte
 ld ($8333),bc	;load coor into mem
 ex de,hl	;trade back
 ret


BlinkCursor:
 ld hl,&TableData+179	;where to look
 ld a,(CurEl)		;what to look for
 ld bc,180		;number of bytes to look at
 cpdr		;cp (hl)/dec hl/dec bc/(repeat)
 ld a,c
 ld (TPos),a	;save the resulting spot
;following divides a by 18;also defines y coor. (c) of cursor
 ld c,20	;9*2+2 (top of gfx table)
DivBy18:
 cp 18		;compare a to 18
 jr c,Div18Done	;if a<18, done
 sub 18		;a=a-18
 dec c		;c=c-1
 dec c		;c=c-1
 jr DivBy18	;jump to DivBy18
Div18Done:
 add a,a	;a=a*2
 ld b,a	;save x coordinate into b for DrawBox
 call &DrawBox	;draw box at (b,c), xor with screen
 ret	;and return to main program


DrawBox:	;draws a 3x3 box at (b,c) (will 'or' or 'xor' with screen;
 ld e,3		;depends on what DB_ORXOR is)	;3 rows
DB_NewRow:
 ld d,3	;and 3 columns
 push bc	;save (x,y) coor
DB_NewCol:
 call FIND_PIXEL	;define hl and a
 push de	;save counters
 ld de,VIDEO_MEM	;offset
 add hl,de	;and add offet to get absolute
 pop de	;restore counters
DB_ORXOR:
 or (hl)	;'or' it (or 'xor' it) with current screen
 ld (hl),a	;and load pixel into video mem
 inc b	;next column over
 dec d	;one less column
 jr nz,DB_NewCol	;put 3 pixels in that row
 pop bc	;restore (x,y) coor
 dec c	;move down a row
 dec e	;one less row
 jr nz,DB_NewRow	;and put three rows
 ret


;FindElement:	;points hl to the info at element a
; ld hl,&EL1
; dec a	;decrease a
; ret z	;return if element 1
; ld b,a	;else, define counter
; ld d,0
;FE_Loop:
; ld c,255
; xor a
; cpir
; cpir
; ld c,4
;FE_Loop2:
; ld a,(hl)
; bit 4,a
; jr z,FE_Word
; dec hl
;FE_Word:
; rlca
; rlca
; and %00000011
; add a,a
; inc a
; ld e,a
; add hl,de
; dec c
; jr nz,FE_Loop2
; ld a,(hl)
; and %00001111
; inc a
; inc a
; srl a
; ld e,a
; add hl,de
; djnz FE_Loop
; ret


DispElecLevel:
 push hl	;save hl to stack
 ld hl,&ElecPos	;load hl with table of string coordinates
 ld e,b		;b=electron level
 sla e
 ld d,0		;de=2*b
 add hl,de	;add offset to get hl to point to correct coordinates
 call LD_HL_MHL	;ld hl,(hl)
 ld ($8333),hl	;and put coordinates into mem

 ld hl,&ElecString	;hl points to 2 byte strings
 add hl,de	;add offset (d's already 0, so de=e)
 ld a,(hl)	;ld first character into a
 call M_CHARPUT	;display character
 inc hl		;next character
 ld a,(hl)	;into a
 call M_CHARPUT	;and display second character

 ld hl,$8334	;ld hl with address of display row, menu-style
 dec (hl)	;up one row
 dec (hl)	;up one row
 ld a,c		;c=number of electrons in that level b
 sub 10		;subtract 10
 jr c,NoDispTens	;if a carry, c<10
 ld c,a		;save result into c
 ld a,129	;load a with (tens-digit) 1 (129 is a small 1)
 call M_CHARPUT	;and put the character
NoDispTens:
 ld a,c		;load c back into a to display ones-digit
 add a,'0'	;add to '0'
 call M_CHARPUT	;and put number
 pop hl		;restore hl from stack
 ret		;return to where routine was called


NumberTable:
.db $21,$22,$1A,$12,$23,$1B,$13,$24,$1C,$14 ;ScanCodes of #s 0-9 in order

CharTable:      ;ScanCodes of letters A-Z (a-z) in order
.db $2E,$26,$1E,$16,$0E ;A-E
.db $2D,$25,$1D,$15,$0D ;F-J
.db $2C,$24,$1C,$14,$0C ;K-O
.db $2B,$23,$1B,$13,$0B ;P-T
.db $22,$1A,$12,$0A,$21 ;U-Y
.db $19                 ;Z

TableData:	;data to determine where to place cursor & draw boxes
.db  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2
.db  3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 6, 7, 8, 9,10
.db 11,12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,13,14,15,16,17,18
.db 19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36
.db 37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54
.db 55,56, 0,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86
.db 87,88, 0,104,105,106,107,108,109,110,111,112,0,0,0,0,0,0
.db  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
.db  0, 0,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71, 0
.db 0,0,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,0

ElecTable:	;maximum electrons in each shell
.db 2,2,6,2,6,2,10,6,2,10,6,2,14,10,6,2,14,10

ElecExcept:	;those elements that don't "follow the rules"
.db 24,29,41,42,44,45,46,47,57,58,64,78,79,89,90,91,92,93,96

ElecExceptTable:	;table with what to change levels to
.db 5,1		;24
.db 10,1	;29
.db 4,1		;41
.db 5,1		;42
.db 7,1		;44
.db 8,1		;45
.db 10,0	;46
.db 10,1	;47
.db 1,0		;57
.db 1,1		;58
.db 1,7		;64
.db 9,1		;78
.db 10,1	;79
.db 1,0		;89
.db 2,0		;90
.db 1,2		;91
.db 1,3		;92
.db 1,4		;93
.db 1,7		;96

ElecString:	;strings to display for each level
.db '1','s', '2','s', '2','p', '3','s', '3','p'
.db '4','s', '3','d', '4','p', '5','s', '4','d'
.db '5','p', '6','s', '4','f', '5','d', '6','p'
.db '7','s', '5','f', '6','d'

ElecPos:	;position of above strings (x,y)
.db 0,2,	10,6,	22,6,	22,12,	34,12
.db 34,18,	47,12,	47,18,	47,24,	60,18
.db 60,24,	60,30,	76,18,	76,24,	76,30
.db 76,36,	92,24,	92,30


ElTable:        ;addresses as defined in "elem_p.h" for elements 1-112
.dw EL1,EL2,EL3,EL4,EL5,EL6,EL7,EL8,EL9,EL10            ;1-10
.dw EL11,EL12,EL13,EL14,EL15,EL16,EL17,EL18,EL19,EL20   ;11-20
.dw EL21,EL22,EL23,EL24,EL25,EL26,EL27,EL28,EL29,EL30   ;21-30
.dw EL31,EL32,EL33,EL34,EL35,EL36,EL37,EL38,EL39,EL40   ;31-40
.dw EL41,EL42,EL43,EL44,EL45,EL46,EL47,EL48,EL49,EL50   ;41-50
.dw EL51,EL52,EL53,EL54,EL55,EL56,EL57,EL58,EL59,EL60   ;51-60
.dw EL61,EL62,EL63,EL64,EL65,EL66,EL67,EL68,EL69,EL70   ;61-70
.dw EL71,EL72,EL73,EL74,EL75,EL76,EL77,EL78,EL79,EL80   ;71-80
.dw EL81,EL82,EL83,EL84,EL85,EL86,EL87,EL88,EL89,EL90   ;81-90
.dw EL91,EL92,EL93,EL94,EL95,EL96,EL97,EL98,EL99,EL100  ;91-100
.dw EL101,EL102,EL103,EL104,EL105,EL106,EL107,EL108,EL109,EL110	;101-110
.dw EL111,EL112
ElTableEnd:
;gotta add (PROGRAM_ADDR) to get absolute address

;LinePos:
;.dw VIDEO_MEM+$70
;.dw VIDEO_MEM+$F0
;.dw VIDEO_MEM+$170

ConsTextPos:	;(x,y) of where to place the constant text
.db 72,0	;"MP:"
.db 72,6	;"BP:"
.db 0,18	;"1IE:"
.db 0,12	;"Ox:"
.db 39,58	;"<JayEll64@aol.com>"
.db 38,43	;"(2nd)"

TextPos:	;where to place element info
.db 0,6		;Symbol
.db 18,0	;Name
.db 18,6	;Mass
.db 99,0	;"MP"...
.db 97,6	;"BP"...
.db 58,18	;"1IE"...
.db 20,12	;"Ox"...

TextPos2:
.db 18,30	;symbol
.db 0,36	;name

ANText:
.db "At #:",0
.db "Sym: ",0
.db "Name:",0

MPText:
.db "MP(",212,"K):",0
.db "BP(",212,"K):",0
.db "1stIoEn(KJ/mol):",0
.db "OxSts:",0

.db "<JayEll64@aol.com>",0
.db "(2nd)",0

;actual element information is in "elem8xp.h"
#include "elem8xp.h"

.end

