;ok, to dispel myths about the z80's speed i've made a little program
;keep in mind that the numbers are not exact- just close. You will probably
;get different numbers each time you run the program!
;
;About the program: basically it runs for one second (uses an interrupt for
; timing) and then it counts the number of loops that were executed. there 
;are 41 machine cycles per loop (according to Zilog's User's Manual) and 
;at the end it tells you how many loops were executed. (4 byte variable)
;
;How to find the processor speed:
;take the second number displayed and multiply by $10000 (65536) and add to
;the first number. then multiiply the result by 41. your second number will
;probably be zero.
;
;Mhz = 41 * (LOOP + (LOOPH * 65536))
;
;	-Terry Peng

#include "usgard.h"

SEC200	= TEXT_MEM+0	;1/200 of a sec
DONE	= TEXT_MEM+2	;0=running, 1=the second is up
LOOP	= TEXT_MEM+4	;inc'ed each time through loop
LOOPH	= TEXT_MEM+6	;if LOOP goes all the way around to 0, inc LOOPH

.org 0
.db "timing the z80",0

	ld	hl,&int_hand
	call	INT_INSTALL	;timer starts now
lbl:				;mcycles:
	ld	hl,(LOOP)	;5
	inc	hl		;1
	ld	(LOOP),hl	;6
	xor	a		;1
	cp	h		;1
	jr	nz,ok		;3
	cp	l		;1
	jr	nz,ok		;3
	ld	hl,(LOOPH)	;5
	inc	hl		;1
	ld	(LOOPH),hl	;6
ok:
	ld	a,(DONE)	;4 
	or	a		;1 
	jr	z,lbl		;3
finish:				;total=41 mcycle/loop
	call	INT_REMOVE	;timer stops now

	call	CLEARLCD	;this routine displays the numbers
	ld	hl,$0000
	ld	(CURSOR_ROW),hl
	ld	hl,(LOOP)
	call	D_HL_DECI
	ld	hl,$0001
	ld	(CURSOR_ROW),hl
	ld	hl,(LOOPH)
	call	D_HL_DECI
	call	OTH_PAUSE
	ret

int_hand:			;timing routine
	ld	a,(SEC200)
	inc	a
	ld	(SEC200),a
	cp	200
	ret	nz
	ld	a,1
	ld	(DONE),a
	ret


.end
