;-------------------------------------------------------------------------------
;PLAINJUMP (C) 1997 BY ANDREAS ESS
;                      TUFERS 11
;                      A-6811 GOEFIS
;                      AUSTRIA/EUROPE
;                      ess.andreas@computerhaus.at
;                      http://andi.ganymed.org
;
;This is the Usgard version of Plainjump, nearly the same, but 300 bytes smaller
;through the use of Usgard functions + another ? bytes by clearing out stuff.
;Have fun with it,
;       Andreas
;-------------------------------------------------------------------------------

#INCLUDE "USGARD.H"             ;use the Usgard header file!

;-------------------------------------------------------------------------------
;Variables in text-memory:
;-------------------------------------------------------------------------------
LEVELY          = TEXT_MEM      ;position in level
JUMPFLAG        = TEXT_MEM+1    ;0 = no jump; 1 = up; 2 = down
SPEED           = TEXT_MEM+2    ;speed of ball
LIFE            = TEXT_MEM+3    ;lifes of player
SCORE           = TEXT_MEM+4    ;contains player's score
BALLY           = TEXT_MEM+6    ;only needed for savegame
BALLX           = TEXT_MEM+7
LEVELNAME       = TEXT_MEM+8
;--> saved from TEXT_MEM to TEXT_MEM+20
SAVELEN         = 17


SCROLLY         = TEXT_MEM+21    ;position in level-y
SCROLLY1        = TEXT_MEM+22    ;
SCROLLY2        = TEXT_MEM+23    ;
WHATPLAIN       = TEXT_MEM+24

LEVELPT         = TEXT_MEM+42   ;pointer to level data
ORIGLVL         = TEXT_MEM+44   ;pointer to start of level
PLAYERPT1       = TEXT_MEM+46 ;pointer to black-player image
ANICOUNT        = TEXT_MEM+48  ;animation counter


HiScoreTemp     = TEXT_MEM+28
TempByte        = TEXT_MEM+30
ANISCROLLC      = TEXT_MEM+31

LvlNo           = TEXT_MEM+35
Top             = TEXT_MEM+36
LvlMinusTop     = TEXT_MEM+37

Levels          = GRAPH_MEM

BackgroundTemp  = TEXT_MEM2

;-------------------------------------------------------------------------------
BITMAPMEM       = GRAPH_MEM

.org    0
.db     "PlaneJump v1.1",0


;-------------------------------------------------------------------------------
;Program start!
;-------------------------------------------------------------------------------
Title:
	call    CLEARLCD                ;In Usgard, you may use either
					;a normal call or a ROM_CALL!
	ld      HL, &TitlePicture       ;Automatic addition of PROGRAM_ADDR
					;using a & in front of a label!
	ld      DE, VIDEO_MEM+(16*7)
;Function calls make your life easier!
	#fncall ZCP
	ld      HL, &ByStr
	ld      DE, $3028
	ld      (CURSOR_X), DE
	call    D_ZM_STR
	ld      DE, $3706
	ld      (CURSOR_X), DE
	call    D_ZM_STR

Wait:
	call    GET_KEY                 ;A = key
	and     A                       ;no key pressed?
	jr      z, Wait

	ld      HL, &LevelSaved
	ld      A, (HL)
	and     A
	jr      nz, LoadGame

	call    &LoadLevel
	ret     c
	jr      RegularGame

;Wait until F1 released
LoadGame:
;Copy saved game to TEXT_MEM
	ld      (HL), 0
	inc     HL
	ld      BC, SAVELEN
	ld      DE, LEVELY
	ldir

	ld      HL, LEVELNAME
	call    VAR_GET
	ret     c
	inc     HL
	inc     HL
	ld      A, (LEVELY)
	ld      E, A
	ld      D, 0
	add     HL, DE

	ld      BC, (BALLY)
	jr      SetParams

RegularGame:
;Do some initialisation
	ld      A, 6
	ld      (LIFE), A
	ld      BC, $342E
SetParams:
	ld      (ORIGLVL), HL
	ld      (LEVELPT), HL
	ld      HL, &BlackBall1
	ld      (PLAYERPT1), HL
	jr      StartGameLoop

;Draw screen first time:
StartAfterLife:
	ld      BC, $342E
StartGameLoop:
	call    &DisplayInfo
	ld      HL, $0203
	ld      ($800C), HL
	ld      HL, &LifeStatus
	call    D_ZT_STR
	ld      A, (LIFE)
	ld      H, 0
	ld      L, A
	call    D_HL_DECI
WaitInfo:
	halt
	call    GET_KEY
	and     A
	jr      z, WaitInfo
	call    &ClearDBuf
	call    &DrawScreen
	call    &ScanBk

;-------------------------------------------------------------------------------
;The game loop:
;-------------------------------------------------------------------------------
GameLoop:
	call    &DrawBk
	ld      A, C
	cp      46
	jr      nz, TestKeys
	push    BC
	ld      A, B
	add     A, 8
	ld      B, A
	ld      C, 63-60
	call    FIND_PIXEL
	ld      DE, BITMAPMEM
	add     HL, DE
	and     (HL)
	pop     BC
	jp      z, &LostLife
TestKeys:
	call    OTH_ARROW               ;OTH_ARROW returns most used multikeys:
					;bit 0: down
	cp      $FF                     ;bit 1: left
					;bit 2: right
	jp      z, &Redraw              ;bit 3: up
TestLeftKey:                            ;bit 4: F1
	ld      D, A                    ;bit 5: 2nd
	ld      A, (SPEED)              ;bit 6: exit
	ld      E, A                    ;bit 7: more
	bit     1, d                    ;It's best to load the result into an
	jr      nz, TestRightKey        ;unused register an perform bit ?, reg
	ld      A, B
	cp      2
	jr      c, TestRightKey
	dec     B
	ld      A, E
	cp      3
	jr      nz, TestRightKey
	dec     B
TestRightKey:
	bit     2, d
	jr      nz, TestUpKey
	ld      a, b
	cp      127-16
	jr      nc, TestUpKey
	inc     b
	ld      a, e
	cp      3
	jr      nz, TestUpKey
	inc     b
TestUpKey:
	bit     3, d
	jr      nz, TestDownKey
	ld      A, E
	cp      3
	jr      nc, TestDownKey
	inc     E
TestDownKey:
	bit     0, D
	jr      nz, Test2ndKey
	ld      A, E
	and     A
	jr      z, Test2ndKey
	dec     E
Test2ndKey:     ;JUMP?
	ld      A, E
	ld      (SPEED), A
	bit     5, d
	jr      nz, TestExitKey
	ld      a, (JUMPFLAG)
	and     a
	jr      nz, TestExitKey
	inc     a
	ld      (JUMPFLAG), a

TestExitKey:
	bit     6, D
	jp      z, &ExitGame
TestPauseKey:
	bit     7, D
	jp      z, &Pause
TestF1Key:
	bit     4, D
	jp      z, &LSaveGame

Redraw:
	ld      A, (JUMPFLAG)
	and     A
	jr      z, ReallyRedraw
	dec     A
	jr      nz, FlyDown
	ld      A, C
	cp      20
	jr      z, SetFlyDown
	dec     C
	jr      ReallyRedraw
SetFlyDown:
	ld      A, 2
	ld      (JUMPFLAG), A
FlyDown:
	ld      A, C
	cp      46
	jr      nz, FlyDown1
	xor     A
	ld      (JUMPFLAG), A
	jr      ReallyRedraw
FlyDown1:
	inc     C
ReallyRedraw:
	ld      A, (SPEED)
	and     A
	jr      z, RedrawBall
	push    BC
	ld      B, A
DoScrolling:
	call    &DoScroll
	djnz    DoScrolling
	pop     BC

RedrawBall:
	call    &ScanBk
	ld      DE, &WhiteBall
	call    &WhiteSprite
	ld      DE, (PLAYERPT1)
	call    &BlackSprite

	ld      A, (ANISCROLLC)
	ld      HL, SPEED
	add     A, (HL)
	ld      (ANISCROLLC), A
	cp      6
	jr      c, GoOnMainLoop

	xor     A
	ld      (ANISCROLLC), A
	ld      HL, ANICOUNT
	inc     (HL)
	ld      A, (HL)
	cp      3
	jr      nz, NextFrame
	ld      (HL), 0
	ld      HL, &BlackBall1
	ld      (PLAYERPT1), HL
	jr      GoOnMainLoop
NextFrame:
	ld      HL, (PLAYERPT1)
	ld      DE, 32
	add     HL, DE
	ld      (PLAYERPT1), HL

GoOnMainLoop:
 ;copy GRAPH-MEM to LCD-MEM
	ld      DE, VIDEO_MEM
	ld      HL, BITMAPMEM
	push    BC
	ld      BC, 1024
	ldir
	pop     BC
J2GameLoop:
	jp      &GameLoop

Pause:
	call    GET_KEY
	and     A
	jr      z, Pause
	jr      J2GameLoop

LostLife:
	xor     A
	ld      (SPEED), A
NoFade:
	ld      A, (LIFE)
	dec     A
	jr      z, GameOver
	call    CLEARLCD
	ld      (LIFE), A
	xor     A
	ld      HL, SCROLLY
	ld      (HL), A
	inc     HL
	ld      (HL), A
	inc     HL
	ld      (HL), A
	inc     HL
	ld      (HL), A
	ld      HL, (LEVELPT)
FindStone:
	dec     HL
	ld      (LEVELPT), HL
	ld      A, (LEVELY)
	dec     A
	ld      (LEVELY), A
	jp      z, &StartAfterLife
	ld      C, $80
	ld      B, 1
FindStone1:
	ld      A, (HL)
	and     C
	jr      nz, FoundDone
	srl     C
	jr      z, FindStone
	ld      A, B
	add     A, 16
	ld      B, A
	jr      FindStone1
FoundDone:
	ld      C, 46
	jp      &StartGameLoop

GameOver:
	call    &HiScoreHand
	jr      ExitGame

LSaveGame:
	ld      (BALLY), BC
	ld      HL, &LevelSaved
	ld      (HL), 1
	inc     HL
	ld      DE, LEVELY
	ex      DE, HL
	ld      BC, SAVELEN
	ldir
	ld      HL, USG_BITS
	set     1, (HL)              ;Tell Usgard to warp out...
ExitGame:
	call    &ClearDBuf
	call    GET_KEY
	ret

;-------------------------------------------------------------------------------
;ClearDBuf: clears graphmem which is used as double buffer
;-------------------------------------------------------------------------------
ClearDBuf:
	push    BC
	ld      HL, BITMAPMEM
	ld      BC, 1023
	call    OTH_CLEAR       ;OTH_CLEAR clears BC+1 bytes at HL
	pop     BC
	ret

;-------------------------------------------------------------------------------
;WhiteLine: draws a horizontal, white line from (B,D) to (C,D)
;-------------------------------------------------------------------------------
WhiteLine:
 push   HL
 push   DE
 ld     A, C
 sub    B
 push   AF
 ld     A, 63
 sub    D
 ld     C, A
 call   FIND_PIXEL
 ld     DE, BITMAPMEM
 add    HL, DE
 ld     B, A
 pop    AF
 ld     C, A
WLoop:          ;ready-go!
 ld     A, B                 ;erase point
 cpl
 and    (HL)
 ld     (HL), A   ;and save it back to vid-ram

 dec    C         ;decrement X2 if X2 = X1 -> end
 jr     z, EndWhite

 rrc    B         ;shift mask
 jr     nc, WLoop
 inc    HL
 jr     WLoop
EndWhite:
 pop  de
 pop  hl
 ret

;-------------------------------------------------------------------------------
;BlackLine: draws a horizontal, black line from (B,D) to (C,D)
;-------------------------------------------------------------------------------
BlackLine:
 push   HL
 push   DE
 ld     A, C
 sub    B
 push   AF
 ld     A, 63
 sub    D
 ld     C, A
 call   FIND_PIXEL
 ld     DE, BITMAPMEM
 add    HL, DE
 ld     B, A
 pop    AF
 ld     C, A

BLoop:          ;ready-go!
 ld     A, (HL)   ;load byte from vid-ram
 or     B         ;set it to black
 ld     (HL), A   ;and save it back to vid-ram

 dec    C         ;decrement X2 if X2 = X1 -> end
 jr     z, EndBlack

 rrc    B         ;shift mask
 jr     nc, BLoop
 inc    HL
 jr     BLoop
EndBlack:
 pop    DE
 pop    HL
 ret

;-------------------------------------------------------------------------------
;DrawLine: this draws a line at y-pos D, accoriding to bits in E
;-------------------------------------------------------------------------------
DrawLine:
 push   BC
 push   IX
 ld     IX, &StartLine
 ld     B,  0
 ld     C,  D
 sla    C
 add    IX, BC
 add    IX, BC
;IX now contains pointer to StartLine1

 ld     L, $80
DrawLine_Loop1:
 ld     A, 63
 sub    (IX)
 ld     B, A
 ld     A, 63
 sub    (IX+1)
 ld     C, A
 bit    4, L
 jr     z, NotMiddle
 ld     C, 63
NotMiddle:
 inc    IX

 ld     A, E
 and    L
 jr     z, WhiteLine_1
 call   &BlackLine
 jr     DrawLine_Loop1_2
WhiteLine_1:
 call   &WhiteLine
DrawLine_Loop1_2:
 rrc    L
 ld     A, L
 cp     $08
 jr     nz, DrawLine_Loop1

 dec    IX
 ld     B, 63
 jr     SkipMiddle
DrawLine_Loop2:
 ld     A, (IX+1)
 add    A, 63
 ld     B, A
SkipMiddle:
 ld     A, (IX)
 add    A, 63
 ld     C, A
 dec    IX

 ld     A, E
 and    L
 jr     z, WhiteLine_2
 call   &BlackLine
 jr     DrawLine_Loop2_2
WhiteLine_2:
 call   &WhiteLine
DrawLine_Loop2_2:
 rrc    L
 jr     nc, DrawLine_Loop2
 pop    IX
 pop    BC
 ret

;-------------------------------------------------------------------------------
;Drawscreen
;-------------------------------------------------------------------------------
DrawScreen:
#ifdef OLD
 ld   hl, (LEVELPT)
 ld   e, (hl)
 ld   b, 32
DrawScrLoop:
 ld   a, b
 add  a, 32
 ld   d, a
 call   &DrawLine
 djnz DrawScrLoop
 ld   hl, (LEVELPT)
 inc  hl
 ld   e, (hl)
 ld   b, 32
DrawScrLoop1:
 ld   d, b
 call   &DrawLine
 djnz DrawScrLoop1
 ret
#else
 push   BC
 ld     IX, (LEVELPT)
 ld     E, (IX)
 ld     B, 31
DrawScrLoop:
 ld     A, B
 add    A, 32
 ld     D, A
 call   &DrawLine
 djnz   DrawScrLoop
 ld     E, (IX+1)
 ld     B, 21
DrawScrLoop1:
 ld     A, B
 add    A, 11
 ld     D, A
 call   &DrawLine
 djnz   DrawScrLoop1
 ld     E, (IX+2)
 ld     B, 11
DrawScrLoop2:
 ld     D, B
 call   &DrawLine
 djnz   DrawScrLoop2
 pop    BC
 ret
#endif

;-------------------------------------------------------------------------------
;DoScroll: handles scrolling
;-------------------------------------------------------------------------------
DoScroll:
#ifdef OLD
 ld     A, (SCROLLY)   ;increment SCROLLY
 inc    A
 ld     D, A
 ld     (SCROLLY), A   ;save it
 cp     32             ;SCROLLY = 32 ?
 jr     nz, LoadHLScr
 xor    A
 ld     D, A
 ld     (SCROLLY), a
 ld     H, A
 ld     L, A
 ld     ($8333), hl
 ld     HL, (SCORE)
 call   DM_HL_DECI      ;display HL menu style
 push bc
 ld   b, 6
 ld   de, BITMAPMEM
 ld   hl, VIDEO_MEM
CopyVid2Grf:
 push bc
 ldi
 ldi
 ldi
 ld   bc, 13
 add  hl, bc
 ex   de, hl
 add  hl, bc
 ex   de, hl
 pop  bc
 djnz CopyVid2Grf
 pop  bc
 ld   a, (LEVELY)    ;increment LEVELY
 inc  a
 ld   (LEVELY), a
 cp   254
 jr   nz, GoOnScroll
 xor  a
 ld   (LEVELY), a
 ld   hl, (ORIGLVL)
 ld   (LEVELPT), hl
GoOnScroll:
 ld   hl, (SCORE)
 ld   de, $0002
 add  hl, de
 ld   (SCORE), hl
 ld   hl, (LEVELPT)  ;and increment LEVELPT
 inc  hl
 ld   (LEVELPT), hl
LoadHLScr:
 ld   hl, (LEVELPT)  ;get Levelinformation from LEVELPT
 inc  hl
 ld   e, (hl)
 call   &DrawLine
 ld   a, (SCROLLY)
 add  a, 32
 ld   d, a
 ld   hl, (LEVELPT)
 ld   e, (hl)
 call   &DrawLine
 ret
#else
 ld     HL, SCROLLY
 inc    (HL)
 ld     A, (HL)
 cp     32                  ;SCROLLY = 32 ?
 jr     nz, LoadHLScr
 xor    A
 ld     (HL), a
 ld     D, A
 ld     H, A
 ld     L, A
 ld     (SCROLLY1), hl
 ld     (CURSOR_X), hl
 ld     HL, (SCORE)
 call   DM_HL_DECI
 push   BC
 ld     B, 6
 ld     DE, BITMAPMEM
 ld     HL, VIDEO_MEM
CopyVid2Grf:
 push   BC
 ldi
 ldi
 ldi
 ld     BC, 13
 add    HL, BC
 ex     DE, HL
 add    HL, BC
 ex     DE, HL
 pop    BC
 djnz   CopyVid2Grf
 pop    BC
 ld     A, (LEVELY)    ;increment LEVELY
 inc    A
 cp     251
 jr     nz, NoBonus
Bonus:
 ld     HL, LIFE
 inc    (HL)
NoBonus:
 cp     253
 jr     nz, GoOnScroll
 xor    A
 ld     HL, (ORIGLVL)
 inc    HL
 ld     (LEVELPT), HL
GoOnScroll:
 ld     (LEVELY), A
 ld     HL, (SCORE)
 ld     D, 0
 ld     A, (SPEED)
 ld     E, A
 add    HL, DE
 ld     (SCORE), HL
 ld     HL, (LEVELPT)  ;and increment LEVELPT
 inc    HL
 ld     (LEVELPT), hl
LoadHLScr:
 ld     A, (WHATPLAIN)
 inc    A
 cp     4
 jr     nz, WhatPlain_Set
 ld     A, 1
WhatPlain_Set:
 ld     (WHATPLAIN), a
 cp     2
 jr     z, Plain_2
 cp     3
 jr     z, Plain_3
Plain_1:
 ld     A, (SCROLLY1)
 inc    A
 ld     (SCROLLY1), A
 ld     D, A
 ld     HL, (LEVELPT)  ;get Levelinformation from LEVELPT
 inc    HL
 inc    HL
 ld     E, (HL)
 call   &DrawLine
Plain_2:
 ld     A, (SCROLLY2)
 inc    A
 ld     (SCROLLY2), A
 add    A, 10
 ld     D, A
 ld     HL, (LEVELPT)
 inc    HL
 ld     E, (HL)
 call   &DrawLine
Plain_3:
 ld     A, (SCROLLY)
 add    A, 32
 ld     D, A
 ld     HL, (LEVELPT)
 ld     E, (HL)
 call   &DrawLine
 ret
#endif


;-------------------------------------------------------------------------------
;ScanBk: stores background from(B,C)-(B+16,C+16) in BKPT
;-------------------------------------------------------------------------------
ScanBk:
 push bc
 ld     A, 63
 sub    C
 ld     C, A
 call   FIND_PIXEL
 ld     DE, BITMAPMEM
 add    HL, DE
 ld     DE, BackgroundTemp
 ;HL contains Video-Offset
 ;DE contains BkPt
 ;Now we are ready...
 ld     B, 16       ;16 lines to scan
ScanLoop:
 push bc
 ld   bc, 3
 ldir             ;move 4 bytes from hl to de
 ld   bc, 13
 add  hl, bc
 pop  bc
 djnz ScanLoop
 pop  bc
 ret

;-------------------------------------------------------------------------------
;DrawBk: draws background from(B,C)-(B+16,C+16) in BKPT
;-------------------------------------------------------------------------------
DrawBk:
 push bc
 ld     A, 63
 sub    C
 ld     C, A
 call   FIND_PIXEL
 ld     DE, BITMAPMEM
 add    HL, DE
 ld     DE, BackgroundTemp
 ex     DE, HL
 ;DE contains Video-Offset
 ;HL contains BkPt
 ;Now we are ready...
 ld   b, 16       ;23 lines to draw
PutLoop:
 push bc
 ld   bc, 3
 ldir              ;move 4 bytes from hl to de
 ld   bc, 13
 ex   de, hl
 add  hl, bc
 ex   de, hl
 pop  bc
 djnz PutLoop
 pop  bc
 ret

;-----------------------------------------------------------------------------
;WhiteSprite: draws each white element of a 16*16 sprite
;-----------------------------------------------------------------------------
WhiteSprite:
 push   BC
 push   DE
 ld     A, 32
 ld     (TempByte), A ;Line
 ld     A, 63
 sub    C
 ld     C, A
 call   FIND_PIXEL
 ld     DE, BITMAPMEM
 add    HL, DE
 pop    DE
 ld     C, A
 ld     B, 128
WSLoop:
 ld   a, (de)
 and  b
 jr   nz, WSLoop1
 ld   a, c
 cpl
 and  (hl)
 ld   (hl), a
WSLoop1:
 rrc  c
 jr   nc, WSLoop2
 inc  hl
WSLoop2:
 rrc  b
 jr   nc, WSLoop
WSNextLine:
 inc    DE
 ld     A, (TempByte)
 dec    A
 ld     (TempByte), A
 jr     z, WSEndBMP
 bit    0, A
 jr     nz, WSLoop
 push   DE
 ld     DE, 14
 add    HL, DE
 pop    DE
 jr     WSLoop
WSEndBMP:
 pop  bc
 ret

;-----------------------------------------------------------------------------
;BlackSprite: draws each black element of a 16*16 sprite
;-----------------------------------------------------------------------------
BlackSprite:
 push   BC
 push   DE
 ld     A, 32
 ld     (TempByte), A ;Line
 ld     A, 63
 sub    C
 ld     C, A
 call   FIND_PIXEL
 ld     DE, BITMAPMEM
 add    HL, DE
 pop    DE
 ld     C, A
 ld     B, 128
BSLoop:
 ld     A, (de)
 and    B
 jr     z, BSLoop1
 ld     A, (hl)
 or     C
 ld     (hl), A
BSLoop1:
 rrc    C
 jr     nc, BSLoop2
 inc    hl
BSLoop2:
 rrc    B
 jr     nc, BSLoop
BSNextLine:
 inc    DE
 ld     A, (TempByte)
 dec    A
 ld     (TempByte), A
 jr     z, BSEndBMP
 bit    0, A
 jr     nz, BSLoop
 push   de
 ld     de, 14
 add    hl, de
 pop    de
 jr     BSLoop
BSEndBMP:
 pop  bc
 ret

;-----------------------------------------------------------------------------
;Handle Hi-score
;-----------------------------------------------------------------------------
HiScoreHand:
 call   CLEARLCD
 ld     HL, &HiScore
 call   LD_HL_MHL
 ld     DE, (SCORE)
 ld     (HiScoreTemp), DE
;DE contains hiscore, HL actual score
 call   CP_HL_DE
 ret    nc
 ld     HL, &HiScore
 ex     DE, HL
 ld     HL, HiScoreTemp
 ld     C, 2
 ldi
 ldi
 ld     HL, $0300
 ld     ($800C), HL
 ld     HL, &HiScr
 call   D_ZT_STR
 ld     DE, $0A1F
 ld     ($8333), DE
 call   D_ZM_STR
 ld     HL, $0803
 ld     ($800C), HL
 ld     HL, &HiScrName
 ld     C, 3
 #fncall INP_INIT
 ret

DisplayInfo:
	push    BC
	call    CLEARLCD
	ld      HL, VIDEO_MEM
	call    &Invert
	ld      HL, VIDEO_MEM+1024-112
	call    &Invert
	ld      HL, $0001
	ld      (CURSOR_X), HL
	set     3, (IY+5)
	ld      HL, &Instr
	call    D_ZM_STR
	ld      A, 82
	ld      (CURSOR_X), A
	call    D_ZM_STR
	call    LD_HL_MHL
	call    DM_HL_DECI
	ld      HL, $390D
	ld      (CURSOR_X), HL
	ld      HL, &EMail
	call    D_ZM_STR
	res     3, (IY+5)
	pop     BC
	ret

LoadLevel:
	call    &DisplayInfo
;Search for level files:
	ld      IX, Levels
	xor     A
	ld      (LvlNo), A
	ld      HL, VAT_START-10
SearchLoop:
	ld      A, $0C
	call    SEARCH_VAT
	jr      c, SearchDone
	ld      A, (DE)
	cp      3
	jr      nz, SearchLoop
	inc     DE
	ld      A, (DE)
	and     A
	jr      nz, SearchLoop
	push    HL
	ld      HL, VATName
	push    IX
	pop     DE
	ld      BC, 9
	push    BC
	ldir
	pop     BC
	add     IX, BC
	pop     HL
	ld      A, (LvlNo)
	inc     A
	ld      (LvlNo), A
	jr      SearchLoop
SearchDone:
	xor     A
	ld      (&SetD+1), A

	ld      A, (LvlNo)
	and     A
	jp      z, &NoLevels
ShowLevels:
	ld      HL, $0801
	ld      (CURSOR_X), HL

	ld      HL, VIDEO_MEM+112
	ld      BC, 799
	call    OTH_CLEAR
	ld      HL, (Top)
	ld      H, 9
	call    MUL_HL
	ld      DE, Levels
	add     HL, DE
	ld      B, 8
	ld      A, (LvlNo)
	cp      8
	jr      nc, ShowLevel
	ld      B, A
ShowLevel:
	push    HL
	call    D_ZM_STR
	pop     HL
	ld      DE, 9
	add     HL, DE
	ld      A, (CURSOR_Y)
	add     A, 6
	ld      (CURSOR_Y), A
	ld      A, 1
	ld      (CURSOR_X), A
	djnz    ShowLevel
	ld      HL, Top
	ld      A, (LvlNo)
	sub     (HL)
	cp      8
	jr      c, SetMax
	ld      A, 8
SetMax:
	ld      E, A
	dec     E
SetD:
	ld      D, 0
	call    &ShowBar
CL_KeyLoop:
	call    GET_KEY
	cp      K_DOWN
	jr      z, ScrollDown
	cp      K_UP
	jr      z, ScrollUp
	cp      K_ENTER
	jr      z, AcceptLevel
	cp      K_EXIT
	jr      nz, CL_KeyLoop
	scf
	ret
ScrollDown:
	call    &ShowBar
	ld      A, D
	cp      E
	jr      z, ScrollL_Down
	inc     D
	jr      ShowIt
ScrollL_Down:
	ld      (&SetD+1), A
	ld      A, (LvlNo)
	sub     8
	jr      c, ShowIt
	ld      HL, Top
	cp      (HL)
	jr      z, ShowIt
	inc     (HL)
	jp      &ShowLevels
ScrollUp:
	call    &ShowBar
	ld      A, D
	and     A
	jr      z, ScrollL_Up
	dec     D
	jr      ShowIt
ScrollL_Up:
	ld      (&SetD+1), A
	ld      A, (Top)
	and     A
	jr      z, ShowIt
	dec     A
	ld      (Top), A
	jp      &ShowLevels
ShowIt:
	call    &ShowBar
	jr      CL_KeyLoop
AcceptLevel:
	ld      A, (Top)
	add     A, D
	ld      L, A
	ld      H, 9
	call    MUL_HL
	ld      DE, Levels
	add     HL, DE
	push    HL
	ld      BC, 8
	ld      DE, LEVELNAME
	ldir
	pop     HL
	call    VAR_GET
	ret     c
	inc     HL
	inc     HL
	or      A
	ret
NoLevels:
	ld      HL, $0801
	ld      (CURSOR_X), HL
	ld      HL, &NoLevel
	call    D_ZM_STR
	call    OTH_PAUSE
	scf
	ret

ShowBar:
	push    DE
	ld      L, D
	ld      H, 96
	call    MUL_HL
	ld      DE, VIDEO_MEM+128
	add     HL, DE
	call    &Invert
	pop     DE
	ret

Invert:
	ld      BC, 112
InvLoop:
	ld      A, (HL)
	cpl
	ld      (HL), A
	inc     HL
	dec     BC
	ld      A, B
	or      C
	jr      nz, InvLoop
	ret

;-------------------------------------------------------------------------------
;Some important variables:
;-------------------------------------------------------------------------------
		    ;012345678901234567890
NoLevel:   .db "No level found!",0
Instr:     .db "PJ 1.1 by AE",0
HiScrTxt:  .db "Hi: "
HiScrName: .db "AND",0
HiScore:   .dw 10                       ;This is standard hi-score
HiScr:     .db "NEW HIGH SCORE!",0
EnterInit: .db "ENTER YOUR INITIALS:",0
	       ;123456789012345678901
EMail:     .db "ess.andreas@computerhaus.at",0
ByStr:     .db "by Andreas Ess",0
TitTxt:    .db "Title picture by"
	   .db " Johannes Rajala",0
LifeStatus: .db "Lifes left:",0

;-------------------------------------------------------------------------------
;This contains savegame
;-------------------------------------------------------------------------------
LevelSaved: .db 0  ;standard: no level saved
SavedLevel:
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;-------------------------------------------------------------------------------
;This array contains start&end-line indexes(?)
;-------------------------------------------------------------------------------
StartLine:
 .db  16, 12, 8, 4              ;#0
 .db  17, 13, 8, 4
 .db  17, 13, 9, 4
 .db  18, 13, 9, 4
 .db  19, 14, 10, 5             ;#4
 .db  19, 15, 10, 5
 .db  20, 15, 10, 5
 .db  21, 16, 11, 5
 .db  22, 17, 11, 6             ;#8
 .db  23, 17, 11, 6
 .db  23, 18, 12, 6
 .db  24, 18, 12, 6
 .db  25, 19, 13, 6             ;#12
 .db  26, 19, 13, 6
 .db  26, 20, 13, 7
 .db  27, 21, 14, 7
 .db  28, 21, 14, 7             ;#16
 .db  29, 22, 14, 7
 .db  29, 22, 15, 7
 .db  30, 23, 15, 8
 .db  31, 23, 16, 8             ;#20
 .db  32, 24, 16, 8
 .db  33, 25, 16, 8
 .db  33, 25, 17, 8
 .db  34, 26, 17, 9             ;#24
 .db  35, 26, 18, 9
 .db  35, 27, 18, 9
 .db  36, 27, 18, 9
 .db  37, 28, 19, 9             ;#28
 .db  38, 29, 19, 9
 .db  38, 29, 19, 9
 .db  39, 30, 20, 10
 .db  40, 30, 20, 10            ;#32
 .db  41, 31, 21, 10
 .db  41, 31, 21, 10
 .db  42, 32, 21, 11
 .db  43, 33, 22, 11            ;#36
 .db  44, 33, 22, 11
 .db  44, 34, 22, 11
 .db  45, 34, 23, 11
 .db  46, 35, 23, 12            ;#40
 .db  47, 35, 24, 12
 .db  47, 36, 24, 12
 .db  48, 37, 24, 12
 .db  49, 37, 25, 12            ;#44
 .db  50, 38, 25, 13
 .db  50, 38, 26, 13
 .db  51, 39, 26, 13
 .db  52, 39, 26, 13            ;#48
 .db  53, 40, 27, 13
 .db  54, 41, 27, 14
 .db  55, 41, 27, 14
 .db  55, 42, 28, 14            ;#52
 .db  56, 42, 28, 14
 .db  56, 43, 29, 14
 .db  57, 43, 29, 14
 .db  58, 44, 29, 15            ;#56
 .db  59, 45, 30, 15
 .db  59, 45, 30, 15
 .db  60, 46, 30, 15
 .db  61, 46, 31, 15            ;#60
 .db  62, 47, 31, 16
 .db  62, 47, 32, 16
 .db  63, 48, 32, 16


;-------------------------------------------------------------------------------
;Bitmapdata:
;-------------------------------------------------------------------------------
WhiteBall:
 .db $FF,$FF,$FF,$FF,$F8,$3F,$E0,$0F,$C0,$07,$C0,$07,$80,$03,$80,$03
 .db $80,$03,$80,$03,$80,$03,$C0,$07,$C0,$07,$E0,$0F,$F8,$3F,$FF,$FF,

BlackBall1:
 .db $00,$00,$07,$C0,$18,$30,$20,$08,$40,$04,$40,$04,$80,$02,$80,$02
 .db $80,$02,$C0,$06,$A0,$0A,$54,$54,$6A,$AC,$35,$58,$1A,$B0,$07,$C0

 .db $00,$00,$07,$C0,$18,$30,$20,$08,$40,$04,$40,$04,$8A,$A2,$D5,$56
 .db $AA,$AA,$D5,$56,$8A,$A2,$40,$04,$40,$04,$20,$08,$18,$30,$07,$C0

 .db $00,$00,$07,$C0,$1A,$B0,$35,$58,$6A,$AC,$54,$54,$A0,$0A,$C0,$06
 .db $80,$02,$80,$02,$80,$02,$40,$04,$40,$04,$20,$08,$18,$30,$07,$C0


TitlePicture:
 .db $00,$3F,$2C,$C0,$3F,$3F,$22,$C0,$0A,$C0,$3F,$A0,$3F,$2C,$C0,$80
 .db $E0,$22,$C0,$90,$84,$37,$E0,$FF,$39,$C0,$34,$4D,$19,$C0,$82,$81
 .db $0A,$E0,$1B,$E3,$80,$C0,$83,$F0,$98,$88,$10,$C0,$98,$98,$84,$BE
 .db $12,$C0,$BE,$FC,$10,$E2,$87,$B0,$12,$E0,$BC,$F0,$83,$E6,$18,$F6
 .db $EF,$82,$09,$E9,$E3,$C0,$13,$FB,$48,$0B,$E1,$E0,$09,$C0,$B9,$F0
 .db $F0,$A4,$8D,$9F,$98,$18,$FE,$8F,$0B,$E9,$FC,$C0,$09,$F0,$F0,$98
 .db $BC,$ED,$9F,$CC,$19,$F0,$8E,$84,$8D,$DC,$0B,$C0,$F0,$B0,$DC,$8F
 .db $BE,$9F,$E7,$1A,$E0,$87,$91,$EE,$B0,$0A,$E0,$F0,$88,$EC,$87,$FF
 .db $8F,$F3,$C0,$14,$E3,$E3,$E3,$4A,$83,$C1,$C1,$E8,$C5,$DC,$86,$F7
 .db $8F,$F3,$F0,$13,$E3,$F9,$F1,$DF,$F0,$FF,$9C,$87,$B1,$E1,$CC,$F7
 .db $B8,$BE,$B9,$C0,$10,$E3,$F9,$E3,$8F,$F9,$C3,$F8,$83,$CF,$D9,$DE
 .db $E3,$B9,$80,$F0,$90,$10,$E3,$F9,$C3,$8F,$CF,$80,$F8,$81,$FD,$CF
 .db $FB,$E2,$98,$E3,$E0,$17,$E1,$F3,$C3,$8F,$8F,$09,$F0,$87,$E6,$BF
 .db $CF,$08,$C7,$FC,$1B,$E0,$87,$C7,$8F,$8F,$C0,$8E,$83,$F9,$CF,$E1
 .db $C0,$88,$BE,$1F,$E8,$BF,$DC,$8E,$9F,$90,$8C,$87,$F3,$9F,$E1,$09
 .db $CB,$23,$E7,$4C,$83,$C7,$EE,$83,$C3,$9C,$E7,$F8,$A0,$84,$8C,$20
 .db $E3,$4C,$93,$C7,$E7,$C1,$C6,$8C,$E3,$F8,$A0,$82,$AC,$1F,$F0,$FF
 .db $BC,$F3,$8F,$CF,$E3,$D8,$98,$E3,$F2,$D0,$C4,$D8,$1D,$FC,$BF,$8E
 .db $B9,$C7,$E7,$F1,$F8,$8D,$B0,$B0,$A6,$C0,$B7,$1D,$E6,$8F,$CF,$9C
 .db $EB,$F3,$F8,$FE,$9E,$CC,$80,$D1,$E8,$8B,$F0,$16,$C3,$A3,$E7,$08
 .db $E3,$E3,$F8,$4C,$8B,$08,$C8,$FA,$A6,$EC,$15,$C0,$B4,$B1,$E1,$C5
 .db $BD,$BF,$9F,$FF,$8D,$C8,$B6,$9E,$F1,$D8,$A0,$18,$EC,$A3,$C0,$CA
 .db $F0,$FC,$B8,$F8,$B7,$CF,$C8,$BD,$D3,$B8,$1E,$F6,$97,$87,$8C,$F2
 .db $FC,$BA,$0A,$FE,$B9,$C7,$B3,$B9,$C0,$1A,$FA,$93,$F3,$E2,$B3,$BC
 .db $9B,$80,$FE,$BC,$9E,$B1,$F8,$BC,$1E,$FC,$E4,$8B,$E3,$F4,$F9,$89
 .db $C7,$F8,$9F,$F7,$F0,$EF,$F8,$1D,$E6,$F9,$E9,$F1,$FD,$FD,$09,$49
 .db $83,$FE,$9F,$80,$FC,$20,$E3,$FF,$88,$FC,$BF,$EE,$E0,$49,$B0,$B1
 .db $E0,$E0,$86,$22,$C1,$F3,$4A,$B1,$EC,$99,$D7,$F8,$98,$C0,$E0,$E0
 .db $84,$29,$E0,$49,$9F,$E0,$8E,$87,$E0,$84,$09,$C0,$C0,$98,$31,$FF
 .db $8F,$C0,$9F,$FF,$18,$C1,$08,$C0,$32,$F0,$0D,$4A,$0E,$C0,$14,$C0
 .db $33,$E0,$0B,$E1,$E0,$19,$C4,$3F,$98,$0A,$C0,$90,$27,$C0,$36,$C0
 .db $10,$C0,$3F,$88,$00


.end
