#ifndef GUI_H
#define GUI_H

#include "common.h"
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h> 

void gui_init(void);
void gui_close(void);

void draw_dashboard(const char* input, const char* result, bool is_solved, int num_vars, int cursor_idx);

void draw_status(const char* msg, uint8_t color);

void show_kmap_window(TruthTable* table);
void show_truthtable_window(TruthTable* table);

void export_to_y1(const char* expr);

#endif