#ifndef COMMON_H
#define COMMON_H

#include <stdint.h>
#include <stdbool.h>

#define MAX_VARS 10
#define MAX_EXPR_LEN 512
#define TABLE_SIZE 1024

typedef struct {
    int num_vars;                
    char used_var_names[MAX_VARS]; 
    int used_var_indices[MAX_VARS];
    int used_vars_count;            

    bool output[TABLE_SIZE];     
    char rpn_expr[MAX_EXPR_LEN]; 
} TruthTable;

void parse_expression(const char* input, TruthTable* table);
bool simplify_expression(TruthTable* table, char* output_buffer);

#endif