;*** usrspcsp.h

; We must take care that in the case that the destination = HL, we don't overwrite it wit the previous value.

; Stack layout:
; || is where we we are now:

; | tempHL | Destination | Current (.orged @ $4000) | PC || tempDE | <empty>

; At the end, we want to have it this way:

; | garbage | output | RET-address | <garbage>

;** ldcode_rst
;* Used for the LDCODE macro, should never be called manually.

ldcode_rst:
    PUSH DE         ; @empty
    DI
    INC SP
    INC SP          ; @tempDE
    INC SP
    INC SP          ; @PC
    POP DE          ; @current
    POP HL          ; @destination
    SCF
    CCF
    SBC HL, DE
    DEC SP
    DEC SP          ; @current
    DEC SP
    DEC SP          ; @PC
    DEC SP
    DEC SP          ; @tempHL
    POP DE          ; @PC
    ADD HL, DE
    INC SP
    INC SP          ; @current
    INC SP
    INC SP          ; @destination = output
    PUSH HL         ; @current = RET-address
    INC SP
    INC SP          ; @output
    POP HL          ; @garbage, (HL = restored)
    DEC SP
    DEC SP          ; @output
    DEC SP
    DEC SP          ; @RET-address
    PUSH DE         ; @PC       (stack restore, DE = PC)
    PUSH DE         ; @tempDE   (garbage PUSH)
    DEC SP
    DEC SP          ; @empty
    POP DE          ; @tempDE
    INC SP
    INC SP          ; @PC = <garbage>
    RET
