#include "baos_z80asm.inc"

    ;CALL clrscrn  ; Just a message
    LDPTR HL name
    CALL printstr

    LD HL, 128    ; malloc memory for the command
    CALL malloc
    PUSH HL
    LD A, H
    OR L
    JP Z, nomem
    POP HL

loop:
    PUSH HL       ; Save our memory pointer
    LDPTR HL cmdstr
    CALL printstr
    POP HL
    PUSH HL
    LD BC, 127
    CALL gets     ; Get a command
    POP HL
    PUSH HL
    CALL spc2null
    POP HL
    PUSH HL
    CALL addbin
    POP HL
    PUSH HL
    CALL execfile
    LD A, $FF
    CP H
    JR Z, error
    ;CALL clrscrn   ; Yeah, nice, wiping out other program's output...
    POP HL
    JR loop

error:
    LD A, L
    CP $FE
    JR Z, nofile
    CP $FD
    JR Z, noexecfile
    LDPTR HL errormsg
    CALL printstr
    POP HL
    JP loop

nofile:
    LDPTR HL nofilemsg
    CALL printstr
    POP HL
    JP loop

noexecfile:
    LDPTR HL noexecfilemsg
    CALL printstr
    POP HL
    JP loop


spc2null:         ; If there is a space (or an enter), make a zero of it (arguments are not yet implemented)
    LD B, 127
    LD C, 0
spc2null_loop:
    LD A, (HL)
    CP 0
    RET Z
    CP '/'
    JR Z, spc2null_slash
    CP ' '
    JR Z, spc2null_change
    CP '\n'
    JR Z, spc2null_change
spc2null_cont:
    INC HL
    DJNZ spc2null_loop
    RET
spc2null_change:
    XOR A
    LD (HL), A
    RET

spc2null_slash:
    INC C
    JR spc2null_cont

addbin:
    XOR A
    OR C
    RET NZ
    LD A, B
    CP 115
    RET C
    PUSH HL
    LDPTR DE bin_append
    EX DE, HL
    CALL strcpy
    POP HL
    LDPTR DE bin_path
    CALL strcpy
    RET

nomem:
    POP HL
    RET

pgm_data:

name:
.db "\nBaos shell v0.1\n", 0

nofilemsg:
.db "File not found!\n", 0

noexecfilemsg:
.db "No executable!\n", 0

errormsg:
.db "Execution error!", 0 ; 16 chars: no return needed.

cmdstr:
.db "$ ", 0

bin_path:
.db "/bin/"

bin_append:
.db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0

pgm_end: