#include "baos_z80asm.inc"

start:	; Program to list the process table.
	; Use B as start entry

; Just to be sure no errors occur if no argument is given.
    LD A, MAX_PROCS - 1
    CP B
    JR NC, ps_noerror
    LD B, 0
ps_noerror:
    LD HL, (proctab)
    LD DE, PROC_TAB_ENTRY
    PUSH BC
    XOR A
    OR B
    JR Z, ps_go
ps_incloop:
    ADD HL, DE
    DJNZ ps_incloop
ps_go:
    PUSH HL
    POP IX
ps_loop:
    LD A, (IX+0)
    OR A
    JP Z, ps_empty
    PUSH AF
    CALL clrscrn
    LDPTR HL ps_text0
    CALL printstr
    PUSH IX
    POP HL
    INC HL
    INC HL
    INC HL
    INC HL
    CALL printstr
    CALL newline
    LDPTR HL ps_text1
    CALL printstr
    POP AF
    POP BC
    PUSH BC
    PUSH AF
    LD L, B
    LD H, 0
    CALL printhl
    LDPTR HL ps_text2
    CALL printstr
    POP AF
    PUSH AF
    LD H, 0
    LD L, A
    CALL printhl
    LDPTR HL ps_text3
    CALL printstr
    LD L, (IX+1)
    LD H, 0
    CALL printhl
    LDPTR HL ps_text4
    CALL printstr
    LD L, (IX+2)
    LD H, (IX+3)
    PUSH HL
    CALL printhlhex
    POP HL
    POP BC
    PUSH HL
    LD A, (curproc)
    CP B
    JP Z, ps_ourproc	; Jump away if we found ourself.
    LDPTR HL ps_text5
    CALL printstr
    POP IY
    LD L, (IY+16)
    LD H, (IY+17)
    CALL printhlhex
    LDPTR HL ps_text6
    CALL printstr
    LD L, (IY+1)
    LD H, 0
    CALL printhl
    LDPTR HL ps_text7
    CALL printstr
    LD H, 0
    LD L, (IY+3)
    CALL printhlhex


ps_next:
    LD A, 70
    PUSH AF
ps_next_loop:
    CALL inkey
    CP ASCLeft
    JR Z, ps_prevproc
    CP ASCRight
    JR Z, ps_nextproc
    CP ASCMode
    JR Z, ps_exit
    LD B, 2	; sleep ~ 1 sec.
    CALL sleep
    POP AF
    DEC A
    PUSH AF
    JR NZ, ps_next_loop
    POP AF
    JP ps_loop

ps_empty:
    CALL clrscrn
    LDPTR HL ps_text_empty
    CALL printstr
    LDPTR HL ps_text1
    CALL printstr
    POP BC
    PUSH BC
    LD H, 0
    LD L, B
    CALL printhl
    JP ps_next

ps_prevproc:
    CALL waitnokey
    POP AF
    POP BC
    DEC B
    LD A, $ff
    CP B
    JP NZ, start
    LD B, MAX_PROCS - 1
    JP start

ps_nextproc:
    CALL waitnokey
    POP AF
    POP BC
    INC B
    JP start

ps_ourproc:
    POP HL
    LDPTR HL ps_text_ourproc
    CALL printstr
    JR ps_next

ps_exit:
    POP HL
    POP HL
    CALL clrscrn
    LD HL, $0000
    RET

pgm_data:

ps_text0:
.db   "   ", 0
ps_text1:
.db "ENTRY:     ", 0
ps_text2:
.db "PID:       ", 0
ps_text3:
.db "STATE:     ", 0
ps_text4:
.db "STACKPTR:  ", 0
ps_text5:
.db "PRGM CNTR: ", 0
ps_text6:
.db "5CREEN NR: ", 0
ps_text7:
.db "FLASH PGE: ", 0
ps_text_empty:
.db " **** EMPTY ****", 0
ps_text_ourproc:
.db "\n\n* THIS PROCESS *",0


pgm_end:
