#include "baos_z80asm.inc"

; mkdir.asm, for directory creation...

    ; First alloc. memory for directory name...
    LD HL, 128
    CALL malloc
    LD A, H
    OR L
    JR Z, nomem
    PUSH HL
    LDPTR HL cdmsg
    CALL printstr
    POP HL
    PUSH HL
    LD BC, 127
    CALL gets
    POP HL
    PUSH HL
    CALL removebackn
    POP HL
    PUSH HL
    LD A, (HL)
    CP 0
    JR Z, exists
    CALL findfile
    LD A, $FF
    CP H
    JR NZ, exists
    CP L
    JR NZ, nopath
    POP HL
    PUSH HL
    CALL getfile
    PUSH DE
    POP HL
    LD D, B    ; Using B of findfile (findsym) (=directory)
    CALL mkdir
    POP HL
    JP free

exists:
    POP HL
    CALL free
    LDPTR HL existsmsg
    JP printstr

nomem:
    LDPTR HL nomemmsg
    JP printstr

nopath:
    POP HL
    CALL free
    LDPTR HL nopathmsg
    JP printstr

getfile:
    PUSH HL
    POP DE
getfile_loop:
    XOR A
    OR (HL)
    RET Z
    CP '/'
    JR NZ, getfile_incloop
    PUSH HL
    POP DE
    INC DE
getfile_incloop:
    INC HL
    JR getfile_loop

pgm_data:

nomemmsg:
.db "Out of memory!\n", 0

cdmsg:
.db "Create dir:\n> ",0

existsmsg:
.db "File Exist !\n",0

nopathmsg:
.db "Invalid path !\n", 0

pgm_end: