#include "baos_z80asm.inc"

; This program will be started by the kernel.

; It requires the file /inittab to work.

    LDPTR HL initmes
    CALL printstr

    ;LDPTR HL config
    LD DE, 0
    LDPTR HL filename
    CALL load
    ;NOP
    LD A, H
    CP $FF
    JR NZ, continue
    LD A, L
    CP $FF
    JR Z, error
    CP $FE
    JR Z, error
    CP $FD
    JR Z, error
continue:
    PUSH HL
    PUSH HL
loop:
    POP HL
    LD A, (HL)
    CP 'E'
    JP Z, loop_end
    SUB '0'
    PUSH AF
    INC HL
    LD A, (HL)
    SUB '0'
    LD C, A
    LD A, (mydir)
    LD B, A
    INC HL
    POP AF
    POP DE
    PUSH DE
    PUSH AF
    CALL trim
    INC HL
    POP AF
    POP DE
    PUSH DE
    PUSH HL
    LD H, D
    LD L, E
    OR A
    JR Z, init_execfile
    CP 1
    JR Z, init_startfile
    CALL startfileex
    JP loop

init_execfile:
    CALL execfile
    JP loop

init_startfile:
    CALL startfile
    JP loop

loop_end:
    POP HL
    CALL free
    RET

trim:

trim_loop:
    LD A, (HL)
    CP '\n'
    JR Z, trim_end
    LD (DE), A
    INC HL
    INC DE
    JP trim_loop
trim_end:
    LD A, 0
    LD (DE), A
    RET

error:
    CALL clrscrn
    LDPTR HL errormsg
    CALL printstr
    CALL halt

pgm_data:

; Init configuration.
; Using ascii.

; Layout:    < wait = 0 / continue = 1 / continue with startpgmex = 2 / end-of-config = E > : <screen> : <command>

;config:
;.db '0', '0', "/bin/firstrun", '\n'
;config:
;.db '2', '1', "/bin/sh", '\n'
;.db '2', '2', "/bin/sh", '\n'
;.db '2', '3', "/bin/sh", '\n'
;.db '2', '4', "/bin/sh", '\n'
;.db 'E'

errormsg:
.db " **** ERROR ****"
.db "\n"
.db "ERROR OPENING\n"
.db "INIT CONFIG FILE"
.db "\n"
.db "System halted...", 0

initmes:
.db "INIT: booting up", 0 ; 16 chars: no return.

filename:
.db "/inittab", 0

pgm_end:
