; IIC.asm, a private program I needed at a certain time ;-)

#include "baos_z80asm.inc"

sendstatebyte: .equ $01
sendnamebyte:  .equ $10

main:
    CALL clrscrn
    CALL printnames
    CALL printstates
    JP waitforkey

printnames:
    LD DE, $0000
    CALL scrnsetloc
    LDPTR HL name_1
    CALL printstr
    CALL newline
    LDPTR HL name_2
    CALL printstr
    CALL newline
    LDPTR HL name_3
    CALL printstr
    CALL newline
    LDPTR HL name_4
    CALL printstr
    CALL newline
    LDPTR HL name_5
    CALL printstr
    CALL newline
    LDPTR HL name_6
    CALL printstr
    CALL newline
    LDPTR HL name_7
    CALL printstr
    CALL newline
    LDPTR HL name_8
    CALL printstr
    RET

printstates:
    LD DE, $080a
    CALL scrnsetloc
    LD A, (state)
    LD H, 0
    LD L, A
    JP printhlhex

waitforkey:
    LD B, 4
    CALL sleep
    CALL inkey
    CP '\n'
    JP Z, sendstate
    CP AscUP
    Jr Z, upstate
    CP AscDown
    Jr Z, downstate
    CP Ascmode
    RET Z
    CP '1'
    JR Z, setname
    CP '2'
    JR Z, setname
    CP '3'
    JR Z, setname
    CP '4'
    JR Z, setname
    CP '5'
    JR Z, setname
    CP '6'
    JR Z, setname
    CP '7'
    JR Z, setname
    CP '8'
    JR Z, setname
    JP waitforkey

upstate:
    Ld A, (state)
    INC A
    LD (state), A
    JP main

downstate:
    Ld A, (state)
    DEC A
    LD (state), A
    JP main

setname:
    LD B, '0'
    SUB B
    PUSH AF
    CALL clrscrn
    LDPTR HL enternamemsg
    CALL printstr
    LDPTR HL name_1
    LD DE, 9
    POP BC
    DEC B
    PUSH BC
    JR Z, setname_cont
setname_loop:
    ADD HL, DE
    DJNZ setname_loop
setname_cont:
    PUSH HL
    LD BC, 8
    CALL gets
    POP HL
    PUSH HL
    CALL removebackn
    POP HL
    POP BC
    LD A, sendnamebyte
    ADD A, B
    PUSH HL
    CALL sendbyte
    POP HL
    CALL sendstring
    JP main

sendstate:
    LD A, sendstatebyte
    CALL sendbyte
    LD A, (state)
    CALL sendbyte
    JP main

sendstring:
    LD A, (HL)
    PUSH HL
    CALL sendbyte
    POP HL
    LD A, (HL)
    INC HL
    OR A
    JP NZ, sendstring
    RET

sendbyte:
    LD B, 8
sendbyte_loop:
    PUSH BC
    PUSH AF
    CALL sendbit
    POP AF
    SRL A
    POP BC
    DJNZ sendbyte_loop
    RET

sendbit:
    AND %00000001
    OR %00000010
    XOR %00000011
    OUT (0), A
    PUSH AF
    LD B, 14
    CALL sleep
    POP AF
    OR %00000010
    OUT (0), A
    LD B, 14
    RET sleep

pgm_data:

name_1:
.db "R1",0,0,0,0,0,0,0

name_2:
.db "R2",0,0,0,0,0,0,0

name_3:
.db "R3",0,0,0,0,0,0,0

name_4:
.db "R4",0,0,0,0,0,0,0

name_5:
.db "R5",0,0,0,0,0,0,0

name_6:
.db "R6",0,0,0,0,0,0,0

name_7:
.db "R7",0,0,0,0,0,0,0

name_8:
.db "R8",0,0,0,0,0,0,0

enternamemsg:
.db "Enter new name:\n\n> ", 0

state:
.db 0

pgm_end: