#include "baos_z80asm.inc"

;; fsmap.asm (c) 2007, Erik van 't Wout
;; Released under the terms of the GNU GPL v2


    CALL getmem
firstpage:
    LD A, 4

mainloop:
    LD (page), A
    CALL dispage
mainloop_getkey:
    CALL getkey
    CP 'd'
    JP Z, countdead
    CP AscMode
    JP Z, exit_fsmap
    CP AscLeft
    JP Z, DecPage
    CP AscRight
    JP Z, IncPage
    CP AscBackspc
    JP Z, docleansec
    CP AscDel
    JP Z, killpage
    JP mainloop_getkey

docleansec:
    LD A, (page)
    SRL A
    SRL A
    CALL cleansec
    LD A, (page)
    JP mainloop

IncPage:
    LD A, (page)
    INC A
    CP Flash_last_page + 1
    JR Z, IncPage_sw1
    CP Flash_swap + 4
    JR Z, IncPage_p1
Page_ret:
    LD (page), A
    JP mainloop
incpage_sw1:
    LD A, Flash_swap
    JP page_ret
incpage_p1:
    LD A, 4
    JP page_ret

DecPage:
    LD A, (page)
    DEC A
    CP 3
    JR Z, DecPage_swplast
    CP Flash_swap - 1
    JR Z, DecPage_lastpage
    LD (page), A
    JP mainloop
DecPage_lastpage:
    LD A, Flash_last_page
    JP page_ret
DecPage_swplast:
    LD A, Flash_swap + 3
    JP page_ret

getmem:
    LD HL, 256
    CALL malloc
    XOR A
    OR H
    JP Z, nomem
    LD (buffer), HL
    RET

dispage:  ; Display a single page.
    CALL clrscrn
    CALL getpagedata
    CALL modbuffer
    LD B, 128
    LD HL, (buffer)
dispage_loop:
    PUSH BC
    PUSH HL
    LD A, (HL)
    CALL printc
    POP HL
    INC HL
    POP BC
    DJNZ dispage_loop
    LDPTR HL pagemes
    LD A, (page)
    CP 24
    CALL NC, dispage_swap
    PUSH AF
    CALL printstr
    POP AF
    LD L, A
    LD H, 0
    CALL printhl
    RET

dispage_swap:
    SUB 23
    LDPTR HL swapmes
    RET

modbuffer:
    LD IX, (buffer)
    LD HL, (buffer)
    LD B, 128
modbuffer_loop:
    LD A, (IX+0)
    LD D, (IX+1)
    CP D
    PUSH HL
    PUSH BC
    CALL NZ, compA
    CALL Atochar
    POP BC
    POP HL
    LD (HL), A
    INC HL
    INC IX
    INC IX
    DJNZ modbuffer_loop
    RET

compA:
    CP 1
    JR Z, compA1
    CP 2
    JR Z, compA2
    LD A, D
    CP 1
    JR Z, compA13
    LD A, (fulldead)
    RET

compA13:
    LD A, (freedead)
    RET

compA1:
    LD A, D
    CP 2
    JR NZ, compA13
compA12:
    LD A, (freefull)
    RET

compA2:
    LD A, D
    CP 1
    JR Z, compA12
    LD A, (fulldead)
    RET

getpagedata:
    LD A, (page)
    OUT (6), A
    LD HL, $4000
    PUSH HL
    POP IX
    LD BC, (buffer)
getpagedata_loop:
    LD A, (IX+0)
    OR A
    JR Z, getpagedata_dead
    LD A, (IX+1)
    CP $FF
    JR NZ, getpagedata_full
    PUSH IX
    POP HL
    LD DE, 64
    ADD HL, DE
    PUSH HL
    POP IX
    LD A, 1
    LD (BC), A
    INC BC
    LD A, H
getpagedata_ret:
    CP $80
    RET Z
    JR getpagedata_loop

getpagedata_dead:
    LD A, 3
    JR getpagedata_multiple

getpagedata_full:
    LD A, 2

getpagedata_multiple:
    LD (curbt), A
    LD A, (IX+1)
    CPL
    LD DE, 64
    PUSH IX
    POP HL
getpagedata_loop2:
    ADD HL, DE
    PUSH AF
    LD A, (curbt)
    LD (BC), A
    INC BC
    POP AF
    DEC A
    JR NZ, getpagedata_loop2
    PUSH HL
    POP IX
    LD A, H
    JR getpagedata_ret

Atochar:
    CP 4
    RET NC
    DEC A
    LD E, A
    LD D, 0
    LDPTR HL empty
    ADD HL, DE
    LD A, (HL)
    RET

nomem:
    POP HL
    RET

killpage:
    LD A, (page)
    LD H, A
    LD L, 0
killpage_loop:
    PUSH HL
    CALL killblk
    POP HL
    INC HL
    XOR A
    OR L
    JR NZ, killpage_loop
    LD A, (page)
    JP mainloop

countdead:
    LD A, (page)
    SRL A
    SRL A
    CALL countdeadblks
    PUSH HL
    CALL clrscrn
    LDPTR HL cdmes1
    CALL printstr
    POP HL
    CALL printhl
    LDPTR HL cdmes2
    CALL printstr
    CALL getc
    LD A, (page)
    JP mainloop


exit_fsmap:
    CALL clrscrn
    RET

pgm_data:

curbt:
.db 0

empty:
.db '.'

full:
.db '#'

dead:
.db 'D'

freefull:
.db '*'

freedead:
.db '-'

fulldead:
.db '/'

buffer:
.dw 0

page:
.db 0

swapmes:
.db "SWAP"
pagemes:
.db "PAGE: ", 0

cdmes1:
.db "Number of\n"
.db "dead blocks:\n",0

cdmes2:
.db "\n\nPress any key.\n", 0

pgm_end: