#include "baos_z80asm.inc"
#include "debug.inc"

start:
    LDPTR HL formatstr
    CALL printstr
    LD B, 1
    CALL ClrSec
    LD B, 2
    CALL ClrSec
    LD B, 3
    CALL ClrSec
    LD B, 4
    CALL ClrSec

    LD B, Flash_swapsec
    CALL ClrSec
    ;CALL clearswap   ; Check is not 100% (in fact only 1%)

    ; First create ./ and ../ on the filesystem (both as a loopback)
    LD HL, 16+1
    CALL malloc
    LD A, H
    OR L
    JR NZ, start_continue
critical_error:
    DI
    JP halt

start_continue:
    PUSH HL
    POP IY
    LD (IY+0), $FF    ; We're alive
    LD (IY+1), $FE    ; One block in use
    LD (IY+2), 0      ; Root directory
    LD (IY+3), $0d    ; Directory-flag + size = 13
    LD (IY+4), '.'
    LD (IY+5), '.'
    LD (IY+6), 0
    LD (IY+16), 0
    LD A, 4
    OUT (0), A
    LD DE, $0400
    CALL writeblk
    LD A, H
    AND L
    CP $FF
    JR Z, critical_error
    LD (IY+5), 0
    LD DE, $0401
    PUSH IY
    POP HL
    CALL writeblk
    LD A, H
    AND L
    CP $FF
    JR Z, critical_error

    ; Then create the /bin directory.
    LDPTR HL bindirname
    LD D, 0
    CALL mkdir

    ; Copy binaries to the filesystem
    LD IX, userspc_index

    ; Work-around for a bug in Wabbit-emu.
    CALL nextproc

loadpgmloop:
    LD A, (IX+0)
    OR (IX+1)
    JP Z, continue
    LD H, (IX+1)
    LD L, (IX+0)
    LD E, (HL)
    INC HL
    LD D, (HL)
    INC HL
    EX DE, HL
    PUSH IX
    CALL pgmtofs
    POP IX
    INC IX
    INC IX
    JP loadpgmloop

continue:
    RET ; Not ready yet, just an animation.

    LD A, 5
    LD (curscrn), A
loop1:
    CALL nextproc
    CALL become_screen_master
    XOR A
    OR L
    JR NZ, loop1

    CALL cls  ; Clear screen by hardware
    LD DE, $0000
    CALL scrngetramloc ; Get the memory address of the buffer.
    LD (buffer), HL
    LD HL, 768
    CALL malloc
    LD A, H
    OR L
    RET Z
    LD (bufout), HL

    LD H, 10
    LD L, 10
    LD D, 20
    LD E, 20
    CALL rect
    CALL syncscrn

    CALL clearmem
    LD B, 140
    CALL sleep
    LD B, 140
    CALL sleep
    LD B, 140
    CALL sleep

    CALL cls
    CALL share_screen
    CALL release_screen
    LD HL, (bufout)
    CALL free
    LD A, 1
    LD (curscrn), A
    CALL scrnrefresh
    RET


clearmem:
    LD BC, 0
    LD DE, (buffer)
clearmem_loop:
    XOR A
    LD (DE), A
    LD (HL), A
    INC BC
    LD A, B
    CP 3
    JR NZ, clearmem_loop
    RET

syncscrn:
    CALL quickwaitforLCD
    LD A, $01
    OUT ($10), A
    LD HL, (buffer)
    LD DE, (bufout)
    LD BC, 0

syncscrn_loop:
    PUSH BC
    LD C, (HL)
    LD A, (DE)
    CP C
    JR Z, syncscrn_next
    POP BC
    PUSH BC
    PUSH DE
    PUSH HL

    ; BC is the current location in bytes.
    ; Since we have 64 rows, the layout is:

    ; | 000000CC | CCRRRRRR |

    LD A, C
    SLA C
    RL B
    SLA C
    RL B
    LD C, %00111111
    AND C
    LD C, A

    ; Now C is the row and B is the column.

    LD A, $20
    ADD A, B
    CALL waitforLCD
    OUT ($10), A

    LD A, $80
    ADD A, C
    CALL waitforLCD
    OUT ($10), A

    ; Let's write:

    POP HL
    POP DE

    LD A, (HL)
    LD (DE), A
    CALL waitforLCD
    OUT ($11), A

syncscrn_next:
    INC HL
    INC DE
    POP BC
    INC BC
    LD A, B
    CP 3
    JR NZ, syncscrn_loop
    ;NOP
    RET


line:
    LD A, H
    CP D
    JR Z, line_vert
    LD A, L
    CP E
    JR Z, line_hori
    RET

pixel:
    LD B, 0
    SRL H
    RR B
    SRL H
    RR B
    SRL H
    RR B

    SRL B
    SRL B
    SRL B
    SRL B
    SRL B     ; B contains the bit that needs to be set.

    LD A, L
    SRL H
    RR L
    SRL H
    RR L
    OR L
    LD L, A   ; HL is now the right location.

    LD A, $80
    INC B
    JR pixel_test

pixel_loop:
    RR A
pixel_test:
    DJNZ pixel_loop

    ;NOP
    LD DE, (buffer)
    ADD HL, DE
    OR (HL)
    LD (HL), A
    RET

line_vert:
    LD A, L
    CP E
    JR Z, pixel
    JR C, line_vert_loop
    PUSH HL
    LD L, E
    POP DE
line_vert_loop:
    PUSH DE
    PUSH HL
    CALL pixel
    POP HL
    POP DE
    INC L
    LD A, L
    CP E
    RET Z
    JR line_vert_loop

line_hori:
    LD A, H
    CP D
    JR C, line_hori_loop
    PUSH HL
    LD H, D
    POP DE
line_hori_loop:
    PUSH DE
    PUSH HL
    CALL pixel
    POP HL
    POP DE
    INC H
    LD A, H
    CP D
    RET Z
    JR line_hori_loop

rect:   ; Draws a rectangle
    PUSH HL
    PUSH DE
    LD H, D
    CALL line
    POP DE
    POP HL
    PUSH HL
    PUSH DE
    LD L, E
    CALL line
    POP DE
    POP HL
    PUSH HL
    PUSH DE
    LD D, H
    CALL line
    POP DE
    POP HL
    LD E, L
    JP line

pgmtofs:    ; HL = _name (= _end)
            ; DE = _start

    PUSH HL
    PUSH DE
    SCF
    CCF
    SBC HL, DE  ; HL = length
    LD B, H
    LD C, L     ; BC = lentgh
    EX DE, HL   ; DE = lentgh
    POP HL      ; HL = start
    PUSH BC     ; Stack: [ _name ] [ length ]
    CALL copytoram
    ;NOP
    LD A, H
    AND L
    CP $FF
    JR Z, pgmtofs_fail  ; Memory allocation error.
    POP BC      ; BC = length
    POP DE      ; DE = Name
    PUSH HL
    PUSH HL
    POP IX      ; IX = Program_in_memory, Stack: [ program_in_memory ]
    EX DE, HL   ; HL = Program name
    LD D, 1     ; /bin directory.
;    LD D, 0     ; / directory.
    LD E, %11000000 ; Executable file (Flags)
    CALL check_for_inittab
    CALL mkfile ; No error correction.
    POP HL
    JP free

check_for_inittab:
    PUSH BC
    PUSH DE
    PUSH HL
    PUSH IX
    LDPTR DE inittab_name_check
    CALL strcmp
    XOR A
    OR L
    JR Z, inittab_found
    POP IX
    POP HL
    POP DE
    POP BC
    RET
inittab_found:
    POP IX
    POP HL
    POP DE
    POP BC
    LD DE, %0000000010000000
    RET

pgmtofs_fail:
    POP HL
    POP HL
    LD HL, $ffff
    RET

pgm_data:


buffer:
    .dw $0000

bufout:
    .dw $0000

formatstr:
.db "Formatting FS...", 0

inittab_name_check:
.db "inittab"



pgm_end:

.end