#include "baos_z80asm.inc"

startup:
    LD HL, 2048
    PUSH HL
    CALL malloc
    LD A, H
    OR L
    JR Z, memerror
    LD (buffer), HL
    POP HL
    LD (buflen), HL
refresh:
    CALL display_lines
    LD DE, (cursor)
    CALL setscrnloc
    JP waitforkey

memerror:
    POP HL
    LDPTR HL memmsg
    JP printstr

display_lines:
    LD HL, (buffer)
    LD DE, (position)
    ADD HL, DE
    DEC HL            ; Because position '1' is topleft.'
    LD (bufpos), HL
    CALL clrscrn
    CALL findtoprow   ; Point HL to the start of the row, and do a DE = lenght - skipped chars.
    LD B, 8
display_nextline:
    LD C, 16
display_nextchar:
    CALL display_cursorcheck
    LD A, D
    OR E
    RET Z
    LD A, (HL)
    INC HL
    DEC DE
    CALL pushall_printc
    CP '\n'
    JR Z, display_newline
    DEC C
    XOR A
    OR C
    JR Z, display_newline
    JR display_nextchar
display_newline:
    DJNZ display_newline_cont
    RET
display_newline_cont:
    LD C, 16
    JR display_nextline

display_cursorcheck:
    PUSH DE
    LD DE, (bufpos)
    LD A, H
    CP D
    JR NZ, display_cursorcheck_cont
    LD A, L
    CP E
    JR NZ, display_cursorcheck_cont
    CALL getscrnloc
    LD (cursor), DE
display_cursorcheck_cont:
    POP DE
    RET

waitforkey:
    CALL getkey
    CP AscMode
    JP Z, menu
    CP AscDel
    JP Z, Delete
    CP AscBackSpc
    JP Z, Backspace
    CP AscUp
    JP Z, decrow
    CP AscDown
    JP Z, incrow
    CP AscLeft
    JP Z, deccol
    CP AscRight
    JP Z, inccol
    CP 128
    JP C, addchar
    JP waitforkey

findtoprow:
    LD DE, (length)
    LD HL, (buffer)
    LD BC, (toprow)
findtoprow_loop:
    LD A, B
    OR C
    RET Z
    DEC BC
findtoprow_loop2:
    LD A, (HL)
    INC HL
    DEC DE
    CP '\n'
    JR NZ, findtoprow_loop2
    JR findtoprow_loop

pushall_printc:
    PUSH AF
    PUSH BC
    PUSH DE
    PUSH HL
    CALL printc
    POP HL
    POP DE
    POP BC
    POP AF
    RET

addchar:
    PUSH AF
    CALL movright
    POP AF
    LD HL, (buffer)
    LD DE, (position)
    ADD HL, DE
    DEC HL      ; Because of the movright
    DEC HL      ; Because position '1' is topleft.
    LD (HL), A
    CALL calctoprow
    JP refresh

delete:
movleft:
    LD DE, (position)
    LD HL, (length)
    SCF
    CCF
    SBC HL, DE
    LD A, H
    AND L
    CP $FF
    JR Z, waitforkey
    LD A, H
    OR L
    JR Z, movleft_nomove
    LD B, H
    LD C, L
    LD HL, (position)
    LD DE, (buffer)
    ADD HL, DE
    LD D, H
    LD E, L
    DEC DE    ; Because the minimal value of (position) is 1, not 0
    LDIR

movleft_nomove:
    LD DE, (length)
    DEC DE
    LD (length), DE
    JP refresh

backspace:
    LD HL, (position)
    DEC HL
    LD A, H
    OR L
    JP Z, waitforkey
    LD (position), HL
    CALL calctoprow
    JP delete

deccol:
    LD HL, (position)
    DEC HL
    LD A, H
    OR L
    JP Z, waitforkey
    LD (position), HL
    CALL calctoprow
    JP refresh

inccol:
    LD DE, (position)
    LD HL, (length)
    ;INC HL            ; First position = 1, not 0
    SCF
    CCF
    SBC HL, DE
    LD A, H
    AND L
    CP $FF
    JP Z, waitforkey
    INC DE
    LD (position), DE
    CALL calctoprow
    JP refresh

incrow:
    LD A, (cursor)  ; Current column
    LD B, A
    LD C, A

    LD HL, (buffer)
    LD DE, (position)
    ADD HL, DE
    DEC HL  ; Position 1 is the start.

incrow_loop:
    LD A, (length+1)
    CP D
    JR C, incrow_end
    JR NZ, incrow_loop_cont
    LD A, (length)
    CP E
    JR C, incrow_end
incrow_loop_cont:
    LD A, (HL)
    INC DE
    INC HL
    CP '\n'
    JR Z, incrow_prenextloop
    INC C
    LD A, 16
    CP C
    JR Z, incrow_prenextloop
    JR incrow_loop

incrow_prenextloop:
    LD C, 0

incrow_nextloop:
    LD A, (length+1)
    CP D
    JR C, incrow_end
    JR NZ, incrow_nextloop_cont
    LD A, (length)
    CP E
    JR C, incrow_end
incrow_nextloop_cont:
    LD A, (HL)
    CP '\n'
    JR Z, incrow_end
    LD A, C
    CP B
    JR Z, incrow_end
    INC HL
    INC DE
    INC C
    JR incrow_nextloop

incrow_end:
    LD (position), DE
    CALL calctoprow
    JP refresh

decrow:
    LD HL, (buffer)
    LD DE, (position)
    LD A, (cursor)
    LD B, A
    LD C, A
    ADD HL, DE
    DEC HL

decrow_loop:
    LD A, D
    OR E
    JR Z, decrow_incend
    DEC DE
    DEC HL
    DEC C
    LD A, (HL)
    CP '\n'
    CALL Z, decrow_findcol
    LD A, C
    CP B
    JR Z, decrow_end
    CP $FF
    JR NZ, decrow_loop
    LD C, 15
    JR decrow_loop

decrow_incend:
    INC DE
decrow_end:
    LD (position), DE
    CALL calctoprow
    JP refresh

decrow_findcol:
    PUSH DE
    PUSH HL
    PUSH BC

    LD BC, 0
decrow_findcol_loop:
    DEC HL
    DEC DE
    INC BC
    LD A, (HL)
    CP '\n'
    JR Z, decrow_findcol_endloop
    LD A, D
    OR E
    JR NZ, decrow_findcol_loop
decrow_findcol_endloop:
    DEC BC
    LD A, %00001111
    AND C
    LD C, A
    POP AF
    LD B, A
    CP C
    JR C, decrow_findcol_end
    LD C, B
decrow_findcol_end:
    POP HL
    POP DE
    RET


movright:
    LD HL, (length)
    INC HL
    LD A, (buflen+1)
    CP H
    JR C, overflow
    JR NZ, movright_cont
    LD A, (buflen)
    CP L
    JR C, overflow
movright_cont:
    LD (length), HL
    LD DE, (position)
    INC DE
    LD (position), DE
    SCF
    CCF
    SBC HL, DE
    LD A, H
    AND L
    CP $FF
    RET Z
    LD B, H
    LD C, L
    INC BC
    LD HL, (length)
    LD DE, (buffer)
    ADD HL, DE
    DEC HL    ; Because length = 0 means no data at all
    LD D, H
    LD E, L
    DEC HL    ; Because it's increased at the top of this routine.
    LDDR
    RET

overflow:
    POP HL
    CALL clrscrn
    LDPTR HL overflowmsg
    CALL printstr
    CALL getkey
    JP refresh

calctoprow:   ; Calculating the toprow, by calculating the current row.
    LD BC, (position)
    DEC BC    ; position starts at 1
    LD HL, (buffer)
    LD DE, 0
    LD A, B
    OR C
    JP Z, calctoprow_noloop
    LD A, 0
    PUSH AF
calctoprow_loop:
    LD A, (HL)
    CP '\n'
    JP Z, calctoprow_nextline_pop
    POP AF
    INC A
    CP 16
    JP Z, calctoprow_nextline
    PUSH AF
calctoprow_return:
    INC HL
    DEC BC
    LD A, B
    OR C
    JR NZ, calctoprow_loop

    ; We now have to row we are on
    POP AF
calctoprow_noloop:
    LD HL, (toprow)
    PUSH DE
    EX DE, HL
    SCF
    CCF
    SBC HL, DE
    POP DE
    LD A, H
    CP $FF
    JP Z, calctoprow_equ
    LD HL, (toprow)
    PUSH DE
    LD DE, 7
    ADD HL, DE
    POP DE
    SCF
    CCF
    SBC HL, DE
    LD A, H
    CP $FF
    JP Z, calctoprow_equ7
    RET

calctoprow_nextline_pop:
    POP AF
calctoprow_nextline:
    LD A, 0
    PUSH AF
    INC DE
    JP calctoprow_return

calctoprow_equ7:
    LD HL, -7
    ADD HL, DE
    EX DE, HL
calctoprow_equ:
    LD (toprow), DE
    RET

exit:
    LD HL, (buffer)
    CALL free
    CALL clrscrn
    RET

menu:
    CALL clrscrn
    LDPTR HL menutext
    CALL printstr
    CALL getc
    CP '1'
    JP Z, loadfile
    CP 'y'
    JP Z, loadfile
    CP '2'
    JP Z, savefile
    CP 'z'
    JP Z, savefile
    CP '3'
    JP Z, exit
    CP '@'
    JP Z, exit
    CP '0'
    JP Z, refresh
    CP ' '
    JP Z, refresh
    JP menu

savefile:
    CALL clrscrn
    LDPTR HL savemsg
    CALL printstr
    CALL getfilename
    LD IX, (buffer)
    LD BC, (length)
    CALL writefile
    ;NOP
    LD A, H
    CP $FF
    JR Z, savefile_fail
    CALL clrscrn
    LDPTR HL savedmsg
savefile_ret:
    CALL printstr
    CALL getkey
    JP refresh
savefile_fail:
    CALL clrscrn
    LDPTR HL savefailmsg
    JP savefile_ret

loadfile:
    CALL clrscrn
    LDPTR HL loadmsg
    CALL printstr
    CALL getfilename

    ; First check if the buffer is big enough
    PUSH HL
    CALL findfile
    LD A, H
    CP $FF
    POP HL
    JR Z, loadfile_nofile
    LD A, (buflen+1)
    CP B
    JP C, bigfile
    JR NZ, loadfile_fileok
    LD A, (buflen)
    CP C
    JP C, bigfile
loadfile_fileok:
    LD DE, (buffer)
    CALL load
    LD A, H
    CP $FF
    JR NZ, loadfile_cont
    LD A, L
    CP $FF
    JR Z, loadfile_nofile
    CP $FE
    JR Z, loadfile_nofile
    CP $FD
    JR Z, loadfile_memerr
loadfile_cont:
    LD (buffer), HL
    LD HL, 0
    LD (cursor), HL
    LD (toprow), HL
    LD (bufpos), HL
    INC HL
    LD (position), HL
    LD (length), BC
    JP refresh

loadfile_nofile:
    CALL clrscrn
    LDPTR HL fnfmsg
    CALL printstr
    CALL getkey
    JP refresh

loadfile_memerr:
    CALL clrscrn
    LDPTR HL memmsg
    CALL printstr
    LDPTR HL anykeymsg
    CALL printstr
    CALL getkey
    JP refresh

getfilename:
    LDPTR HL filename
    PUSH HL
    LD BC, 64
    CALL gets
    POP HL
    PUSH HL
    CALL removebackn
    POP HL
    RET

bigfile:
    CALL clrscrn
    LDPTR HL bigfilemsg
    CALL printstr
    CALL getkey
    JP refresh

pgm_data:

cursor:
.dw 0

buffer:
.dw 0

buflen:
.dw 0

toprow:
.dw 0

length:
.dw 0

position:
.dw 1

bufpos:
.dw 0

filename:
.dw 0, 0, 0, 0  ;  8 bytes
.dw 0, 0, 0, 0  ; 16
.dw 0, 0, 0, 0  ; 24
.dw 0, 0, 0, 0  ; 32
.dw 0, 0, 0, 0  ; 40
.dw 0, 0, 0, 0  ; 48
.dw 0, 0, 0, 0  ; 56
.dw 0, 0, 0, 0  ; 64 bytes


memmsg:
.db "Out of memory!\n",0

menutext:
.db "  *** MENU ***  "
.db "\n"
.db " 1: Load File\n"
.db " 2: Save File\n"
.db " 3: Exit\n"
.db "\n"
.db " 0: Close Menu\n"
.db "\n"
.db "> ",0

loadmsg:
.db " ** Load file **"
.db "\n"
.db "Enter the name\n"
.db "of the file to\n"
.db "load:\n"
.db "\n"
.db "> ", 0

savemsg:
.db " ** Save file **"
.db "\n"
.db "Enter a filename"
.db "to save this\n"
.db "file:\n"
.db "\n"
.db "> ", 0

savedmsg:
.db " ** Save file **"
.db "\n"
.db "\n"
.db "\n"
.db " File saved.\n"
.db "\n"
.db "\n"
.db "Press any key..."
.db 0

fnfmsg:
.db "  *** Error *** "
.db "\n"
.db "File not found!\n"
anykeymsg:
.db "\n"
.db "Press any key...",0

savefailmsg:
.db "  *** Error *** "
.db "\n"
.db "Error writing\n"
.db "file.\n"
.db "\n"
.db "Press any key...",0

overflowmsg:
.db "  *** Error *** "
.db "\n"
.db "File buffer full"
.db "can't add any\n"
.db "data without\n"
.db "removing first.\n"
.db "\n"
.db "Press any key...",0

bigfilemsg:
.db "  *** Error *** "
.db "\n"
.db "File length\n"
.db "exceeds buffer!\n"
.db "\n"
.db "Can't open file."
.db "\n"
.db "Press any key...",0


pgm_end: