#include "baos_z80asm.inc"

; cp.asm, a tool to copy a file from one place to an other.

    LD HL, 128
    CALL malloc
    LD A, H
    OR L
    JP Z, nomem
    PUSH HL
    LDPTR HL srcmsg
    CALL printstr
    POP HL
    PUSH HL
    LD BC, 127
    CALL gets
    POP HL
    PUSH HL
    CALL removebackn
    POP HL
    PUSH HL
    CALL findfile
    PUSH AF
    LD A, $FF
    CP H
    JP Z, fnf
    POP AF
    AND %10000000
    JP Z, srcdir
    IN A, (6)

    LD DE, 0-16
    ADD HL, DE
    POP DE      ; Get pointer back
    PUSH AF     ; Save source file.
    PUSH HL
    EX DE, HL

    ; Next step: get a destination.
    PUSH HL
    LDPTR HL destmsg
    CALL printstr
    POP HL
    PUSH HL
    LD BC, 127
    CALL gets
    POP HL
    PUSH HL
    CALL removebackn
    POP HL
    PUSH HL
    CALL findfile

    ; Now several things might have happend:
    ;
    ; * The destination was found and it is a file
    ;   (H != $FF && (A & 0x80) == 1)
    ;   >>> unlink file and copy.
    ;
    ; * The destination was found and it is a dir
    ;   (H != $FF && (A & 0x80) != 1)
    ;   >>> copy it into this dir.
    ;
    ; * The destination was not found, but the updir was
    ;   (HL == $FFFF)
    ;   >>> copy it into the updir, with the name of the file that wasn't found.
    ;
    ; * The destination was not found and the updir wasn't found
    ;   (HL == $FFFE)
    ;   >>> exit with an error.


    LD E, A
    LD A, $FF
    CP H
    JR NZ, exists
    CP L
    JR Z, cptofile
    POP HL
    CALL free
    POP HL
    POP HL
    LDPTR HL fnfmsg
    JP printstr

exists:
    LD A, E
    AND %10000000
    JR Z, cptodir

    ; First unlink, then copy.
exists_unlink:
    POP HL
    PUSH HL
    CALL unlink
    POP HL
    PUSH HL
    JP cptofile

cptodir:
    ; We need to append the filename to the path
    POP HL
    PUSH HL
    LDPTR DE slash
    CALL strcat
    POP HL
    POP DE
    PUSH DE
    PUSH HL
    INC DE
    INC DE
    INC DE
    INC DE
    LD A, 12
    CALL strncat

    ; Make sure the file doesn't exists (if a directory was given in the first place)

cptofile:

    POP HL
    PUSH HL
    CALL findfile
    LD E, A
    LD A, $FF
    CP H
    JR Z, cptofile_cont
    LD A, %10000000
    AND E
    JR NZ, exists_unlink
    POP HL
    CALL free
    POP HL
    POP HL
    LDPTR HL direrrmsg
    JP printstr

cptofile_cont:
    CP L
    JP NZ, interror

    ; Stack: [MEMPTR] [Location of source file] [Page of source file]

    LD D, B    ; D = directory of destination file

    ; OK, now the actual copying begins.
    ; First allocate "disk"-space:

    POP HL
    PUSH HL
    CALL getbasename

    POP BC
    POP HL
    POP AF

    OUT (6), A
    LD E, A
    PUSH DE
    PUSH HL
    PUSH BC

    ; Stack: [PTR to memory] [location of source] [Target directory | Source Page]

    INC HL
    LD A, (HL)
    CPL
    LD B, A
    XOR A
    CALL falloc
    LD A, H
    AND L
    CP $FF
    JP Z, nospace

    POP DE
    PUSH HL
    LD HL, 64
    ADD HL, DE

    ; HL points to a free 64 bytes.

    POP IY  ; Destination block
    POP DE
    RL E
    RL D
    RL E
    RL D    ; D *= 4

    LD E, D
    POP BC
    LD D, C
    PUSH IY
    PUSH BC

    ; Stack: [ Target Dir | Source Page ] [ Target Block ]
    ; DE = Source block
    ; HL = Free memory

    PUSH DE
    PUSH HL
    EX DE, HL
    CALL readblk
    POP HL
    POP BC
    POP DE
    PUSH BC
    PUSH HL
    INC HL
    INC HL  ; HL points to the directory ID.
    LD (HL), D
    INC HL
    INC HL  ; HL points to the filename
    LD DE, 0-68
    PUSH HL
    ADD HL, DE
    POP DE
    EX DE, HL
    LD A, 12
    CALL strncpy
    POP HL

    ; Stack: [ Source Block] [ Target Block ]
    ; HL = pointer to first block in memory.

    ; Let's write out the first block...
    POP BC
    POP DE
    PUSH DE
    PUSH BC
    PUSH HL
    CALL writeblk
    LD A, H
    AND L
    CP $FF
    JR Z, interror

    ; Now we only need to loop to write the other blocks (if any).
    POP HL
    POP BC
    POP DE
    INC HL
    LD A, (HL)
    DEC HL

    CPL
    DEC A
    JP NZ, cpblkloop
    JP free

cpblkloop:
    INC C
    INC E
    PUSH AF
    PUSH BC
    PUSH HL
    PUSH DE
    LD D, H
    LD E, L
    LD H, B
    LD L, C
    CALL readblk
    POP DE
    POP HL
    PUSH HL
    PUSH DE
    CALL writeblk
    LD A, H
    AND L
    CP $FF
    JR Z, interror_pop
    POP DE
    POP HL
    POP BC
    POP AF
    DEC A
    JR NZ, cpblkloop
    JP free

nospace:
    POP HL
    POP HL
    CALL free
    POP HL
    POP HL
    LDPTR HL nospcmsg
    JP printstr


srcdir:
    POP HL
    CALL free
    LDPTR HL srcdirmsg
    JP printstr

fnf:
    POP HL
    POP HL
    CALL free
    LDPTR HL fnfmsg
    JP printstr

interror_pop:
   POP HL
interror:
   POP HL
   CALL free
   POP HL
   POP HL
   LDPTR HL interrmsg
   JP printstr

getbasename:
    LD A, (HL)
    OR A
    RET Z
    PUSH HL
    LD B, H
    LD C, L
getbasename_loop:
    INC HL
    LD A, (HL)
    CP 0
    JR Z, getbasename_copy
    CP '/'
    JR NZ, getbasename_loop
    LD B, H
    LD C, L
    INC BC
    JR getbasename_loop
getbasename_copy:
    POP HL
getbasename_copyloop:
    LD A, (BC)
    LD (HL), A
    INC HL
    INC BC
    CP 0
    JR NZ, getbasename_copyloop
    RET

nomem:
    LDPTR HL nomemmsg
    JP printstr

pgm_data:

srcmsg:
.db "Source:\n> ", 0

destmsg:
.db "Destination:\n> ", 0

fnfmsg:
.db "File not found!\n", 0

srcdirmsg:
.db "Is a directory!\n", 0

direrrmsg:
.db "Directory with\n"
.db "the same name\n"
.db "already exists!\n", 0

interrmsg:
.db "Internal error!\n",0

nospcmsg:
.db "No space left!\n", 0

nomemmsg:
.db "Out of memory!\n", 0


slash:
.db "/", 0

pgm_end: