#include <stdio.h>
#include <string.h>

#define MAX_PROGS 256
//#define DEBUG

// This program is used to create the userspc.h file in the src/userspc directory.

int convert(char *, char **, char **);

int main(int argc, char **argv)
{
  int line, i; 
  int noincludes = 0;
  char str[128];
  char *name, *file;
  char table[MAX_PROGS][128];
  int entries = 0;

  FILE *fin, *fout;

  if (argc != 3)
  {
    if (argc == 4 && !strcmp(argv[3], "--noincludes"))
      noincludes = 1;
    else
    {
      fputs("Usage: genusph <table_file> <out_file> [ --noincludes ]\n", stdout);
      return(1);
    }
  }

  if (!(fin = fopen(argv[1], "r")))
  {
    printf("Error opening input file (%s).\n"
           "Usage: genusph <table_file> <out_file> [ --noincludes ]\n", argv[1]);
    return(1);
  }
  if (!(fout = fopen(argv[2], "w")))
  {
    printf("Error opening output file (%s).\n"
           "Usage: genusph <table_file> <out_file> [ --noincludes ]\n", argv[2]);
    return(1);
  }

#ifdef DEBUG
  printf("Opened files: %s (input), %s (output).\n", argv[1], argv[2]);
#endif

  line = 1;

  while (!feof(fin))
  {

    fgets(str, 127, fin);

    if (i = convert(str, &file, &name))
    {
      if (i == 1)
      {
        printf("Error: Syntax-error at line %d.\n", line);
        return(2);
      }
      else
      {
        fprintf(fout,   ";***********************************************************\n"
                        ";*\n"
                        ";*   Userspace program %s -- entry created by genusph.\n"
                        ";*\n"
                        ";***********************************************************\n"
                        "\n"
                        "%s:\n"
                        ".dw %s_name\n",
                        name, str, str);

        if (!noincludes)
          fprintf(fout, "#include \"userspc/%s\"\n",
                        file);

        fprintf(fout,  "%s_name:\n"
                        ".db \"%s\", 0\n"
                        "\n"
                        "\n",
                        str, name);

        strcpy(table[entries], str);
        entries++;

#ifdef DEBUG
        printf("Wrote entry for program %s (label=%s, file=%s).\n", name, str, file);
#endif
      }
    }
    line++;
  }

  // Now write out the index.

  fprintf(fout, ";***********************************************************\n"
                ";*\n"
                ";*   Master index -- generated by genusph.\n"
                ";*\n"
                ";***********************************************************\n"
                "\n"
                "userspc_index:\n");
  if (entries)
    for (i = 0; i < entries; i++)
      fprintf(fout, ".dw %s\n", table[i]);

  fprintf(fout, ".dw $0000\n");

  fclose(fin);
  fclose(fout);
  return(0);
}

int convert(char *str, char **file, char **name)
{
  int i, j = 0;
  char *ptr = str;

  for (i = 0; *ptr; ptr++)
    switch(*ptr)
    {
      case ' ':
      case '\t':
        j++;
        break;
      case '\n':
      case '\r':
        *ptr = '\0';
        break;
      default:
        i++;
    }
  if (!i || *str == '#')
    return(0);

  if (j) return(1);

  i = j = 0;
  for (ptr = str; *ptr; ptr++)
  {
    if (*ptr == '=')
    {
      if (i++ || j)
        return(1);
      *ptr = '\0';
      *name = ptr + 1;
    }
    else if (*ptr == ',')
    {
      if (i != 1 || j++)
        return(1);
      *ptr = '\0';
      *file = ptr + 1;
    }
  }
  return(-1);
}
