// gendoc.c -- Generates HTML function references from source code.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct regIO {
  char A[1024];
  char B[1024];
  char C[1024];
  char D[1024];
  char E[1024];
  char H[1024];
  char L[1024];
  char BC[1024];
  char DE[1024];
  char HL[1024];
  char IX[1024];
  char IY[1024];
};

struct function_data {
  char name[256];
  char description[4096];
  char file[256];
  struct regIO in;
  struct regIO out;
  struct function_data *next;
};

void rembackn(char *);
char toup(char);
void makelink(char *, char *);

int needswitch(char *, char *);

void initfunc (struct function_data *);
void sort (struct function_data **, int);
void printout (struct function_data **);
struct function_data *newfunc (struct function_data *);

int main ()
{
  char line[1024], file[256], *ptr;
  struct function_data *funcs, *curfunc;

  *file = '\0';

  if (!(funcs = malloc(sizeof(struct function_data))))
  {
    fprintf(stderr, "Out of memory!\n");
    exit (1);
  }
  initfunc (funcs);

  while (!feof(stdin))
  {
    fgets(line, 1024, stdin);
    rembackn(line);
    ptr = line;
    while (*ptr == ' ' || *ptr == '\t') ptr++;

    if (!strncmp(ptr, ";*** ", 5))
    {
      strcpy(file, ptr + 5);
      //fprintf(stderr, "New file: \"%s\" (line: %s)\n", file, ptr);
    }
    else if (!strncmp(ptr, ";** ", 4))
    {
      curfunc = newfunc(funcs);
      strcpy (curfunc->name, ptr +4);
      strcpy (curfunc->file, file);

      //fprintf(stderr, "Found new function \"%s\"    (line: \"%s\")\n", curfunc->name, line);

      while (!feof(stdin))
      {
        fgets(line, 256, stdin);
        rembackn(line);
        ptr = line;
        while (*ptr == ' ' || *ptr == '\t') ptr++;

        if (strncmp(ptr, ";* ", 3))
          break;

        ptr += 3;
        if (!strncmp(ptr, "OUT A: ", 7))
          strcpy(curfunc->out.A, ptr+7);
        else if (!strncmp(ptr, "OUT B: ", 7))
          strcpy(curfunc->out.B, ptr+7);
        else if (!strncmp(ptr, "OUT C: ", 7))
          strcpy(curfunc->out.C, ptr+7);
        else if (!strncmp(ptr, "OUT D: ", 7))
          strcpy(curfunc->out.D, ptr+7);
        else if (!strncmp(ptr, "OUT E: ", 7))
          strcpy(curfunc->out.E, ptr+7);
        else if (!strncmp(ptr, "OUT H: ", 7))
          strcpy(curfunc->out.H, ptr+7);
        else if (!strncmp(ptr, "OUT L: ", 7))
          strcpy(curfunc->out.L, ptr+7);
        else if (!strncmp(ptr, "OUT BC: ", 8))
          strcpy(curfunc->out.BC, ptr+8);
        else if (!strncmp(ptr, "OUT DE: ", 8))
          strcpy(curfunc->out.DE, ptr+8);
        else if (!strncmp(ptr, "OUT HL: ", 8))
          strcpy(curfunc->out.HL, ptr+8);
        else if (!strncmp(ptr, "OUT IX: ", 8))
          strcpy(curfunc->out.IX, ptr+8);
        else if (!strncmp(ptr, "OUT IY: ", 8))
          strcpy(curfunc->out.IY, ptr+8);

        else if (!strncmp(ptr, "IN A: ", 6))
          strcpy(curfunc->in.A, ptr+6);
        else if (!strncmp(ptr, "IN B: ", 6))
          strcpy(curfunc->in.B, ptr+6);
        else if (!strncmp(ptr, "IN C: ", 6))
          strcpy(curfunc->in.C, ptr+6);
        else if (!strncmp(ptr, "IN D: ", 6))
          strcpy(curfunc->in.D, ptr+6);
        else if (!strncmp(ptr, "IN E: ", 6))
          strcpy(curfunc->in.E, ptr+6);
        else if (!strncmp(ptr, "IN H: ", 6))
          strcpy(curfunc->in.H, ptr+6);
        else if (!strncmp(ptr, "IN L: ", 6))
          strcpy(curfunc->in.L, ptr+6);
        else if (!strncmp(ptr, "IN BC: ", 7))
          strcpy(curfunc->in.BC, ptr+7);
        else if (!strncmp(ptr, "IN DE: ", 7))
          strcpy(curfunc->in.DE, ptr+7);
        else if (!strncmp(ptr, "IN HL: ", 7))
          strcpy(curfunc->in.HL, ptr+7);
        else if (!strncmp(ptr, "IN IX: ", 7))
          strcpy(curfunc->in.IX, ptr+7);
        else if (!strncmp(ptr, "IN IY: ", 7))
          strcpy(curfunc->in.IY, ptr+7);
        else
        {
          strcat(curfunc->description, ptr);
          strcat(curfunc->description, " ");
        }
      }
    }
  }

  printout(&funcs);
  return(0);
}

void initfunc(struct function_data *f)
{
  *f->name = *f->description = *f->file = \
             *f->in.A = *f->in.B = *f->in.C = *f->in.D = *f->in.E = *f->in.H = *f->in.L = \
             *f->in.BC = *f->in.DE = *f->in.HL = *f->in.IX = *f->in.IY = \
             *f->out.A = *f->out.B = *f->out.C = *f->out.D = *f->out.E = *f->out.H = *f->out.L = \
             *f->out.BC = *f->out.DE = *f->out.HL = *f->out.IX = *f->out.IY = '\0';
  f->next = NULL;
}

struct function_data *newfunc (struct function_data *f)
{
  while (f->next)
    f = f->next;

  if (!(f->next = malloc(sizeof(struct function_data))))
  {
    fprintf(stderr, "Out of memory!\n");
    exit (1);
  }
  initfunc (f->next);

  return(f);
}

void sort (struct function_data **f, int onfile)
{
  struct function_data *base, *ptr1, *ptr2, *temp;
  int switched, x;

  if (!(base = malloc(sizeof(struct function_data))))
  {
    fprintf(stderr, "Out of memory!\n");
    exit (2);
  }

  base->next = *f;

  switched = 1;

  while (switched)
  {
    switched = 0;
    ptr1 = base;

    while (ptr1->next && ptr1->next->next && ptr1->next->next->next)
    {
      ptr2 = ptr1->next;

      x = needswitch(ptr2->file, ptr2->next->file);
      if (onfile && x > 0)
      {
        ptr1->next = ptr2->next;
        ptr2->next = ptr2->next->next;
        ptr1->next->next = ptr2;

        switched++;
      }
      else if (!onfile || !x)
      {
        if(needswitch(ptr2->name, ptr2->next->name) > 0)
        {
          ptr1->next = ptr2->next;
          ptr2->next = ptr2->next->next;
          ptr1->next->next = ptr2;

          switched++;
        }
      }

      ptr1 = ptr1->next;
    }
  }
  *f = base->next;
  free(base);
}

void printout (struct function_data **first)
{
  struct function_data *ptr, *f;

  char link[256], lastfile[256];
  char lastch = ' ';

  printf("</p><p>\n"
         "<table class=\"table-borderless\">\n"
         "<tr><th><center>Sorted by file</center></th><th><center>Sorted alphabetically</center></th></tr>\n"
         "<tr><td valign=\"top\"><ul>\n");

  sort(first, 1);
  f = *first;
  *lastfile = '\0';

  while (f->next)
  {
    if (strcmp(lastfile, f->file))
    {
      strcpy(lastfile, f->file);
      printf("<li class=\"li-title\"><strong>%s</strong></li>\n", lastfile);
    }

    makelink(link, f->name);
    printf("<li><a href=\"#%s\">%s</a></li>\n", link, f->name);

    f = f->next;
  }

  sort(first, 0);
  f = *first;

  printf("</ul></td><td valign=\"top\"><ul>\n");

  while (f->next)
  {
    if (toup(*f->name) != lastch)
    {
      lastch = toup(*f->name);
      printf("<li class=\"li-title\"><strong>%c</strong></li>\n", lastch);
    }

    makelink(link, f->name);
    printf("<li><a href=\"#%s\">%s</a></li>\n", link, f->name);

    f = f->next;
  }

  printf("</ul></td></tr></table>\n"
         "<table class=\"table-borderless\">\n");

  f = *first;

  while (f->next)
  {
     makelink(link, f->name);
     printf("<tr><td colspan=\"3\"><hr /></td></tr>\n"
            "<tr><th><a name=\"%s\"></a>Name</th>  <td><code>%s</code></td>  <td>(%s)</td></tr>\n",
            link, f->name, f->file);

    if (*f->in.A)
      printf("<tr><th>Input</th> <th>A</th> <td>%s</td></tr>\n", f->in.A);

    if (*f->in.BC)
      printf("<tr><th>Input</th> <th>BC</th> <td>%s</td></tr>\n", f->in.BC);
    if (*f->in.B)
      printf("<tr><th>Input</th> <th>B</th> <td>%s</td></tr>\n", f->in.B);
    if (*f->in.C)
      printf("<tr><th>Input</th> <th>C</th> <td>%s</td></tr>\n", f->in.C);

    if (*f->in.DE)
      printf("<tr><th>Input</th> <th>DE</th> <td>%s</td></tr>\n", f->in.DE);
    if (*f->in.D)
      printf("<tr><th>Input</th> <th>D</th> <td>%s</td></tr>\n", f->in.D);
    if (*f->in.E)
      printf("<tr><th>Input</th> <th>E</th> <td>%s</td></tr>\n", f->in.E);

    if (*f->in.HL)
      printf("<tr><th>Input</th> <th>HL</th> <td>%s</td></tr>\n", f->in.HL);
    if (*f->in.H)
      printf("<tr><th>Input</th> <th>H</th> <td>%s</td></tr>\n", f->in.H);
    if (*f->in.L)
      printf("<tr><th>Input</th> <th>L</th> <td>%s</td></tr>\n", f->in.L);

    if (*f->in.IX)
      printf("<tr><th>Input</th> <th>IX</th> <td>%s</td></tr>\n", f->in.IX);
    if (*f->in.IY)
      printf("<tr><th>Input</th> <th>IY</th> <td>%s</td></tr>\n", f->in.IY);

    if (*f->out.A)
      printf("<tr><th>Output</th> <th>A</th> <td>%s</td></tr>\n", f->out.A);

    if (*f->out.BC)
      printf("<tr><th>Output</th> <th>BC</th> <td>%s</td></tr>\n", f->out.BC);
    if (*f->out.B)
      printf("<tr><th>Output</th> <th>B</th> <td>%s</td></tr>\n", f->out.B);
    if (*f->out.C)
      printf("<tr><th>Output</th> <th>C</th> <td>%s</td></tr>\n", f->out.C);

    if (*f->out.DE)
      printf("<tr><th>Output</th> <th>DE</th> <td>%s</td></tr>\n", f->out.DE);
    if (*f->out.D)
      printf("<tr><th>Output</th> <th>D</th> <td>%s</td></tr>\n", f->out.D);
    if (*f->out.E)
      printf("<tr><th>Output</th> <th>E</th> <td>%s</td></tr>\n", f->out.E);

    if (*f->out.HL)
      printf("<tr><th>Output</th> <th>HL</th> <td>%s</td></tr>\n", f->out.HL);
    if (*f->out.H)
      printf("<tr><th>Output</th> <th>H</th> <td>%s</td></tr>\n", f->out.H);
    if (*f->out.L)
      printf("<tr><th>Output</th> <th>L</th> <td>%s</td></tr>\n", f->out.L);

    if (*f->out.IX)
      printf("<tr><th>Output</th> <th>IX</th> <td>%s</td></tr>\n", f->out.IX);
    if (*f->out.IY)
      printf("<tr><th>Output</th> <th>IY</th> <td>%s</td></tr>\n", f->out.IY);

    printf("<tr><th>Description</th><td colspan=\"2\">\n"
           "%s\n"
           "</td></tr>\n\n", f->description);

    ptr = f;
    f = f->next;

    free(ptr);
  }

  printf("</table>\n");
}

void rembackn(char *ptr)
{
  while (*ptr != '\n' && *ptr != '\r' && *ptr != '\0') ptr++;

  *ptr = '\0';
}

char toup(char c)
{
  if (c <= 'z' && c >= 'a')
    c += 'A' - 'a';

  return(c);
}

void makelink(char *dest, char *src)
{
  char *p;
  strcpy(dest, src);

  p = dest;

  while ((*p >= 'a' && *p <= 'z') || (*p >= 'A' && *p <= 'Z') || *p == '_') p++;

  *p = '\0';
}

int needswitch(char *str1, char *str2)
{
  while (toup(*str1) == toup(*str2) && *str1)
  {
    str1++;
    str2++;
  }
  if (toup(*str2) < toup(*str1))
    return(1);

  if (*str1)
    return(-1);

  return(0);
}
