#include <stdio.h>
#include <string.h>

#define BYTESALINE 32


int main(int argc, char **argv)
{
	int checksum, i, j, l, x = 0;
	int c;
        int org, org_in;
	char inf[64], of[64];
	FILE *infile, *outfile;
	
	if (argc != 3)
	{
		fprintf(stderr, "bintohex: Usage: bintohex <filename (without .bin)> <origin (in hex, without pre- or postfix)>\n");
		return(1);
	}

        strcpy(inf, argv[1]);
	strcpy(of, argv[1]);
	
	strcat(inf, ".bin");
	strcat(of, ".hex");
	
        org_in = atoi(argv[2]);
        org = 0;

        while (org_in >= 1000)
        {
            org += 4096;
            org_in -= 1000;
        }
        while (org_in >= 100)
        {
            org += 256;
            org_in -= 100;
        }
        while (org_in >= 10)
        {
            org += 16;
            org_in -= 10;
        }

        org += org_in;

        printf("Using origin: $%04X\n", org);
	
	if (!(infile = fopen(inf,"rb")))
	{
		fprintf(stderr, "bintohex: Can't open input file.\n");
		return(2);
	}
	if (!(outfile = fopen(of, "wb")))
	{
		fprintf(stderr, "bintohex: Can't open output file.\n");
		return(3);
	}

	for (i = 0; (c = fgetc(infile)) != EOF; i++);

	rewind(infile);

	for (j = 0; j <= i; j += BYTESALINE)
	{
		fprintf(outfile, ":%02X%02X%02X00",
		l = (j+BYTESALINE <= i ? BYTESALINE : i-j),
		(unsigned char) ((j+org)/256),
		(unsigned char) ((j+org)%256));
		
		checksum = -l - (j+org) / 256 - (j+org) % 256;

		for (x = 0; x++ != l && (c = fgetc(infile)) != EOF; checksum -= c)
			fprintf(outfile, "%02X", (unsigned char) c);

		while (checksum > 0 || checksum < -255)
			checksum += 256;
		fprintf(outfile, "%02X\n", (unsigned char) checksum);
	}

	fprintf(outfile, ":00000001FF\n");

	fclose(infile);
	fclose(outfile);

	return(0);
}
