#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
  int c;
  FILE *infile, *outfile;

  if (argc != 3)
  {
    fputs("Usage: bin2h <binfile> <includefile>.\n", stdout);
    exit (1);
  }

  if (!(infile = fopen(argv[1], "rb")) || !(outfile = fopen(argv[2], "wb")))
  {
    printf("I/O error.\n");
    exit (1);
  }

  while ((c = fgetc(infile)) != EOF)
    fprintf(outfile, ".db $%02x\r\n", (unsigned char) c);

  fclose(infile);
  fclose(outfile);

  return(0);
}
