// baosmake.c -- a file to create baos

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define outp(x)     nice_outp(inf, x, "")
#define outpf(x, y)  nice_outp(inf, x, y)

/* cfiles-syntax: "<outputfile> <source1> <source2> ..." */

char *cfiles[] = {
"gensyms gensyms.c",
"genusph genusph.c",
"linecnt linecnt.c",
"z80asm z80asm.c getopt.c getopt1.c",
"bin2h bin2h.c",
"encdos encdos.c",
"multihex multihex.c",
"rompatch rompatch.c",
"packxxu packxxu.c",
"bin2hex bin2hex.c",
NULL };


char *srcfilestoclean[] = { 
                         "restrict.hex",
                         "restrict.bin",
                         "restrict.h",
                         "tilem.1.patch",
                         "tilem.2.patch",
                         "flash.h",
                         "baos.hex",
                         "base.hex",
                         "baos.rom",
                         "base.bin",
                         "flashram.bin",
                         "baos.inc",
                         "baos.sym",
                         "baos.8xu",
                         NULL };

char *toolsfilestoclean[] = { 
                         "restrict.hex",
                         "gensyms",
                         "z80asm",
                         "z80asm.o",
                         "getopt.o",
                         "getopt1.o",
                         "bin2h",
                         "multihex",
                         "rompatch",
                         "packxxu",
                         "bin2hex",
                         "encdos",
                         "genusph",
                         NULL };

enum systems
{
  SYSWINDOWS,
  SYSUNIX
};

struct struct_info {
  enum systems sys;
  int step;
  int steps;
};

typedef struct struct_info info;

void nice_outp(info *inf, char *, char *);
void endusage(void);
void delfile(info *, char *);

void clean(info *);
void patch(info *);
void compile(info *);

int main(int argc, char **argv)
{
  info *inf;

  if (!(inf = malloc(sizeof(info))))
  {
    printf("Error allocating memory, exiting...\n");
    return(-1);
  }

  if (argc != 2)
    endusage();
  else if (strcmp(argv[1], "--windows") && strcmp(argv[1], "--unix"))
    endusage();

  if (!strcmp(argv[1], "--unix"))
    inf->sys = SYSUNIX;
  else
    inf->sys = SYSWINDOWS;

  inf->step = inf->steps = 0;

  fputs("\n\n**** Now Assembling BAOS ****\n\n", stdout);

  // cleaning up.

  clean(inf);
  patch(inf);

  if (inf->sys == SYSUNIX) compile(inf);

  return(0);
}

void nice_outp(info *inf, char *str, char *arg)
{
  char format[256];
  int percent;

  strcpy (format, "   [%3d%c]   *  ");
  strcat (format, str);
  strcat (format, "...\n");

  if (!inf->steps)
    percent = inf->step;
  else
    percent = inf->step / inf->steps * 100;

  printf(format, percent, inf->steps ? '%' : ' ', arg);
}

void endusage()
{
  printf("Usage baosmake [ --windows | --unix ]\n");
  exit(1);
}

void clean(info *inf)
{
  char dir[128];
  char path[128];

  char **ptr;

  if (inf->sys == SYSUNIX)
    strcpy(dir, "src/");
  else
    strcpy(dir, "src\\");

  for (ptr = srcfilestoclean; *ptr; ptr++)
  {
    strcpy(path, dir);
    strcat(path, *ptr);
    outpf("Cleaning file: %s", path);
    delfile(inf, path);
  }
  inf->step++;

  if (inf->sys == SYSUNIX)
  {
    strcpy(dir, "src/tools/");
    for (ptr = toolsfilestoclean; *ptr; ptr++)
    {
      strcpy(path, dir);
      strcat(path, *ptr);
      outpf("Cleaning file: %s", path);
      delfile(inf, path);
    }
    inf->step++;
  }
}

void delfile(info *inf, char *path)
{
  char command[128];

  if (inf->sys == SYSUNIX)
    strcpy(command, "rm -f ");
  else
    strcpy(command, "del /f /q ");

  FILE *f;
  if (f = fopen(path, "r"))
  {
    fclose(f);
    strcat(command, path);
    system(command);
  }
}

void patch(info *inf)
{
  outp("Disabling TiLEm patch");
  if (inf->sys == SYSUNIX)
  {
    system("touch src/tilem.1.patch");
    system("touch src/tilem.2.patch");
  }
  else
  {
    system("echo. > tilem.1.patch");
    system("echo. > tilem.2.patch");
  }
  inf->step++;
}

void compile(info *inf)
{
  char cmd[128];
  char name[64];
  char **ptr, *ptr2;

  for (ptr = cfiles; *ptr; ptr++)
  {
    strcpy(cmd, "cd src/tools && gcc -o ");
    strcat(cmd, *ptr);
  }
}

