;*** textio.h

num:     .equ 0
str:     .equ 1
char:    .equ 2
hex:     .equ 3


;** printf
;* IN A: Type of data. <code>num</code>, <code>hex</code>, <code>str</code> and <code>char</code> are predefined integers to use.
;* IN DE: Data (16-bit integer, pointer to a string or (only E) character)
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Prints a character, integer or string (depending on input) to the screen.

printf:
        EX DE, HL
        CP 1
        JP Z, printstr
        CP 3
        JP Z, printhlhex
        CP 2
        JP NZ, printhl
        LD A, L
        JP printc

;** printhlhex
;* IN HL: 16-bit integer
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Prints a 16-bit unsigned integer to the screen in hexadecimal format.

printhlhex:
        PUSH HL
        LD A, '$'
        CALL printc
        POP HL

        LD C, 3
printhlhex_again2:
        PUSH HL
        XOR A
        OR C
        LD HL, $0001
printhlhex_create:
        JR Z, printhlhex_prepare
        ADD HL, HL ; 2
        ADD HL, HL ; 4
        ADD HL, HL ; 8
        ADD HL, HL ; 16
        DEC A
        JR printhlhex_create
printhlhex_prepare:
        EX DE, HL
        POP HL
printhlhex_again1:
        SCF
        CCF
        SBC HL, DE
        JR C, printhlhex_next
        INC A
        JR printhlhex_again1
printhlhex_next:
        ADD HL, DE
        CP 10
        JR C, printhlhex_digit
        LD B, ('A' - 10)        ; 10 is the alpha offset ($A == 10)
        JR printhlhex_alpha
printhlhex_digit:
        LD B, '0'
printhlhex_alpha:
        ADD A, B
        PUSH HL
        PUSH BC
        CALL printc
        POP BC
        POP HL
        XOR A
        OR C
        RET Z
        DEC C
        JR printhlhex_again2


;** printhl
;* IN HL: 16-bit integer
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Prints a 16-bit unsigned integer to the screen (in decimal format).

printhl:
        LD C, 4
printhl_again2:
        PUSH HL
        XOR A
        OR C
        LD HL, $0001
printhl_create:
        JR Z, printhl_prepare
        ADD HL, HL ; 2
        LD D, H
        LD E, L
        ADD HL, HL ; 4
        ADD HL, HL ; 8
        ADD HL, DE ; 10
        DEC A
        JR printhl_create
printhl_prepare:
        EX DE, HL
        POP HL
printhl_again1:
        SCF
        CCF
        SBC HL, DE
        JR C, printhl_next
        INC A
        JR printhl_again1
printhl_next:
        ADD HL, DE
        LD B, '0'
        ADD A, B
        PUSH HL
        PUSH BC
        CALL printc
        POP BC
        POP HL
        XOR A
        OR C
        RET Z
        DEC C
        JR printhl_again2


;** printfat
;* IN A: Type of data. num, hex, str and char are predefined integers to use.
;* IN DE: Position to print to.
;* IN HL: Data (16-bit integer, pointer to a string or (only E) character)
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Same as printf, but prints at a specified location.

printfat:   ; Used to print something at a specified location.
            ; Arguments: A = type of data, HL = (pointer to) data, DE = location.

        CALL scrnsetloc
        CP 1
        JP Z, printstr
        CP 2
        JP NZ, printhl
        LD A, L
        CALL printc
        RET

;** printc
;* IN A: Character to print
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Print a single character the the screen.

printc:
    CALL getscrnloc

    ; Check for special characters.
    CP 10
    JR Z, printc_enter
    CP 12
    JR Z, printc_upleft
    CP 13
    JR Z, printc_carreturn

    CP 8  ; Backspc
    RET Z
    CP AscDel ; Delete
    RET Z

    CP 128	; Check if it exists in the ASCII table  (we only have one half)
    RET NC

    PUSH AF
    LD A, -16
    LD C, 16
    LD B, D
    INC B
printc_loop:
    ADD A, C
    DJNZ printc_loop
    ADD A, E
    LD HL, (screens)
    LD DE, 144
    LD C, A
    LD A, (myscrn)
    LD B, A
    CP 5
    JP Z, printc_exit
printc_loop2:
    ADD HL, DE
    DJNZ printc_loop2
    ADD HL, BC
    POP AF
    LD (HL), A

    ; We still need to increase the location counter
    CALL getscrnloc
    LD A, 16
    INC E
    CP E
    JR NZ, printc_setloc_cont
    INC D
    LD E, 0
    LD A, 9
    CP D
    JR NZ, printc_setloc_cont
    CALL scrnscroll
    DEC D

printc_setloc_cont:
    CALL setscrnloc

    RET

printc_exit:
    POP AF
    RET

;** clrscrn
;* OUT A: Garbage
;* OUT B: Always zero
;* OUT DE: Always zero
;* OUT HL: Garbage
;* Clears the virtual screen of this process.

clrscrn:
    LD HL, (screens)
    LD A, (myscrn)
    LD B, A
    LD DE, 144
clrscrn_again:
    ADD HL, DE
    DJNZ clrscrn_again
    ; We should not disable interrupts when not needed.
    LD A, ' '
    LD B, 144
clrscrn_loop:
    LD (HL), A
    INC HL
    DJNZ clrscrn_loop
    LD DE, $0000
    CALL setscrnloc
    RET

printc_upleft:
    LD DE, $0000
    CALL setscrnloc
    RET

;** newline
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* <code>newline</code> scrolls down one line, and sets the location of the next character to print
;* on the first column of the current screen (like the ENTER key does in a word-processor).
;* It gives the same result as printing the ASCII character 10 (decimal), a.k.a. '\n'.
;* (Note that in DOS/Windows ASCII character 13 is used in text-files and ASCII character 10 in binary files).

printc_enter:
newline:
    INC D
    LD A, 9
    CP D
    JR NZ, printc_carreturn

    CALL scrnscroll
    DEC D

printc_carreturn:
    LD E, 0
    CALL setscrnloc
    RET

;** printstr
;* IN HL: Pointer to a string
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Prints a text string to the screen.

printstr:
    LD A, (HL)
    OR A
    RET Z
    PUSH HL
    CALL printc
    POP HL
    INC HL
    JR printstr

;** scrnscroll
;* If a virtual screen is full (for example if there is an newline character printed on the last line),
;* this function will be called. It simplies scrolls up the whole screen one line,
;* which creates an empty line on the bottom while the top line will be dismissed.

scrnscroll:
    PUSH HL
    PUSH DE
    PUSH BC
    PUSH AF

    DI
    LD A, (scrnblink)
    PUSH AF
    XOR A
    LD (scrnblink), A
    EI

    LD HL, (screens)
    LD DE, 144
    LD A, (myscrn)
    LD B, A
scrnscroll_cont:
    ADD HL, DE
    DJNZ scrnscroll_cont
    LD BC, 16
    LD D, H
    LD E, L
    ADD HL, BC

    ; Now: HL = source, DE is destination.
    LD B, 8*16 ; Last line is empty.
scrnscroll_loop:
    LD A, (HL)
    LD (DE), A
    INC HL
    INC DE
    DJNZ scrnscroll_loop
    LD B, 16
    LD A, ' '
scrnscroll_loop2:
    LD (DE), A
    INC DE
    DJNZ scrnscroll_loop2

    ; Put cursor on the right place and activate.

    LD A, (curscrn)
    LD B, A
    LD A, (myscrn)
    CP B
    JR NZ, scrnscroll_nocurscroll

    LD HL, (blinkloc)
    LD DE, -16
    ADD HL, DE
    LD (blinkloc), HL

scrnscroll_nocurscroll:

    POP AF
    LD (scrnblink), A

    ; Restore

    POP AF
    POP BC
    POP DE
    POP HL
    RET

getc_getkey:
    ; We should not use input if we are not on our screen.

    ; Should not care and put this code into inkey

    ; Ok, we *should* care, since there's no point in busy waiting on a key that never going to be,
    ; and it's a bad idea to put a call to nextproc inside inkey.

    LD A, (curscrn)
    LD B, A
    LD A, (myscrn)
    CP B
    JR Z, getc_cont
    CALL nextproc
    JR getc_getkey
getc_cont:
    CALL inkey
    OR A
    JR Z, getc_getkey
    RET


;** getc
;* OUT A: ASCII code of the key that was pressed.
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* This function waits for a user to press a key (while on the correct virtual screen ofcourse)
;* and returns the ASCII code for this key.
;* <u>The ASCII-code is not returned before the key was released!</u>
;* This functions also prints the key on the screen to let the user know he/she pressed the key.

getc:
    CALL getc_getkey
    CALL getc_testkey
    OR A
    JR Z, getc
getkey_cont:
    PUSH AF
    CALL waitnokey
    POP AF
    PUSH AF
    CALL printc
    POP AF
    RET

;** getkey
;* OUT A: ASCII code of the key that was pressed.
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Same as <code>getc</code>, but doesn't filter out control characters
;* (in the case of BAOS, everything > ASCII 127).

getkey:
    CALL getc_getkey
    JP getkey_cont

getc_testkey:  ; If the key is not displayable, make a zero of it.
               ; Since every key can be displayed accept those above 127
               ; we can easily filter them out:

               ; We made this module seperate for possible future use.
    CP 128
    RET C
    XOR A
    RET

;** gets
;* IN BC: Maximal number of characters to recieve.
;* IN HL: Pointer to the momery the characters should be stored.
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Pointer to the end of the string (trailing zero)
;* This function saves a series of ASCII-codes given by the keypad into a specified location inside the memory.
;* This happends until the user presses the ENTER key or the user is trying to enter more characters than the integer stored in BC.
;* The character-string will be automatically closed with a trailing zero ('\0') character.
;* The characters are also printed to the display when they are read.
;* <B>NOTE</B>: you may never put the number of allocated bytes into BC,
;* since the trailing zero ('\0') byte will exceed this value by one.
;* You can use the number of allocated bytes minus one as BC at max.
;* <B>NOTE2</B>: This function is still under development, special "control characters"
;* (as backspaces, arrows, delete, etc.) are not yet implemented.

gets:   ; Args: BC = Maximal number of chars.
        ;       HL = Pointer to destination memory.

    PUSH DE ; For compability reason
    LD A, B
    OR C
    PUSH HL
    JR Z, gets_end
    PUSH BC
gets_begin_loop:
    LD (HL), 0
    INC HL
    DEC BC
    LD A, B
    OR C
    JR NZ, gets_begin_loop
    LD (HL), 0
    POP BC
    POP HL
    PUSH HL

gets_loop:
    XOR A
    OR C
    JR Z, gets_checkB
gets_return:
    PUSH BC
    PUSH HL
    CALL getc
    POP HL
    POP BC
    CP 8        ; Backspace.
    JR Z, gets_backspc
    CP AscDel   ; Delete
    JR Z, gets_delete
    LD (HL), A
    INC HL
    CP AscEnter
    JR Z, gets_end
    DEC BC
    JR gets_loop

gets_backspc:
    POP DE
    PUSH DE
    LD A, D
    CP H
    JR NZ, gets_backspc_cont
    LD A, E
    CP L
    JR Z, gets_return
gets_backspc_cont:
    DEC HL
    INC BC
    CALL getscrnloc
    XOR A
    OR E
    JR Z, gets_backspc_rowchange
    DEC DE
gets_backspc_return:
    CALL setscrnloc
    PUSH DE
    PUSH HL
    PUSH BC
    LD A, ' '
    CALL printc
    POP BC
    POP HL
    POP DE
    CALL setscrnloc
    JP gets_return

gets_backspc_rowchange:
    LD E, 15
    DEC D
    JP PO, gets_backspc_return
    INC D
    JR gets_backspc_return

gets_delete:
    JR gets_return

gets_checkB:
    OR B
    JR NZ, gets_loop
gets_end:
    XOR A
    LD (HL), A
    POP HL
    POP DE
    RET
