;*** strings.h

;** strlen
;* IN DE: Pointer to the string
;* OUT A: Always zero
;* OUT DE: Pointer to the end of the string
;* OUT HL: Length of the string (including trailing zero-byte)
;* Returns the length of the given string.

strlen:
  LD HL, 0
strlen_again:
  LD A, (DE)
  INC DE
  INC HL
  OR 0
  JP NZ, strlen_again
  RET

;** strcpy
;* IN DE: Source string
;* IN HL: Destination String
;* OUT A Always zero
;* OUT DE: Pointing to the end of the string
;* OUT HL: Pointing to the end of the string
;* Copies a string to a place in the memory.

strcpy: ; Args: HL DE
strcpy_again:
  LD A, (DE)
  LD (HL), A
  INC HL
  INC DE
  OR 0
  JP NZ, strcpy_again
  RET

;** strncpy
;* IN DE: Source string
;* IN HL: Destination String
;* IN A: Maximum number of characters to copy
;* OUT A: Garbage
;* OUT B: Garbage
;* OUT DE: Garbage
;* OUT HL: Pointing to the end of the (destination) string.
;* Same as <code>strcpy</code>, but has a maximum limit of copied characters.

strncpy: ; Args: HL DE A
  LD B, A
strncpy_again:
  LD A, (DE)
  LD (HL), A
  INC HL
  INC DE
  OR 0
  RET Z
  DJNZ strncpy_again
  LD (HL), 0
  RET

;** strncat
;* IN DE: Source string
;* IN HL: Destination String
;* IN A: Maximum number of characters to copy
;* OUT A: Garbage
;* OUT B: Garbage
;* OUT DE: Garbage
;* OUT HL: Pointing to the end of the string
;* Same as <code>strcat</code>, but has a maximum limit of added characters.

strncat: ; Args: HL DE A
  LD B, A
  PUSH DE
  EX DE, HL
  CALL strlen_again
  EX DE, HL
  POP DE
  DEC HL
  JP strncpy_again

;** strcat
;* IN DE: Source string
;* IN HL: Destination String
;* OUT A: Always zero
;* OUT DE: Pointing to the end of the string
;* OUT HL: Pointing to the end of the string
;* Concatenates one string to another.

strcat: ; Args: HL DE
  PUSH DE
  EX DE, HL
  CALL strlen_again
  EX DE, HL
  POP DE
  DEC HL
  JP strcpy_again

;** strcmp
;* IN DE: Source string 1
;* IN HL: Source string 2
;* OUT A: Garbage
;* OUT C: Garbage
;* OUT DE: Pointing to the end of the string it was given as argument + 1
;* OUT HL: $0000 if both strings were the same, $FFFF otherwise.
;* This function tests if two strings are equal.

strcmp:
  LD A, (DE)
  LD C, (HL)
  CP C
  JR NZ, strcmp_false
  INC DE
  INC HL
  OR A
  JR NZ, strcmp
strcmp_true:
  LD HL, $0000
  RET

strcmp_false:
  LD HL, $ffff
  RET

;** strncmp
;* Checks if the first X bytes of two strings are the same.
;* IN A: Number of bytes to test
;* IN DE: String 1
;* IN HL: String 2
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: $0000 if the first 'A' characters of both strings were the same, $FFFF otherwise.

strncmp:
  LD B, A
strncmp_loop:
  LD A, (DE)
  LD C, (HL)
  CP C
  JR NZ, strcmp_false
  INC DE
  INC HL
  OR A
  JR Z, strcmp_true
  DJNZ strncmp_loop
  JR strcmp_true

;** removebackn
;* Changes the first '\n' character in a string to an end-of-string character ('\0').
;* <b>NOTE</b>: make sure there is actually a '\n' character in the string !
;* IN HL: A string.
;* OUT A: Garbage
;* OUT HL: Location of the '\0' (previously '\n') character.

removebackn:
    LD A, '\n'
removebackn_loop:
    CP (HL)
    JR NZ, removebackn_next
    XOR A
    LD (HL), A
    RET
removebackn_next:
    INC HL
    JR removebackn_loop

