;*** startup.h

; Startup code, directly from the BZC headers.
; Not anymore these days btw.

.org $0000
    jp BOOT
.org $0008
    jp nextproc
.org $0010
    jp ldcode_rst
.org $0018
    jp INTERRUPT
.org $0020
    jp INTERRUPT
.org $0026
    nop
.org $0028
    jp INTERRUPT
.org $0030
    jp INTERRUPT
.org $0038
    jp INTERRUPT
.org $0053
    jp BOOT
.dw $A55A
.org $0064
.dw 0
.org $0066


;** BOOT
;* System execution starts here ($0066).

BOOT:
    di            ; Disable interrupts.
    ld sp, $0000  ; Initialise Stack.
    im 0          ; Disable all (internal) interrupts.

; Some default system i/o, thanks to Benjamin Moody
    xor a
    out (0),a   ; reset link
    dec a
    out (1),a   ; reset keypad
    ld a,$76
    out (4),a   ; standart int clock
    ld a,$41
    out (7),a   ; ram page 1 in bank 3
    in a,(2)
    and $80
    jr z,BootBE   ;Jump away if we are not the Silver Edition (or 84+ ?)

    ld a,$81
    out (7),a   ; ram page 1 in bank 3
    dec a
    out (8),a   ; reset dbus
    xor a
    out (8),a   ; enable dbus
    out (5),a   ; ram page 0 in bank 4
    out ($20),a   ; cpu clock
    ld a,$14
    out ($29),a   ; lcd clock
    xor a
    out ($30),a   ; clear timers
    out ($33),a
    out ($36),a
BootBE:

    xor a   ; Disabling all system interrupts.
    out ($03), A
    LD (timer_on), A

    CALL waitforLCD
    ld a, $18
    out ($10), a
    CALL waitforLCD
    ld a, $03   ; Turn on LCD.
    out ($10), a
    CALL waitforLCD
    ld a, $F0   ; Set contrast
    out ($10), a
    CALL waitforLCD
    ld a, $40   ; Top buffer = top screen.
    out ($10), a

    ld a, 1	; Set flash page 1 in bank 2.
    out (6), a
    ei
