;*** restrict.asm
; In this file, all restricted functions should reside.
; It is loaded into ROM page 1C

.org $4000    ; Flash is mapped to this address.


;** RomLock
;* Enables / disables flash-writing.
;* IN B: 0 to disable, 1 to enable.
;* OUT A: Garbage
RomLock:              ; (Un)Locks most ROM pages.
                      ; Thanks to Benjamin Moody

RomLock_0:
    LD A, I
    PUSH AF
    DI
    LD A, B
    NOP
    NOP
    IM 1
    DI
    OUT ($14), A
    POP AF
    RET PO
    EI
    RET

.org $7fff
    RST $38

.end
