; List of all Z80 opcode bit sequences (needed forprogram loading)

opcode1:

; Format: <data>, <bitmask>

.db %00000000, %11110111    ;0000x000
.db %00001001, %11001111    ;00xx1001
.db %00000010, %11100111    ;000xx010
.db %00000100, %11000110    ;00xxx10x
.db %00000011, %11000011    ;00xxxx11

.db %01000000, %11000000    ;01xxxxxx
.db %10000000, %11000000    ;10xxxxxx

.db %11100011, %11100111    ;111xx011
.db %11011001, %11011111    ;11x11001
.db %11001001, %11111111    ;11001001
.db %11000001, %11001011    ;11xx0x01
.db %11000000, %11000111    ;11xxx000
.db %11000111, %11000111    ;11xxx111

.db %00000000, %00000000

opcode2:

;format <data1> <data2> <bitmask1> <bitmask2>

.db %11101101, %10000000, %11111111, %10000000  ;11101101 : 1xxxxxxx
.db %11101101, %00000000, %11111111, %11000000  ;11101101 : 00xxxxxx
.db %11101101, %01000100, %11111111, %11000100  ;11101101 : 01xxx1xx
.db %11101101, %01000000, %11111111, %11000110  ;11101101 : 01xxx00x

.db %00000110, %00000000, %11000111, %00000000  ;00xxx110 : xxxxxxxx
.db %11000110, %00000000, %11000111, %00000000  ;11xxx110 : xxxxxxxx
.db %00100000, %00000000, %11100111, %00000000  ;001xx000 : xxxxxxxx
.db %00010000, %00000000, %11110111, %00000000  ;0001x000 : xxxxxxxx
.db %11010011, %00000000, %11110111, %00000000  ;1101x011 : xxxxxxxx

.db %11101011, %01000000, %11111111, %11000110  ;11101011 : 01xxx00x

.db %11011101, %00100011, %11011111, %11110111  ;11x11101 : 0010x011
.db %11011101, %11100001, %11011111, %11111101  ;11x11101 : 111000x1
.db %11011101, %11100101, %11011111, %11111111  ;11x11101 : 11100101
.db %11011101, %11111001, %11011111, %11111111  ;11x11101 : 11111001
.db %11011101, %00001001, %11011111, %11001111  ;11x11101 : 00xx1001

.db 0,0,0,0

opcode3:
.db %11001101, %00000000, %00000000, %11111111, %00000000, %00000000  ;11001101 : xxxxxxxx : xxxxxxxx
.db %11000011, %00000000, %00000000, %11111111, %00000000, %00000000  ;11000011 : xxxxxxxx : xxxxxxxx
.db %11000100, %00000000, %00000000, %11000111, %00000000, %00000000  ;11xxx100 : xxxxxxxx : xxxxxxxx
.db %11000010, %00000000, %00000000, %11000111, %00000000, %00000000  ;11xxx010 : xxxxxxxx : xxxxxxxx
.db %00100010, %00000000, %00000000, %11100111, %00000000, %00000000  ;001xx010 : xxxxxxxx : xxxxxxxx
.db %00000001, %00000000, %00000000, %11001111, %00000000, %00000000  ;00xx0001 : xxxxxxxx : xxxxxxxx

.db %11011101, %00110100, %00000000, %11011111, %11111110, %00000000  ;11x11101 : 0011010x : xxxxxxxx
.db %11011101, %10101110, %00000000, %11011111, %11111111, %00000000  ;11x11101 : 10101110 : xxxxxxxx
.db %11011101, %10100110, %00000000, %11011111, %11101111, %00000000  ;11x11101 : 101x0110 : xxxxxxxx
.db %11011101, %11011101, %00000000, %11011111, %11100111, %00000000  ;11x11101 : 100xx110 : xxxxxxxx
.db %11011101, %10111110, %00000000, %11011101, %11111111, %00000000  ;11x11101 : 10111110 : xxxxxxxx
.db %11011101, %01000110, %00000000, %11011111, %11000111, %00000000  ;11x11101 : 01xxx110 : xxxxxxxx
.db %11011101, %01110000, %00000000, %11011111, %11111000, %00000000  ;11x11101 : 01110xxx : xxxxxxxx

.db 0,0,0,0,0,0

opcode4:
.db %11101101, %01000011, %00000000, %00000000, %11111111, %11000111, %00000000, %00000000  ;11101101 : 01xxx011 : xxxxxxxx : xxxxxxxx

.db %11011101, %00110110, %00000000, %00000000, %11011111, %11111111, %00000000, %00000000  ;11x11101 : 00110110 : xxxxxxxx : xxxxxxxx
.db %11011101, %00100001, %00000000, %00000000, %11011111, %11111111, %00000000, %00000000  ;11x11101 : 00100001 : xxxxxxxx : xxxxxxxx
.db %11011101, %00100010, %00000000, %00000000, %11011111, %11110111, %00000000, %00000000  ;11x11101 : 0010x010 : xxxxxxxx : xxxxxxxx

.db %11011101, %11001011, %00000000, %00000000, %11011111, %11111111, %00000000, %11000000  ;11x11101 : 11001011 : xxxxxxxx : 00xxxaaa
.db %11011101, %11001011, %00000000, %01000110, %11011111, %11111111, %00000000, %11000111  ;11x11101 : 11001011 : xxxxxxxx : 01xxx110
.db %11011101, %11001011, %00000000, %10000000, %11011111, %11111111, %00000000, %10000000  ;11x11101 : 11001011 : xxxxxxxx : 1xxxxaaa

.db 0,0,0,0,0,0,0,0

; It seems my assembler is a bit buggy, so I use semi-colons instead of commas here.

loadpgm_imm16_opcodes_1:
.db $3A ; %00111010; LD A;(imm16)
.db $32 ; %00110010; LD (imm16); A
.db $2A ; %00101010; LD HL;(imm16)
.db $22 ; %00100010; LD (imm16); HL
.db $00

loadpgm_imm16_opcodes_2:
.db $DD, $21  ; %11011101; %00100001; LD IX;imm16
.db $FD, $21  ; %11111101; %00100001; LD IY;imm16

.db $ED, $4B  ; %11101101; %01001011; LD BC;(imm16)
.db $ED, $5B  ; %11101101; %01011011; LD DE;(imm16)
.db $ED, $6B  ; %11101101; %01101011; LD HL;(imm16)
.db $ED, $7B  ; %11101101; %01111011; LD SP;(imm16)

.db $DD, $2A  ; %11011101; %00101010; LD IX;(imm16)
.db $FD, $2A  ; %11111101; %00101010; LD IY;(imm16)

.db $ED, $43  ; %11101101; %01000011; LD (imm16); BC
.db $ED, $53  ; %11101101; %01010011; LD (imm16); DE
.db $ED, $63  ; %11101101; %01100011; LD (imm16); HL
.db $ED, $73  ; %11101101; %01110011; LD (imm16); SP

.db $DD, $22  ; %11011101; %00100010; LD (imm16); IX
.db $FD, $22  ; %11111101; %00100010; LD (imm16); IY
.db $00

