;*** lcd.h

;** quickwaitforLCD
;* These days exactly the same as <code>quickbusywaitforLCD</code>.
;* OUT A: Garbage
quickwaitforLCD:

;** quickbusywaitforLCD
;* Busy-waits for the LCD driver IC to become ready.
;* OUT A: Garbage
quickbusywaitforLCD:
    IN A, ($10)
    BIT 7, A
    JR NZ, quickwaitforLCD
    RET

;** waitforLCD
;* These days exactly the same as <code>busywaitforLCD</code>.
waitforLCD:

;** busywaitforLCD
;* Busy-waits for the LCD driver IC to become ready, but preserves A
busywaitforLCD:
    PUSH AF
    CALL quickbusywaitforLCD
    POP AF
    RET

;** quickwaitforLCD_old
;* WILL BE REMOVED!
;* Waits until the LCD driver IC is ready, task-switches if not.
;* OUT A: Garbage.
quickwaitforLCD_old:    ; Used when multitasking.
    IN A, ($10)
    BIT 7, A
    RET Z
    LD A, (multitasking)    ; Needed for use before the process manager is up.
    OR A
    JP Z, quickwaitforLCD
    CALL nextproc           ; FIXME: Probably to slow, change to (quick)busywaitforLCD in the future?
    JP quickwaitforLCD

;** waitforLCD_old
;* WILL BE REMOVED!
;* Same as <code>quickwaitforLCD_old</code>, but preserves A.
waitforLCD_old:
    PUSH AF
    CALL quickwaitforLCD
    POP AF
    RET


;** cls
;* Clears the LCD screen by hardware. You probably want to use <code>clrscrn</code>.
;* OUT A: Always 48
;* OUT B: Always zero
;* OUT D: Always 48
cls:
    CALL lock_screen
    CALL quickwaitforLCD
    LD A, $01
    OUT ($10), A
    CALL quickwaitforLCD
    LD A, $05
    OUT ($10), A
    CALL quickwaitforLCD
    LD A, $80
    OUT ($10), A
    LD D, $20
    LD A, $20
cls_again2:
    CALL waitforLCD
    OUT ($10), A
    LD B, 64
cls_again:
    CALL quickwaitforLCD
    XOR A
    OUT ($11), A
    DJNZ cls_again
    INC D
    LD A, D
    CP $30
    JP NZ, cls_again2
    JP release_screen

;** locate
;* IN D: Row (starting at 0)
;* IN E: Column (starting at 0)
;* Description locate is used by the screen-manager the set the position of the next character that will be written
;* to the LCD display. Because of the screen manager, you should use <code>setscrnloc</code> instead.
locate:
    LD (location), DE
    RET


;** puts
;* IN HL: Pointer to a string.
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Prints a text-string to the LCD display, under normal circumstances you should use <code>printstr</code> instead.

puts:
    JR puts_go
puts_start:
    CALL putc_start
    POP HL
puts_go:
    LD A, (HL)
    INC HL
    PUSH HL
    CP 0
    JR NZ, puts_start
    POP HL
    RET

;** putc
;* IN A: Character to display.
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Prints a singe character to the LCD display. Under normal circumstances you should use <code>printc</code> instead.

putc:
putc_start:
    CP 0
    RET Z

    ; Check for special character:
    CP 10
    JP Z, putc_spec
    CP 13
    JP Z, putc_spec
    CP 11
    JP Z, putc_locate

    PUSH AF
    CALL lock_screen
    CALL quickwaitforLCD
    XOR A
    OUT ($10), A
    CALL quickwaitforLCD
    LD A, $05
    OUT ($10), A
    LD BC, (location)
    LD A, B
    ADD A, A
    ADD A, A
    ADD A, B
    ADD A, B
    ADD A, $80
    CALL waitforLCD
    OUT ($10), A
    LD A, C
    ADD A, $20
    CALL waitforLCD
    OUT ($10), A
    INC C
    LD A, C
    CP 16
    JP NZ, putc_cont
    LD C, 0
    INC B
    LD A, B
    CP 10
    JP NZ, putc_cont
    LD B, 0

putc_cont:  ; Let's find the character...
    LD (location), BC
    LD HL, font
    POP BC
    DEC B
    JP Z, putc_send
    LD DE, $6
putc_again:
    ADD HL, DE
    DJNZ putc_again

putc_send:
    LD B, 6

putc_sendbyte:
    CALL quickwaitforLCD
    LD A, (HL)
    OUT ($11), A
    INC HL
    DJNZ putc_sendbyte
    JP release_screen

putc_spec:
    LD BC, (location)
    LD C, 0
    CP 10
    JR NZ, putc_spec_cont
    INC B
putc_spec_cont:
    LD (location), BC
    RET

putc_locate:
    LD DE, $0000
    JP locate
