;*** keypad.h
; Keypad.h - Used to translate keys to ascii characters.

          ; Since we aren't using ascii > 127, we use
          ; The characters beyond here for arrows, etc.
          ; This is at least temporarely.


; Definitions first:

; Special keys in ascii:

; BAOS special.

ASCF1:      .equ  128
ASCF2:      .equ  129
ASCF3:      .equ  130
ASCF4:      .equ  131
ASCF5:      .equ  132

ASCDown:    .equ  133
ASCLeft:    .equ  134
ASCRight:   .equ  135
ASCUp:      .equ  136

ASCMode:    .equ  137
ASCStat:    .equ  138
ASCVars:    .equ  139

; Always.

ASCDel:     .equ  127
ASCBackspc: .equ  8
ASCSpace:   .equ  ' '
ASCSpc:     .equ  ' '
ASCEnter:   .equ  10


; Now the keys....

; Normal:

KeyModes:

.dw   KeyModeNormal, KeyModeShift, KeyModeAlpha, KeyModeAlphaShift

KeyModeNormal:

.db   ASCF5,    ASCF4,     ASCF3,    ASCF2,     ASCF1,     0,       ASCMode,    ASCDel
.db   0,        'x',       's',      'n',       'i',       'd',     'a',        0
.db   ' ',      'y',       't',      'o',       'j',       'e',     'b',        'X'
.db   ':',      'z',       'u',      'p',       'k',       'f',     'c',        ASCStat
.db   '?',      '@',       'v',      'q',       'l',       'g',     ASCVars,    0
.db   ASCEnter, '"',       'w',      'r',       'm',       'h',     ASCBackspc, 0
.db   ASCDown,  ASCLeft,   ASCRight, ASCUp,     0,         0,       0,          0

KeyModeShift:

.db   ASCF5,    ASCF4,     ASCF3,    ASCF2,     ASCF1,     0,       ASCMode,    ASCDel
.db   0,        'X',       'S',      'N',       'I',       'D',     'A',        0
.db   ' ',      'Y',       'T',      'O',       'J',       'E',     'B',        'X'
.db   ':',      'Z',       'U',      'P',       'K',       'F',     'C',        ASCStat
.db   '?',      '@',       'V',      'Q',       'L',       'G',     ASCVars,    0
.db   ASCEnter, '"',       'W',      'R',       'M',       'H',     ASCBackspc, 0
.db   ASCDown,  ASCLeft,   ASCRight, ASCUp,     0,         0,       0,          0

KeyModeAlpha:

.db   ASCF5,    ASCF4,     ASCF3,    ASCF2,     ASCF1,     0,       ASCMode,    ASCDel
.db   0,        'x',       's',      'n',       'i',       'd',     'a',        0
.db   '0',      '1',       '4',      '7',       ',',       'e',     'b',        'X'
.db   '.',      '2',       '5',      '8',       '(',       'f',     'c',        ASCStat
.db   '-',      '3',       '6',      '9',       ')',       'g',     ASCVars,    0
.db   ASCEnter, '+',       '-',      '*',       '/',       '^',     ASCBackspc, 0
.db   ASCDown,  ASCLeft,   ASCRight, ASCUp,     0,         0,       0,          0

KeyModeAlphaShift:

.db   ASCF5,    ASCF4,     ASCF3,    ASCF2,     ASCF1,     0,       ASCMode,    ASCDel
.db   0,        'X',       'S',      'N',       'I',       'D',     'A',        0
.db   '0',      '1',       '4',      '7',       ',',       'E',     'B',        'X'
.db   '.',      '2',       '5',      '8',       '(',       'F',     'C',        ASCStat
.db   '-',      '3',       '6',      '9',       ')',       'G',     ASCVars,    0
.db   ASCEnter, '+',       '-',      '*',       '/',       '^',     ASCBackspc, 0
.db   ASCDown,  ASCLeft,   ASCRight, ASCUp,     0,         0,       0,          0


;** inkey
;* OUT A: ASCII value of pressed key (or zero when no key was pressed)
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* This function return the ascii code of the key currently pressed on the keypad, or a zero if no key was pressed.
;* Special keys will return a non-printable character between 128 and 255. All characters above 127 are not conform ascii.

inkey:    ; Inkey, get an ascii character from the keypad.

    ; We should not use input if we are not on our screen.

    LD A, (curscrn)
    LD B, A
    LD A, (myscrn)
    CP B
    JR Z, sysinkey
    XOR A	; Pretent that no key was pressed when we are not on this screen.
    RET

;** sysinkey
;* OUT A: ASCII value of pressed key (or zero when no key was pressed)
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* This function return the ascii code of the key currently pressed on the keypad, or a zero if no key was pressed.
;* Special keys will return a non-printable character between 128 and 255. All characters above 127 are not conform ascii.
;* WARNING: This function is system-wide and will also return values if the virtual screen your program is running on is
;* currently <b>NOT</B> selected.

sysinkey:

    ; We first need to check if 2nd and/or alpha is pressed...

    LD HL, KeyModes
    LD A, $BF
    OUT (1), A
    NOP
    NOP
    IN A, (1)
    BIT 5, A    ; Check for 2nd
    JR NZ, inkey_alpha
    INC HL
    INC HL
inkey_alpha:
    LD A, $DF
    OUT (1), A
    NOP
    NOP
    IN A, (1)
    BIT 7, A    ; And for alpha
    JR NZ, inkey_cont
    INC HL
    INC HL
    INC HL
    INC HL
inkey_cont:
    LD E, (HL)
    INC HL
    LD D, (HL)
    EX DE, HL
    LD C, $BF

inkey_loop:
    LD A, C
    OUT (1), A
    NOP
    NOP
    IN A, (1)
    LD D, A
    LD B, 0

inkey_inner_loop:
    LD A, D
    INC B
    AND B
    JR NZ, inkey_inner_cont
    XOR A
    OR (HL)
    RET NZ
inkey_inner_cont:
    INC HL
    RLC B
    DJNZ inkey_inner_loop
    RRC C
    LD A, $7F
    SUB C
    RET Z           ; No keys were pressed...
    JR inkey_loop

;** waitnokey
;* OUT A: Always Zero.
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Garbage
;* Waits until all keys are released.

waitnokey:
    CALL inkey
    OR A
    JR NZ, waitnokey
    RET
