;*** flashram.h
; This is the flash driver for BAOS.
; Most of it is directly ported from the BZC header files.

; WARNING: MOST OF THE CODE BELOW SHOULD BE EXECUTED FROM RAM
;          TO PREVENT INVALID FLASH-DRIVER COMMANDS !!!


.org $8000

flash_ram_begin: .equ $

#include "vars.h"


;** byteRDY
;* IN A: Value that is written
;* IN DE: Byte that is written
;* OUT A: Is always $F0
;* OUT DE: Byte that is written
;* OUT HL: $0000 on success, $FFFF on failure.
;* Waits until byte DE of the current flash page is ready writing value A to itself.

byteRDY:          ; Checks wheter byte DE of current page is ready writing
                  ; Needs A as "byte to write".
    LD HL, $0000
    PUSH BC
                  ; Thanks to Benjamin Moody
    AND $80
    LD B, A
byteRDY_loop:
    LD A, (DE)
    XOR B
    JP P, byteRDY_exit
    BIT 5, A
    JR Z, byteRDY_loop
    LD A, (DE)    ; Recheck, to be sure (AMD recommands)
    XOR B
    JP P, byteRDY_exit
    LD HL, $FFFF  ; EXIT_FAILURE

byteRDY_exit:
    POP BC
    LD A, $F0 ; RESET the chip
    OUT (0), A
    EI
    RET

;** writeblk
;* IN DE: Destination block (in flash-driver format, see also the OS Documentation page)
;* IN HL: Pointer to data.
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: $FFFF on failure, pointer to end of data (source) on success.
;* Writes 1 block of data to the flash.

writeblk:
    LD A, D
    LD C, A       ; Save the needed page for later.
    OUT (6), A
    LD D, 0
    EX DE, HL
    ADD HL, HL ; 2
    ADD HL, HL ; 4
    ADD HL, HL ; 8
    ADD HL, HL ; 16
    ADD HL, HL ; 32
    ADD HL, HL ; 64
    PUSH DE
    LD DE, $4000
    ADD HL, DE
    POP DE
    EX DE, HL
writeblk_start:
    LD B, 64
writeblk_loop:
    DI
    LD A, $F0 ; RESET the chip
    OUT (0), A
    LD A, 2 ; <AA>
    OUT (6), A
    LD A, $AA
    LD ($6AAA), A
    LD A, 1 ; <55>
    OUT (6), A
    LD A, $55
    LD ($5555), A
    LD A, 2 ; [A0]
    OUT (6), A
    LD A, $A0
    LD ($6AAA), A
    LD A, C ; Write the byte.
    OUT (6), A
    LD A, (HL)
    LD (DE), A
    PUSH HL
    CALL byteRDY
    LD A, H ; Check for errors
    CP $ff
    JR Z, writeblk_exit

    POP HL

    ; Give other processes a chance:
    ;RST $08   ; (CALL nextproc)

    INC HL
    INC DE
    DJNZ writeblk_loop
    RET

writeblk_exit:
    POP DE
    RET

;** clrSec
;* IN B: Sector to Erease
;* OUT A: Always $F0
;* OUT B: Garbage
;* OUT DE: Garbage
;* OUT HL: Zero on success, $FFFF on failure.
;* Ereases one flash sector to $FF.
;* However, important sectors are protected.
;* If you put a zero into the variable <code>FlashProtMode</code>, only sector 7 is not ereasable.


clrSec:
    LD A, (FlashProtMode)
    OR A
    LD A, B
    JR Z, clrSec_noprot
    OR A
    JR Z, clrsec_illegal
    CP 5
    JR Z, clrsec_illegal
clrsec_noprot:
    CP 7
    JR NC, clrsec_illegal
    ADD A, A  ; 2
    ADD A, A  ; 4 pages a sector.
    LD B, A
    DI
    LD A, $F0 ; RESET the chip
    OUT (0), A
    LD A, 2 ; <AA>
    OUT (6), A
    LD A, $AA
    LD ($6AAA), A
    LD A, 1 ; <55>
    OUT (6), A
    LD A, $55
    LD ($5555), A
    LD A, 2 ; [80]
    OUT (6), A
    LD A, $80
    LD ($6AAA), A
    LD A, $AA ; <AA>
    LD ($6AAA), A
    LD A, 1 ; <55>
    OUT (6), A
    LD A, $55
    LD ($5555), A
    LD A, B ; (30)
    OUT (6), A
    LD A, $30
    LD ($4000), A
    LD A, $FF ; Check for finished
    LD DE, $4000
    JP byteRDY
clrsec_illegal:
    LD HL, $FFFF
    RET

Zero:
.db 0

.end
