;*** errcheck.h

;** save_calloc
;* IN A: Amount of needed bytes.
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Pointer to memory
;* Only needed by the OS. It calls <code>calloc</code> and if for whatever reason the system is unable to allocate memory
;* while it needs to set up critical services it displays a message and just halts (you should remove the batteries and reboot).

save_calloc:
    CALL calloc
    JR save_malloc_cont

save_pgmalloc:
    CALL pgmalloc
    JP save_malloc_cont

;** save_malloc
;* IN A: Amount of needed bytes.
;* OUT A: Garbage
;* OUT BC: Garbage
;* OUT DE: Garbage
;* OUT HL: Pointer to memory
;* Only needed by the OS. It calls <code>malloc</code> and if for whatever reason the system is unable to allocate memory
;* while it needs to set up critical services it displays a message and just halts (you should remove the batteries and reboot).

save_malloc:
    CALL malloc
save_malloc_cont:
    LD A, H
    OR L
    JP Z, save_malloc_error
    RET

save_malloc_error:
    LD HL, save_malloc_msg
    LD A, (os_stage)
    CP 2
    JR Z, save_malloc_printstr
    CALL puts
    JP halt

save_malloc_printstr:
    CALL printstr
    JP halt

save_malloc_msg:
.db "Memory Alloc.\nError", 0

