;*** debug.h

#include "userspc/debug.inc"

;** debug_wait
;* Executes HALT 200 times. Operation time depends on whether multitasking is on.
;* All registers keep their values. Never call this function when interrupts are disabled!
debug_wait:
    PUSH BC
    LD B, 200
debug_wait_loop:
    HALT
    DJNZ debug_wait_loop
    POP BC
    RET

;** debug_printstr
;* Calls <code>printstr</code> but saves all registers.

debug_printstr:
    PUSH AF
    PUSH BC
    PUSH DE
    CALL printstr
    POP DE
    POP BC
    POP AF
    RET

;** debug_puts
;* Calls <code>puts</code> but saves all registers.

debug_puts:
    PUSH AF
    PUSH BC
    PUSH DE
    CALL puts
    POP DE
    POP BC
    POP AF
    RET

;** debug_print_hl
;* Prints the number stored in register HL and goes to the next line. No register is touched while doing this.

debug_print_hl:
    PUSH AF
    PUSH BC
    PUSH DE
    PUSH HL
    CALL printhl
    CALL newline
    POP HL
    POP DE
    POP BC
    POP AF
    RET

;** debug_print_hlhex
;* Prints the hexadecimal number stored in register HL and goes to the next line. No register is touched while doing this.

debug_print_hlhex:
    PUSH AF
    PUSH BC
    PUSH DE
    PUSH HL
    CALL printhlhex
    CALL newline
    POP HL
    POP DE
    POP BC
    POP AF
    RET

;** debug_print_a
;* Prints the number stored in register A and goes to the next line. No register is touched while doing this.

debug_print_a:
    PUSH AF
    PUSH BC
    PUSH DE
    PUSH HL
    LD H, 0
    LD L, A
    CALL printhl
    CALL newline
    POP HL
    POP DE
    POP BC
    POP AF
    RET

;** debug_print_ahex
;* Prints the hexadecimal number stored in register A and goes to the next line. No register is touched while doing this.

debug_print_ahex:
    PUSH AF
    PUSH BC
    PUSH DE
    PUSH HL
    LD H, 0
    LD L, A
    CALL printhlhex
    CALL newline
    POP HL
    POP DE
    POP BC
    POP AF
    RET

