@echo off
cls
echo * Cleaning up...

del /f /q baos.rom
del /f /q baos.sym
del /f /q baos.8xu

cd src

del /f /q flash.h > nul
del /f /q baos.hex > nul
del /f /q base.hex > nul
del /f /q baos.rom > nul
del /f /q base.bin > nul
del /f /q flashram.bin > nul
del /f /q baos.inc > nul
del /f /q baos.sym > nul
del /f /q restrict.hex > nul
del /f /q restrict.bin > nul
del /f /q restrict.h > nul
del /f /q baos.8xu > nul
del /f /q tilem.1.patch > nul
del /f /q tilem.2.patch > nul

del /f /q userspc\*.h > nul
del /f /q userspc\*.bin > nul
del /f /q userspc\*.bin.inc > nul
del /f /q userspc\baos.inc > nul

cls
echo * Cleaning up...
echo * Patching...
echo. > tilem.1.patch
echo. > tilem.2.patch
cd userspc

echo * (phase 1): Generating an empty userspace programs list...
..\tools\genusph userspc.in userspc.h --noincludes

cd ..

echo * (Phase 1): Assembling restricted section...
tools\z80asm restrict.asm -o restrict.bin -Lrestrict.h
echo * (Phase 1): Creating .hex file...
tools\bin2hex restrict 4000 > nul
echo * (Phase 1): Assembling flash-driver RAM-section...
tools\z80asm flashram.h -o flashram.bin -Lmemlocs.h
echo * (Phase 1): Generating flash-driver source (flash.h)...
tools\bin2h flashram.bin flash.h
echo * (Phase 1): Assembling base OS...
tools\z80asm base.asm -o base.bin -Lbaos.inc
echo * (Phase 1): Publishing OS-include file...
copy baos.inc userspc\baos.inc > nul

cd userspc

echo * (Phase 2): Generating a list of all userspace programs...
del /f /q userspc.h
..\tools\genusph userspc.in userspc.h

echo * (Phase 2): Assembling userspace programs: demo.asm...
..\tools\z80asm demo.asm -o demo.bin -Ldemo.bin.inc
rem    - Generating header file: demo.h...
..\tools\bin2h demo.bin demo.h
echo * (Phase 2): Assembling userspace programs: fs.asm...
..\tools\z80asm fs.asm -o fs.bin -Lfs.bin.inc
rem    - Generating header file: fs.h...
..\tools\bin2h fs.bin fs.h
echo * (Phase 2): Assembling userspace programs: test.asm...
..\tools\z80asm test.asm -o test.bin -Ltest.bin.inc
rem    - Generating header file: test.h...
..\tools\bin2h test.bin test.h
echo * (Phase 2): Assembling userspace programs: echo.asm...
..\tools\z80asm echo.asm -o echo.bin -Lecho.bin.inc
rem    - Generating header file: echo.h...
..\tools\bin2h echo.bin echo.h
echo * (Phase 2): Assembling userspace programs: recv.asm...
..\tools\z80asm recv.asm -o recv.bin -Lrecv.bin.inc
rem    - Generating header file: recv.h...
..\tools\bin2h recv.bin recv.h
echo * (Phase 2): Assembling userspace programs: iic.asm...
..\tools\z80asm iic.asm -o iic.bin -Liic.bin.inc
rem    - Generating header file: iic.h...
..\tools\bin2h iic.bin iic.h
echo * (Phase 2): Assembling userspace programs: init.asm...
..\tools\z80asm init.asm -o init.bin -Linit.bin.inc
rem    - Generating header file: init.h...
..\tools\bin2h init.bin init.h
echo * (Phase 2): Assembling userspace programs: firstrun.asm...
..\tools\z80asm firstrun.asm -o firstrun.bin -Lfirstrun.bin.inc
rem    - Generating header file: firstrun.h...
..\tools\bin2h firstrun.bin firstrun.h
echo * (Phase 2): Assembling userspace programs: sh.asm...
..\tools\z80asm sh.asm -o sh.bin -Lsh.bin.inc
rem    - Generating header file: sh.h...
..\tools\bin2h sh.bin sh.h
echo * (Phase 2): Assembling userspace programs: halt.asm...
..\tools\z80asm halt.asm -o halt.bin -Lhalt.bin.inc
rem    - Generating header file: halt.h...
..\tools\bin2h halt.bin halt.h
echo * (Phase 2): Assembling userspace programs: sleep.asm...
..\tools\z80asm sleep.asm -o sleep.bin -Lsleep.bin.inc
rem    - Generating header file: sleep.h...
..\tools\bin2h sleep.bin sleep.h
echo * (Phase 2): Assembling userspace programs: reboot.asm...
..\tools\z80asm reboot.asm -o reboot.bin -Lreboot.bin.inc
rem    - Generating header file: reboot.h...
..\tools\bin2h reboot.bin reboot.h
echo * (Phase 2): Assembling userspace programs: cp.asm...
..\tools\z80asm cp.asm -o cp.bin -Lcp.bin.inc
rem    - Generating header file: cp.h...
..\tools\bin2h cp.bin cp.h
echo * (Phase 2): Assembling userspace programs: rm.asm...
..\tools\z80asm rm.asm -o rm.bin -Lrm.bin.inc
rem    - Generating header file: rm.h...
..\tools\bin2h rm.bin rm.h
echo * (Phase 2): Assembling userspace programs: mkdir.asm...
..\tools\z80asm mkdir.asm -o mkdir.bin -Lmkdir.bin.inc
rem    - Generating header file: mkdir.h...
..\tools\bin2h mkdir.bin mkdir.h
echo * (Phase 2): Assembling userspace programs: cd.asm...
..\tools\z80asm cd.asm -o cd.bin -Lcd.bin.inc
rem    - Generating header file: cd.h...
..\tools\bin2h cd.bin cd.h
echo * (Phase 2): Assembling userspace programs: ls.asm...
..\tools\z80asm ls.asm -o ls.bin -Lls.bin.inc
rem    - Generating header file: ls.h...
..\tools\bin2h ls.bin ls.h
echo * (Phase 2): Assembling userspace programs: edit.asm...
..\tools\z80asm edit.asm -o edit.bin -Ledit.bin.inc
rem    - Generating header file: edit.h...
..\tools\bin2h edit.bin edit.h
echo * (Phase 2): Assembling userspace programs: ps.asm...
..\tools\z80asm ps.asm -o ps.bin -Lps.bin.inc
rem    - Generating header file: ps.h...
..\tools\bin2h ps.bin ps.h
echo * (Phase 2): Assembling userspace programs: fsmap.asm...
..\tools\z80asm fsmap.asm -o fsmap.bin -Lfsmap.bin.inc
rem    - Generating header file: fsmap.h...
..\tools\bin2h fsmap.bin fsmap.h
echo * (Phase 2): Assembling userspace programs: inittab.asm...
..\tools\z80asm inittab.asm -o inittab.bin -Linittab.bin.inc
rem    - Generating header file: inittab.h...
..\tools\bin2h inittab.bin inittab.h
echo * (Phase 2): Assembling userspace programs: Third party programs...


rem ***** PUT HERE YOU'RE OWN PROGRAMS ******
rem * Use the following template:
rem * Remove "rem", and change "[FILE.*]"
rem * Remember to put the same further below.

rem ..\tools\z80asm [FILE.asm] -o [FILE.bin]
rem ..\tools\bin2h [FILE.bin] [FILE.h]







cd ..

echo * (Phase 2): Linking userspace programs into base OS...
tools\z80asm base.asm -o base.bin -Lbaos.inc
echo * (Phase 2): Updating OS-include file...
del /f /q userspc\baos.inc
copy baos.inc userspc\baos.inc > nul

cd userspc

echo * (Phase 3): Assembling userspace programs: demo.asm...
..\tools\z80asm demo.asm -o demo.bin -Ldemo.bin.inc
rem    - Generating header file: demo.h...
..\tools\bin2h demo.bin demo.h
echo * (Phase 3): Assembling userspace programs: fs.asm...
..\tools\z80asm fs.asm -o fs.bin -Lfs.bin.inc
rem    - Generating header file: fs.h...
..\tools\bin2h fs.bin fs.h
echo * (Phase 3): Assembling userspace programs: test.asm...
..\tools\z80asm test.asm -o test.bin -Ltest.bin.inc
rem    - Generating header file: test.h...
..\tools\bin2h test.bin test.h
echo * (Phase 3): Assembling userspace programs: echo.asm...
..\tools\z80asm echo.asm -o echo.bin -Lecho.bin.inc
rem    - Generating header file: echo.h...
..\tools\bin2h echo.bin echo.h
echo * (Phase 3): Assembling userspace programs: recv.asm...
..\tools\z80asm recv.asm -o recv.bin -Lrecv.bin.inc
rem    - Generating header file: recv.h...
..\tools\bin2h recv.bin recv.h
echo * (Phase 3): Assembling userspace programs: iic.asm...
..\tools\z80asm iic.asm -o iic.bin -Liic.bin.inc
rem    - Generating header file: iic.h...
..\tools\bin2h iic.bin iic.h
echo * (Phase 3): Assembling userspace programs: init.asm...
..\tools\z80asm init.asm -o init.bin -Linit.bin.inc
rem    - Generating header file: init.h...
..\tools\bin2h init.bin init.h
echo * (Phase 3): Assembling userspace programs: firstrun.asm...
..\tools\z80asm firstrun.asm -o firstrun.bin -Lfirstrun.bin.inc
rem    - Generating header file: firstrun.h...
..\tools\bin2h firstrun.bin firstrun.h
echo * (Phase 3): Assembling userspace programs: sh.asm...
..\tools\z80asm sh.asm -o sh.bin -Lsh.bin.inc
rem    - Generating header file: sh.h...
..\tools\bin2h sh.bin sh.h
echo * (Phase 3): Assembling userspace programs: halt.asm...
..\tools\z80asm halt.asm -o halt.bin -Lhalt.bin.inc
rem    - Generating header file: halt.h...
..\tools\bin2h halt.bin halt.h
echo * (Phase 3): Assembling userspace programs: sleep.asm...
..\tools\z80asm sleep.asm -o sleep.bin -Lsleep.bin.inc
rem    - Generating header file: sleep.h...
..\tools\bin2h sleep.bin sleep.h
echo * (Phase 3): Assembling userspace programs: reboot.asm...
..\tools\z80asm reboot.asm -o reboot.bin -Lreboot.bin.inc
rem    - Generating header file: reboot.h...
..\tools\bin2h reboot.bin reboot.h
echo * (Phase 3): Assembling userspace programs: cp.asm...
..\tools\z80asm cp.asm -o cp.bin -Lcp.bin.inc
rem    - Generating header file: cp.h...
..\tools\bin2h cp.bin cp.h
echo * (Phase 3): Assembling userspace programs: rm.asm...
..\tools\z80asm rm.asm -o rm.bin -Lrm.bin.inc
rem    - Generating header file: rm.h...
..\tools\bin2h rm.bin rm.h
echo * (Phase 3): Assembling userspace programs: mkdir.asm...
..\tools\z80asm mkdir.asm -o mkdir.bin -Lmkdir.bin.inc
rem    - Generating header file: mkdir.h...
..\tools\bin2h mkdir.bin mkdir.h
echo * (Phase 3): Assembling userspace programs: cd.asm...
..\tools\z80asm cd.asm -o cd.bin -Lcd.bin.inc
rem    - Generating header file: cd.h...
..\tools\bin2h cd.bin cd.h
echo * (Phase 3): Assembling userspace programs: ls.asm...
..\tools\z80asm ls.asm -o ls.bin -Lls.bin.inc
rem    - Generating header file: ls.h...
..\tools\bin2h ls.bin ls.h
echo * (Phase 3): Assembling userspace programs: edit.asm...
..\tools\z80asm edit.asm -o edit.bin -Ledit.bin.inc
rem    - Generating header file: edit.h...
..\tools\bin2h edit.bin edit.h
echo * (Phase 3): Assembling userspace programs: ps.asm...
..\tools\z80asm ps.asm -o ps.bin -Lps.bin.inc
rem    - Generating header file: ps.h...
..\tools\bin2h ps.bin ps.h
echo * (Phase 3): Assembling userspace programs: fsmap.asm...
..\tools\z80asm fsmap.asm -o fsmap.bin -Lfsmap.bin.inc
rem    - Generating header file: fsmap.h...
..\tools\bin2h fsmap.bin fsmap.h
echo * (Phase 3): Assembling userspace programs: inittab.asm...
..\tools\z80asm inittab.asm -o inittab.bin -Linittab.bin.inc
rem    - Generating header file: inittab.h...
..\tools\bin2h inittab.bin inittab.h

echo * (Phase 3): Assembling userspace programs: Third party programs...


rem ***** PUT HERE YOU'RE OWN PROGRAMS ******
rem * See somewhere above for more information.





cd ..

echo * (Phase 3): Relinking userspace programs into base OS...
tools\z80asm base.asm -o base.bin -Lbaos.inc
echo * (Phase 3): Updating OS-include file...
del /f /q userspc\baos.inc
copy baos.inc userspc\baos.inc > nul

echo * (Phase 4): Creating Base OS .hex file...
tools\bin2hex base 0 > nul
echo * (Phase 4): Creating Master .hex file...
tools\multihex 0 base.hex 1c restrict.hex | tools\encdos baos.hex
echo * (Phase 4): Creating symbol file...
tools\gensyms
echo * (Phase 4): Creating emulator rom image...
copy clean.rom baos.rom > nul
tools\rompatch baos.rom baos.hex
echo * (Phase 4): Creating TI-83+ OS file...
tools\packxxu -v 9.99 -h 255 baos.hex -t 83p -o baos.8xu
echo.
echo Copying files...
copy baos.8xu ..\ > nul
copy baos.rom ..\ > nul
copy baos.sym ..\ > nul
echo.
echo Done building BAOS, press any key to exit.
pause > nul
cd ..

