;===============================================================;
;                                                               ;
; Alien Breed 5                                                 ;
; Variable definitions                                          ;
;                                                               ;
;===============================================================;

;------------------------------------------------------------------------------
; Variable Name                  Location       Size    Description
;------------------------------------------------------------------------------
difficulty                      = vars+000      ; 1     game difficulty
frame                           = vars+001      ; 1     frame counter
levelFilesPtr                   = vars+002      ; 2     pointer to start of compressed level files
level                           = vars+004      ; 1     current level number
levelWidth                      = vars+005      ; 1     level width (in blocks)
levelHeight                     = vars+006      ; 1     level height (in blocks)
levelFlags                      = vars+007      ; 1     level flags
objectives                      = vars+008      ; 1     objectives counter
time                            = vars+009      ; 1     countdown timer
startX                          = vars+010      ; 1     player x start
startY                          = vars+011      ; 1     player y start
finishX                         = vars+012      ; 1     player x finish
finishY                         = vars+013      ; 1     player y finish
bossTileOffset                  = vars+014      ; 2     offset to location in tile data of block to put at start of boss fight
bossTileType                    = vars+016      ; 1     block to put at start of boss fight type
destructTileOffset              = vars+017      ; 2     offset to location in tile data of block to put at start of destruct sequence
destructTileType                = vars+019      ; 1     block to put at start of destruct sequence type
enemy1                          = vars+020      ; 1     enemy 1 data (bits 0-4 = type; bits 5-7 = level)
enemy2                          = vars+021      ; 1     enemy 2 data
boss                            = vars+022      ; 1     boss data (bits 0-2 = type; bits 3-5 = level)
tileDataPtr                     = vars+023      ; 2     pointer to start of uncompressed tile data
state                           = vars+025      ; 1     game state: 0 = normal, 1 = boss
screenX                         = vars+026      ; 2     absolute x coord of top left pixel on screen
screenY                         = vars+028      ; 2     absolute y coord of top left pixel on screen
playerX                         = vars+030      ; 2     absolute x coord of player
playerY                         = vars+032      ; 2     absolute y coord of player
tempX                           = vars+034      ; 2     temp storage
tempY                           = vars+036      ; 2     temp storage
scrollBits                      = vars+038      ; 1     used in scrolling routines
scrollSkip                      = vars+039      ; 2     used in scrolling routines
scrollMask                      = vars+041      ; 1     used in scrolling routines
scrollPtr                       = vars+042      ; 2     used in scrolling routines
playerInv                       = vars+044      ; 1     player invincibility counter
playerDead                      = vars+045      ; 1     player dead counter
playerDir                       = vars+046      ; 1     player direction
keys                            = vars+047      ; 1     player key passes
ammo                            = vars+048      ; 2     player ammo
health                          = vars+050      ; 1     player health
lives                           = vars+051      ; 1     player lives
credits                         = vars+052      ; 2     player credits
score                           = vars+054      ; 2     player score
weapon                          = vars+056      ; 1     current weapon player is using
weaponTable                     = vars+057      ; 1     which weapons player has (bit flags)
showHLBuffer                    = vars+058      ; 6     string buffer for showHL routine
bulletTable                     = vars+064      ; 56    player bullets, 8 entries [type, direction, x{2}, y{2}, special]
animTable                       = vars+120      ; 30    animations, 5 entries [counter, type, x{2}, y{2}]
enemyTable                      = vars+150      ; 90    enemies, 10 entries [type, direction, x{2}, y{2}, counter, health, speed count]
collideObject1                  = vars+240      ; 6     collision detection object 1 [x{2}, width, y{2}, height]
collideObject2                  = vars+246      ; 6     collision detection object 2 [x{2}, width, y{2}, height]
passcodeVars                    = vars+252      ; 4     variables to be used in passcode, stored consecutively
passcode                        = vars+256      ; 11    passcode (10 chars plus NULL terminator)
playerHurt                      = vars+267      ; 1     player hurt flag
showHealth                      = vars+268      ; 1     counter for showing player health bar during gameplay
aholeTable                      = vars2+000     ; 21    data for on-screen alien holes [counter, ptr{2}, x{2}, y{2}]
maskBuffer                      = vars2+021     ; 23    buffer for the dark level masking
contrastBuffer                  = vars2+044     ; 1     place to store system contrast setting when fading in & out
treeaddr                        = vars2+045     ; 2     used by huffExtr

.end
